/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.internal;

import io.netty.channel.EventLoop;
import io.vertx.core.Closeable;
import io.vertx.core.Completable;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Timer;
import io.vertx.core.impl.ContextLocalImpl;
import io.vertx.core.impl.ExecuteBlocking;
import io.vertx.core.impl.TimerImpl;
import io.vertx.core.impl.VertxImpl;
import io.vertx.core.impl.future.FailedFuture;
import io.vertx.core.impl.future.PromiseImpl;
import io.vertx.core.impl.future.SucceededFuture;
import io.vertx.core.internal.CloseFuture;
import io.vertx.core.internal.ContextBuilder;
import io.vertx.core.internal.EventExecutor;
import io.vertx.core.internal.PromiseInternal;
import io.vertx.core.internal.VertxInternal;
import io.vertx.core.internal.WorkerPool;
import io.vertx.core.internal.deployment.DeploymentContext;
import io.vertx.core.spi.context.storage.ContextLocal;
import io.vertx.core.spi.tracing.VertxTracer;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public interface ContextInternal
extends Context {
    public static final ContextLocal<ConcurrentMap<Object, Object>> LOCAL_MAP = new ContextLocalImpl<ConcurrentMap>(0, ConcurrentHashMap::new);

    public static ContextInternal current() {
        return VertxImpl.currentContext(Thread.currentThread());
    }

    @Override
    default public void runOnContext(Handler<Void> action) {
        this.executor().execute(() -> this.dispatch(action));
    }

    public EventExecutor executor();

    public EventExecutor eventLoop();

    public EventLoop nettyEventLoop();

    default public <T> PromiseInternal<T> promise() {
        return new PromiseImpl(this);
    }

    default public <T> PromiseInternal<T> promise(Completable<T> p) {
        PromiseInternal<T> promise;
        if (p instanceof PromiseInternal && (promise = (PromiseInternal<T>)p).context() != null) {
            return promise;
        }
        promise = this.promise();
        promise.future().onComplete(p);
        return promise;
    }

    default public <T> Future<T> future(Handler<Promise<T>> handler) {
        PromiseInternal<T> promise = this.promise();
        try {
            handler.handle(promise);
        }
        catch (Throwable t) {
            promise.tryFail(t);
        }
        return promise.future();
    }

    default public <T> Future<T> succeededFuture() {
        return new SucceededFuture<Object>(this, null);
    }

    default public <T> Future<T> succeededFuture(T result2) {
        return new SucceededFuture<T>(this, result2);
    }

    default public <T> Future<T> failedFuture(Throwable failure) {
        return new FailedFuture(this, failure);
    }

    default public <T> Future<T> failedFuture(String message) {
        return new FailedFuture(this, message);
    }

    default public <T> Future<T> executeBlockingInternal(Callable<T> action) {
        return ExecuteBlocking.executeBlocking(this.owner().internalWorkerPool(), this, action, null);
    }

    public WorkerPool workerPool();

    public DeploymentContext deployment();

    @Override
    public VertxInternal owner();

    public boolean inThread();

    public <T> void emit(T var1, Handler<T> var2);

    default public void emit(Handler<Void> task) {
        this.emit(null, task);
    }

    default public void execute(Handler<Void> task) {
        this.execute(null, task);
    }

    public void execute(Runnable var1);

    public <T> void execute(T var1, Handler<T> var2);

    default public boolean isRunningOnContext() {
        return ContextInternal.current() == this && this.inThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void dispatch(Runnable handler) {
        ContextInternal prev = this.beginDispatch();
        try {
            handler.run();
        }
        catch (Throwable t) {
            this.reportException(t);
        }
        finally {
            this.endDispatch(prev);
        }
    }

    default public void dispatch(Handler<Void> handler) {
        this.dispatch(null, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public <E> void dispatch(E event, Handler<E> handler) {
        ContextInternal prev = this.beginDispatch();
        try {
            handler.handle(event);
        }
        catch (Throwable t) {
            this.reportException(t);
        }
        finally {
            this.endDispatch(prev);
        }
    }

    public ContextInternal beginDispatch();

    public void endDispatch(ContextInternal var1);

    public void reportException(Throwable var1);

    public ConcurrentMap<Object, Object> contextData();

    @Override
    default public <T> T get(Object key) {
        return (T)this.contextData().get(key);
    }

    @Override
    default public void put(Object key, Object value) {
        this.contextData().put(key, value);
    }

    @Override
    default public boolean remove(Object key) {
        return this.contextData().remove(key) != null;
    }

    @Deprecated(forRemoval=true)
    default public ConcurrentMap<Object, Object> localContextData() {
        return LOCAL_MAP.get((Context)this, ConcurrentHashMap::new);
    }

    @Deprecated(forRemoval=true)
    default public <T> T getLocal(Object key) {
        return (T)this.localContextData().get(key);
    }

    @Deprecated(forRemoval=true)
    default public void putLocal(Object key, Object value) {
        this.localContextData().put(key, value);
    }

    @Deprecated(forRemoval=true)
    default public boolean removeLocal(Object key) {
        return this.localContextData().remove(key) != null;
    }

    public ClassLoader classLoader();

    public VertxTracer tracer();

    public ContextInternal duplicate(boolean var1);

    default public ContextInternal duplicate() {
        return this.duplicate(false);
    }

    default public long setPeriodic(long delay, Handler<Long> handler) {
        VertxImpl owner2 = (VertxImpl)this.owner();
        return owner2.scheduleTimeout(this, true, delay, TimeUnit.MILLISECONDS, false, handler);
    }

    default public long setTimer(long delay, Handler<Long> handler) {
        VertxImpl owner2 = (VertxImpl)this.owner();
        return owner2.scheduleTimeout(this, false, delay, TimeUnit.MILLISECONDS, false, handler);
    }

    default public Timer timer(long delay) {
        return this.timer(delay, TimeUnit.MILLISECONDS);
    }

    default public Timer timer(long delay, TimeUnit unit) {
        Objects.requireNonNull(unit);
        if (delay <= 0L) {
            throw new IllegalArgumentException("Invalid timer delay: " + delay);
        }
        ScheduledFuture fut = this.nettyEventLoop().schedule(() -> null, delay, unit);
        TimerImpl timer = new TimerImpl(this, (io.netty.util.concurrent.ScheduledFuture<Void>)fut);
        fut.addListener(timer);
        return timer;
    }

    default public boolean isDeployment() {
        return this.deployment() != null;
    }

    @Override
    default public String deploymentID() {
        DeploymentContext deployment = this.deployment();
        return deployment != null ? deployment.id() : null;
    }

    @Override
    default public int getInstanceCount() {
        DeploymentContext deployment = this.deployment();
        if (deployment == null) {
            return 0;
        }
        return deployment.deployment().options().getInstances();
    }

    public CloseFuture closeFuture();

    public Future<Void> close();

    default public void addCloseHook(Closeable hook) {
        this.closeFuture().add(hook);
    }

    default public void removeCloseHook(Closeable hook) {
        this.closeFuture().remove(hook);
    }

    default public ContextInternal unwrap() {
        return this;
    }

    default public boolean isDuplicate() {
        return false;
    }

    public ContextBuilder toBuilder();
}

