/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl.transports;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFactory;
import io.netty.channel.IoHandlerFactory;
import io.netty.channel.ServerChannel;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.InternetProtocolFamily;
import io.netty.channel.unix.DomainSocketAddress;
import io.netty.channel.uring.IoUring;
import io.netty.channel.uring.IoUringChannelOption;
import io.netty.channel.uring.IoUringDatagramChannel;
import io.netty.channel.uring.IoUringIoHandler;
import io.netty.channel.uring.IoUringServerSocketChannel;
import io.netty.channel.uring.IoUringSocketChannel;
import io.vertx.core.datagram.DatagramSocketOptions;
import io.vertx.core.net.ClientOptionsBase;
import io.vertx.core.net.NetServerOptions;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.impl.SocketAddressImpl;
import io.vertx.core.spi.transport.Transport;

public class IoUringTransport
implements Transport {
    private static volatile int pendingFastOpenRequestsThreshold = 256;

    public static int getPendingFastOpenRequestsThreshold() {
        return pendingFastOpenRequestsThreshold;
    }

    public static void setPendingFastOpenRequestsThreshold(int value) {
        if (value < 0) {
            throw new IllegalArgumentException("Invalid " + value);
        }
        pendingFastOpenRequestsThreshold = value;
    }

    @Override
    public boolean supportsDomainSockets() {
        return false;
    }

    @Override
    public boolean supportFileRegion() {
        return false;
    }

    @Override
    public java.net.SocketAddress convert(SocketAddress address) {
        if (address.isDomainSocket()) {
            throw new IllegalArgumentException("Domain socket not supported by IOUring transport");
        }
        return Transport.super.convert(address);
    }

    @Override
    public SocketAddress convert(java.net.SocketAddress address) {
        if (address instanceof DomainSocketAddress) {
            return new SocketAddressImpl(((DomainSocketAddress)address).path());
        }
        return Transport.super.convert(address);
    }

    @Override
    public boolean isAvailable() {
        return IoUring.isAvailable();
    }

    @Override
    public Throwable unavailabilityCause() {
        return IoUring.unavailabilityCause();
    }

    @Override
    public IoHandlerFactory ioHandlerFactory() {
        return IoUringIoHandler.newFactory();
    }

    @Override
    public DatagramChannel datagramChannel() {
        return new IoUringDatagramChannel();
    }

    @Override
    public DatagramChannel datagramChannel(InternetProtocolFamily family) {
        return new IoUringDatagramChannel();
    }

    @Override
    public ChannelFactory<? extends Channel> channelFactory(boolean domainSocket) {
        if (domainSocket) {
            throw new IllegalArgumentException();
        }
        return IoUringSocketChannel::new;
    }

    @Override
    public ChannelFactory<? extends ServerChannel> serverChannelFactory(boolean domainSocket) {
        if (domainSocket) {
            throw new IllegalArgumentException();
        }
        return IoUringServerSocketChannel::new;
    }

    @Override
    public void configure(DatagramChannel channel, DatagramSocketOptions options2) {
        channel.config().setOption(IoUringChannelOption.SO_REUSEPORT, options2.isReusePort());
        Transport.super.configure(channel, options2);
    }

    @Override
    public void configure(NetServerOptions options2, boolean domainSocket, ServerBootstrap bootstrap) {
        if (domainSocket) {
            throw new IllegalArgumentException();
        }
        bootstrap.option(IoUringChannelOption.SO_REUSEPORT, options2.isReusePort());
        if (options2.isTcpFastOpen()) {
            bootstrap.option(IoUringChannelOption.TCP_FASTOPEN, options2.isTcpFastOpen() ? pendingFastOpenRequestsThreshold : 0);
        }
        bootstrap.childOption(IoUringChannelOption.TCP_QUICKACK, options2.isTcpQuickAck());
        bootstrap.childOption(IoUringChannelOption.TCP_CORK, options2.isTcpCork());
        Transport.super.configure(options2, false, bootstrap);
    }

    @Override
    public void configure(ClientOptionsBase options2, int connectTimeout, boolean domainSocket, Bootstrap bootstrap) {
        if (domainSocket) {
            throw new IllegalArgumentException();
        }
        if (options2.isTcpFastOpen()) {
            bootstrap.option(IoUringChannelOption.TCP_FASTOPEN_CONNECT, options2.isTcpFastOpen());
        }
        bootstrap.option(IoUringChannelOption.TCP_QUICKACK, options2.isTcpQuickAck());
        bootstrap.option(IoUringChannelOption.TCP_CORK, options2.isTcpCork());
        Transport.super.configure(options2, connectTimeout, false, bootstrap);
    }
}

