/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl.future;

import io.vertx.core.Completable;
import io.vertx.core.impl.future.Operation;
import io.vertx.core.internal.ContextInternal;
import java.util.function.Function;

class Mapping<T, U>
extends Operation<U>
implements Completable<T> {
    private final Function<? super T, U> successMapper;

    Mapping(ContextInternal context2, Function<? super T, U> successMapper) {
        super(context2);
        this.successMapper = successMapper;
    }

    @Override
    public void complete(T value, Throwable failure) {
        Object result2;
        if (failure == null) {
            try {
                result2 = this.successMapper.apply(value);
            }
            catch (Throwable e) {
                result2 = null;
                failure = e;
            }
        } else {
            result2 = null;
        }
        this.completeInternal(result2, failure);
    }
}

