/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl;

import io.vertx.core.spi.metrics.PoolMetrics;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class WorkerTask
extends AtomicInteger
implements Runnable {
    private final PoolMetrics metrics;
    private final Object queueMetric;
    private Runnable onComplete;

    public WorkerTask(PoolMetrics metrics2, Object queueMetric) {
        this.metrics = metrics2;
        this.queueMetric = queueMetric;
    }

    void onCompletion(Runnable continuation) {
        this.onComplete = continuation;
        if (this.addAndGet(1) > 1) {
            continuation.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object execMetric = null;
        if (this.metrics != null) {
            this.metrics.dequeue(this.queueMetric);
            execMetric = this.metrics.begin();
        }
        try {
            try {
                this.execute();
            }
            finally {
                if (this.addAndGet(1) > 1) {
                    Runnable cont = this.onComplete;
                    cont.run();
                }
            }
        }
        finally {
            if (this.metrics != null) {
                this.metrics.end(execMetric);
            }
        }
    }

    public void reject() {
    }

    protected abstract void execute();
}

