/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl;

import io.vertx.core.impl.VertxImpl;
import io.vertx.core.impl.VertxThread;
import io.vertx.core.impl.WorkerTask;
import io.vertx.core.impl.WorkerTaskQueue;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.EventExecutor;
import io.vertx.core.internal.WorkerPool;
import io.vertx.core.spi.metrics.PoolMetrics;
import java.util.concurrent.CountDownLatch;

public class WorkerExecutor
implements EventExecutor {
    private final WorkerPool workerPool;
    private final WorkerTaskQueue orderedTasks;
    private final ThreadLocal<Boolean> inThread = new ThreadLocal();

    public static WorkerExecutor unwrapWorkerExecutor() {
        Thread thread2 = Thread.currentThread();
        if (thread2 instanceof VertxThread) {
            VertxThread vertxThread = (VertxThread)thread2;
            String msg = vertxThread.isWorker() ? "Cannot be called on a Vert.x worker thread" : "Cannot be called on a Vert.x event-loop thread";
            throw new IllegalStateException(msg);
        }
        ContextInternal ctx = VertxImpl.currentContext(thread2);
        if (ctx != null && ctx.inThread()) {
            return (WorkerExecutor)ctx.executor();
        }
        return null;
    }

    public WorkerExecutor(WorkerPool workerPool, WorkerTaskQueue orderedTasks) {
        this.workerPool = workerPool;
        this.orderedTasks = orderedTasks;
    }

    @Override
    public boolean inThread() {
        return this.inThread.get() == Boolean.TRUE;
    }

    @Override
    public void execute(final Runnable command2) {
        PoolMetrics metrics2 = this.workerPool.metrics();
        Object queueMetric = metrics2 != null ? metrics2.enqueue() : null;
        WorkerTask task = new WorkerTask(metrics2, queueMetric){

            @Override
            protected void execute() {
                WorkerExecutor.this.inThread.set(true);
                try {
                    command2.run();
                }
                finally {
                    WorkerExecutor.this.inThread.remove();
                }
            }
        };
        this.orderedTasks.execute(task, this.workerPool.executor());
    }

    WorkerTaskQueue taskQueue() {
        return this.orderedTasks;
    }

    public Execution currentExecution() {
        return this.orderedTasks.current();
    }

    public static interface Execution {
        public CountDownLatch trySuspend();

        public void resume();

        public void resume(Runnable var1);
    }
}

