/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl.headers;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.util.AsciiString;
import io.netty.util.CharsetUtil;
import io.vertx.core.MultiMap;
import io.vertx.core.http.impl.HttpUtils;
import io.vertx.core.internal.http.HttpHeadersInternal;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public final class HeadersMultiMap
extends HttpHeaders
implements MultiMap {
    private static final int COLON_AND_SPACE_SHORT = 14880;
    private static final int CRLF_SHORT = 3338;
    private static final BiConsumer<CharSequence, CharSequence> HTTP_VALIDATOR = !HttpHeadersInternal.DISABLE_HTTP_HEADERS_VALIDATION ? HttpUtils::validateHeader : null;
    private final BiConsumer<CharSequence, CharSequence> validator;
    private final boolean readOnly;
    private HeadersMultiMap ref;
    private MapEntry[] entries;
    private MapEntry head;
    private MapEntry tail;
    private int modCount = 0;
    private Reference<byte[]> renderedBytesRef;

    public static HeadersMultiMap httpHeaders() {
        return new HeadersMultiMap(false, HTTP_VALIDATOR);
    }

    public static HeadersMultiMap httpHeaders(BiConsumer<CharSequence, CharSequence> validator) {
        return new HeadersMultiMap(false, validator);
    }

    public static HeadersMultiMap caseInsensitive() {
        return new HeadersMultiMap(false, (BiConsumer<CharSequence, CharSequence>)null);
    }

    private HeadersMultiMap(boolean readOnly, BiConsumer<CharSequence, CharSequence> validator) {
        this.head = null;
        this.entries = null;
        this.readOnly = readOnly;
        this.validator = validator;
        this.ref = null;
    }

    private HeadersMultiMap(boolean readOnly, HeadersMultiMap that) {
        this.head = null;
        this.entries = null;
        this.validator = that.validator;
        this.setAll(that);
        this.readOnly = readOnly;
        this.ref = null;
    }

    private HeadersMultiMap(boolean readOnly, MapEntry[] entries2, MapEntry head, BiConsumer<CharSequence, CharSequence> validator, HeadersMultiMap ref) {
        this.readOnly = readOnly;
        this.head = head;
        this.entries = entries2;
        this.validator = validator;
        this.ref = ref;
    }

    @Override
    public HeadersMultiMap setAll(MultiMap multimap) {
        if (multimap instanceof HeadersMultiMap) {
            HeadersMultiMap headers = (HeadersMultiMap)multimap;
            if (headers.readOnly) {
                this.ref = headers;
                this.head = headers.head;
                this.tail = headers.tail;
                this.entries = headers.entries;
            } else {
                this.clear0();
                this.addAll(headers);
            }
        } else {
            this.setAll((Iterable<Map.Entry<String, String>>)multimap);
        }
        ++this.modCount;
        return this;
    }

    @Override
    public HeadersMultiMap setAll(Map<String, String> headers) {
        this.setAll(headers.entrySet());
        ++this.modCount;
        return this;
    }

    @Override
    public int size() {
        return this.names().size();
    }

    @Override
    public HeadersMultiMap add(CharSequence name, CharSequence value) {
        Objects.requireNonNull(value);
        int h = AsciiString.hashCode(name);
        int i = h & 0xF;
        this.add0(h, i, name, value);
        ++this.modCount;
        return this;
    }

    @Override
    public HeadersMultiMap add(CharSequence name, Object value) {
        return this.add(name, HeadersMultiMap.toValidCharSequence(value));
    }

    @Override
    public HttpHeaders add(String name, Object value) {
        return this.add((CharSequence)name, HeadersMultiMap.toValidCharSequence(value));
    }

    @Override
    public HeadersMultiMap add(String name, String strVal) {
        return this.add((CharSequence)name, (CharSequence)strVal);
    }

    public HeadersMultiMap add(CharSequence name, Iterable values2) {
        int h = AsciiString.hashCode(name);
        int i = h & 0xF;
        for (Object vstr : values2) {
            this.add0(h, i, name, HeadersMultiMap.toValidCharSequence(vstr));
        }
        ++this.modCount;
        return this;
    }

    public HeadersMultiMap add(String name, Iterable values2) {
        return this.add((CharSequence)name, values2);
    }

    @Override
    public HeadersMultiMap addAll(MultiMap headers) {
        return this.addAll(headers.entries());
    }

    @Override
    public HeadersMultiMap addAll(Map<String, String> map2) {
        return this.addAll(map2.entrySet());
    }

    public HeadersMultiMap addAll(Iterable<Map.Entry<String, String>> headers) {
        for (Map.Entry<String, String> entry : headers) {
            this.add(entry.getKey(), entry.getValue());
        }
        ++this.modCount;
        return this;
    }

    @Override
    public HeadersMultiMap remove(CharSequence name) {
        Objects.requireNonNull(name, "name");
        int h = AsciiString.hashCode(name);
        int i = h & 0xF;
        this.remove0(h, i, name);
        ++this.modCount;
        return this;
    }

    @Override
    public HeadersMultiMap remove(String name) {
        return this.remove((CharSequence)name);
    }

    @Override
    public HeadersMultiMap set(CharSequence name, CharSequence value) {
        int h = AsciiString.hashCode(name);
        int i = h & 0xF;
        this.remove0(h, i, name);
        if (value != null) {
            this.add0(h, i, name, value);
        }
        ++this.modCount;
        return this;
    }

    @Override
    public HeadersMultiMap set(String name, String value) {
        return this.set((CharSequence)name, (CharSequence)value);
    }

    @Override
    public HeadersMultiMap set(String name, Object value) {
        return this.set((CharSequence)name, HeadersMultiMap.toValidCharSequence(value));
    }

    @Override
    public HeadersMultiMap set(CharSequence name, Object value) {
        return this.set(name, HeadersMultiMap.toValidCharSequence(value));
    }

    public HeadersMultiMap set(CharSequence name, Iterable values2) {
        Objects.requireNonNull(values2, "values");
        int h = AsciiString.hashCode(name);
        int i = h & 0xF;
        this.remove0(h, i, name);
        for (Object v : values2) {
            if (v == null) break;
            this.add0(h, i, name, HeadersMultiMap.toValidCharSequence(v));
        }
        ++this.modCount;
        return this;
    }

    public HeadersMultiMap set(String name, Iterable values2) {
        return this.set((CharSequence)name, values2);
    }

    @Override
    public boolean containsValue(CharSequence name, CharSequence value, boolean ignoreCase) {
        return this.contains(name, value, false, ignoreCase);
    }

    @Override
    public boolean contains(CharSequence name, CharSequence value, boolean ignoreCase) {
        return this.contains(name, value, true, ignoreCase);
    }

    @Override
    public boolean contains(String name, String value, boolean ignoreCase) {
        return this.contains((CharSequence)name, (CharSequence)value, ignoreCase);
    }

    @Override
    public boolean contains(CharSequence name) {
        return this.get0(name) != null;
    }

    @Override
    public boolean contains(String name) {
        return this.contains((CharSequence)name);
    }

    @Override
    public String get(CharSequence name) {
        Objects.requireNonNull(name, "name");
        CharSequence ret = this.get0(name);
        return ret != null ? ret.toString() : null;
    }

    @Override
    public String get(String name) {
        return this.get((CharSequence)name);
    }

    @Override
    public List<String> getAll(CharSequence name) {
        Objects.requireNonNull(name, "name");
        LinkedList<String> values2 = null;
        int h = AsciiString.hashCode(name);
        int i = h & 0xF;
        MapEntry[] etr = this.entries;
        if (etr != null) {
            MapEntry e = etr[i];
            while (e != null) {
                CharSequence key = e.key;
                if (e.hash == h && (name == key || AsciiString.contentEqualsIgnoreCase(name, key))) {
                    if (values2 == null) {
                        values2 = new LinkedList<String>();
                    }
                    values2.addFirst(e.getValue().toString());
                }
                e = e.next;
            }
        }
        return values2 == null ? Collections.emptyList() : Collections.unmodifiableList(values2);
    }

    @Override
    public List<String> getAll(String name) {
        return this.getAll((CharSequence)name);
    }

    @Override
    public void forEach(Consumer<? super Map.Entry<String, String>> action) {
        MapEntry c = this.head;
        while (c != null) {
            action.accept(c.stringEntry());
            c = c.after;
        }
    }

    @Override
    public void forEach(BiConsumer<String, String> action) {
        MapEntry c = this.head;
        while (c != null) {
            action.accept(c.getKey().toString(), c.getValue().toString());
            c = c.after;
        }
    }

    @Override
    public List<Map.Entry<String, String>> entries() {
        return MultiMap.super.entries();
    }

    @Override
    public Iterator<Map.Entry<String, String>> iterator() {
        MapEntry h = this.head;
        if (h == null) {
            return Collections.emptyIterator();
        }
        return new Iterator<Map.Entry<String, String>>(){
            private int numberOfIterations = 0;
            private EntryWrapper next;
            {
                this.next = this.wrapEntry(HeadersMultiMap.this.head);
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public Map.Entry<String, String> next() {
                EntryWrapper n = this.next;
                if (n == null) {
                    throw new NoSuchElementException();
                }
                if (HeadersMultiMap.this.modCount != n.expectedModCount) {
                    throw new ConcurrentModificationException();
                }
                this.next = this.wrapEntry(n.entry.after);
                return n;
            }

            private EntryWrapper wrapEntry(MapEntry e) {
                EntryWrapper entryWrapper;
                if (e != null) {
                    int n = this.numberOfIterations++;
                    entryWrapper = new EntryWrapper(n, e, HeadersMultiMap.this.modCount);
                } else {
                    entryWrapper = null;
                }
                return entryWrapper;
            }

            class EntryWrapper
            implements Map.Entry<String, String> {
                private final int index;
                private int expectedModCount;
                private MapEntry entry;

                public EntryWrapper(int index2, MapEntry entry, int expectedModCount) {
                    this.index = index2;
                    this.entry = entry;
                    this.expectedModCount = expectedModCount;
                }

                @Override
                public String getKey() {
                    return this.entry.key.toString();
                }

                @Override
                public String getValue() {
                    return this.entry.value.toString();
                }

                @Override
                public String setValue(String value) {
                    if (HeadersMultiMap.this.readOnly) {
                        throw new IllegalStateException("Read only");
                    }
                    if (this.expectedModCount != HeadersMultiMap.this.modCount) {
                        throw new ConcurrentModificationException();
                    }
                    if (HeadersMultiMap.this.ref != null) {
                        int i;
                        HeadersMultiMap.this.copyOnWrite();
                        MapEntry e = HeadersMultiMap.this.head;
                        for (i = 0; i < this.index; ++i) {
                            e = e.after;
                        }
                        this.entry = e;
                        MapEntry c = null;
                        while (++i < numberOfIterations) {
                            c = e = e.after;
                        }
                        int modCountValue = ++HeadersMultiMap.this.modCount;
                        next = c != null ? new EntryWrapper(numberOfIterations, c, modCountValue) : null;
                        this.expectedModCount = modCountValue;
                    }
                    return this.entry.setValue(value).toString();
                }

                public String toString() {
                    return this.getKey() + "=" + this.getValue();
                }
            }
        };
    }

    @Override
    public boolean isEmpty() {
        return this.head == null;
    }

    @Override
    public Set<String> names() {
        TreeSet<String> names = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        MapEntry c = this.head;
        while (c != null) {
            names.add(c.getKey().toString());
            c = c.after;
        }
        return names;
    }

    @Override
    public HeadersMultiMap clear() {
        this.clear0();
        ++this.modCount;
        return this;
    }

    private void clear0() {
        if (this.readOnly) {
            throw new IllegalStateException("Read only");
        }
        this.tail = null;
        this.head = null;
        if (this.ref != null) {
            this.entries = null;
        } else if (this.entries != null) {
            Arrays.fill(this.entries, null);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : this) {
            sb.append(entry).append('\n');
        }
        return sb.toString();
    }

    @Override
    public Integer getInt(CharSequence name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getInt(CharSequence name, int defaultValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Short getShort(CharSequence name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public short getShort(CharSequence name, short defaultValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Long getTimeMillis(CharSequence name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getTimeMillis(CharSequence name, long defaultValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<Map.Entry<CharSequence, CharSequence>> iteratorCharSequence() {
        return new Iterator<Map.Entry<CharSequence, CharSequence>>(){
            MapEntry current;
            {
                this.current = HeadersMultiMap.this.head;
            }

            @Override
            public boolean hasNext() {
                return this.current != null;
            }

            @Override
            public Map.Entry<CharSequence, CharSequence> next() {
                MapEntry next2 = this.current;
                this.current = this.current.after;
                return next2;
            }
        };
    }

    @Override
    public HttpHeaders addInt(CharSequence name, int value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public HttpHeaders addShort(CharSequence name, short value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public HttpHeaders setInt(CharSequence name, int value) {
        return this.set(name, (CharSequence)Integer.toString(value));
    }

    @Override
    public HttpHeaders setShort(CharSequence name, short value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isMutable() {
        return !this.readOnly;
    }

    @Override
    public HeadersMultiMap copy(boolean mutable) {
        if (this.readOnly) {
            if (mutable) {
                return new HeadersMultiMap(false, this.entries, this.head, this.validator, this);
            }
            return this;
        }
        if (this.ref == null) {
            return new HeadersMultiMap(!mutable, this);
        }
        if (mutable) {
            return new HeadersMultiMap(false, this.ref.entries, this.ref.head, this.ref.validator, this.ref);
        }
        return this.ref;
    }

    @Override
    public HeadersMultiMap copy() {
        return (HeadersMultiMap)MultiMap.super.copy();
    }

    public void encode(ByteBuf buf, boolean cache2) {
        if (cache2 && this.readOnly) {
            byte[] bytes;
            Reference<byte[]> r = this.renderedBytesRef;
            if (r == null || (bytes = r.get()) == null) {
                int from = buf.writerIndex();
                this.encode0(buf);
                int to = buf.writerIndex();
                bytes = new byte[to - from];
                buf.getBytes(from, bytes);
                this.renderedBytesRef = new SoftReference<byte[]>(bytes);
            } else {
                buf.writeBytes(bytes);
            }
        } else {
            HeadersMultiMap r = this.ref;
            if (r != null) {
                r.encode(buf, cache2);
            } else {
                this.encode0(buf);
            }
        }
    }

    private void encode0(ByteBuf buf) {
        MapEntry c = this.head;
        while (c != null) {
            HeadersMultiMap.encodeHeader(c.key, c.value, buf);
            c = c.after;
        }
    }

    private void addAll(HeadersMultiMap headers) {
        MapEntry c = headers.head;
        while (c != null) {
            int h = AsciiString.hashCode(c.key);
            int i = h & 0xF;
            this.add0(h, i, c.key, c.value);
            c = c.after;
        }
    }

    private void setAll(Iterable<Map.Entry<String, String>> map2) {
        this.clear0();
        for (Map.Entry<String, String> entry : map2) {
            String key = entry.getKey();
            int h = AsciiString.hashCode(key);
            int i = h & 0xF;
            this.add0(h, i, key, entry.getValue());
        }
    }

    private void checkMutable() {
        if (this.readOnly) {
            throw new IllegalStateException("Read only");
        }
        if (this.ref != null) {
            this.copyOnWrite();
        }
    }

    private void copyOnWrite() {
        HeadersMultiMap state2 = this.ref;
        assert (state2 != null);
        this.head = null;
        this.entries = new MapEntry[16];
        this.ref = null;
        this.addAll(state2);
    }

    private boolean contains(CharSequence name, CharSequence value, boolean equals, boolean ignoreCase) {
        MapEntry[] etr = this.entries;
        if (etr != null) {
            int h = AsciiString.hashCode(name);
            int i = h & 0xF;
            MapEntry e = etr[i];
            while (e != null) {
                CharSequence key = e.key;
                if (e.hash == h && (name == key || AsciiString.contentEqualsIgnoreCase(name, key))) {
                    CharSequence other = e.getValue();
                    if (equals ? ignoreCase && AsciiString.contentEqualsIgnoreCase(value, other) || !ignoreCase && AsciiString.contentEquals(value, other) : HeadersMultiMap.contains(value, ignoreCase, other)) {
                        return true;
                    }
                }
                e = e.next;
            }
        }
        return false;
    }

    private static boolean contains(CharSequence s, boolean ignoreCase, CharSequence sub) {
        int prev = 0;
        while (true) {
            int idx;
            int from;
            int to;
            for (to = (idx = AsciiString.indexOf(sub, ',', prev)) == -1 ? sub.length() : idx; to > prev && sub.charAt(to - 1) == ' '; --to) {
            }
            for (from = prev; from < to && sub.charAt(from) == ' '; ++from) {
            }
            int len = to - from;
            if (len > 0 && AsciiString.regionMatches(sub, ignoreCase, from, s, 0, len)) {
                return true;
            }
            if (idx == -1) break;
            prev = idx + 1;
        }
        return false;
    }

    private void remove0(int h, int i, CharSequence name) {
        this.checkMutable();
        MapEntry[] etr = this.entries;
        if (etr == null) {
            return;
        }
        MapEntry e = etr[i];
        MapEntry prev = null;
        while (e != null) {
            MapEntry next2 = e.next;
            CharSequence key = e.key;
            if (e.hash == h && (name == key || AsciiString.contentEqualsIgnoreCase(name, key))) {
                if (prev == null) {
                    etr[i] = next2;
                } else {
                    prev.next = next2;
                }
                if (e.before == null) {
                    this.head = e.after;
                } else {
                    e.before.after = e.after;
                }
                if (e.after == null) {
                    this.tail = e.before;
                } else {
                    e.after.before = e.before;
                }
                e.after = null;
                e.before = null;
            } else {
                prev = e;
            }
            e = next2;
        }
    }

    private void add0(int h, int i, CharSequence name, CharSequence value) {
        MapEntry newEntry;
        this.checkMutable();
        if (this.validator != null) {
            this.validator.accept(name, value);
        }
        if (this.entries == null) {
            this.entries = new MapEntry[16];
        }
        MapEntry e = this.entries[i];
        this.entries[i] = newEntry = new MapEntry(h, name, value);
        newEntry.next = e;
        if (this.head == null) {
            this.head = this.tail = newEntry;
        } else {
            newEntry.before = this.tail;
            this.tail.after = newEntry;
            this.tail = newEntry;
        }
    }

    private CharSequence get0(CharSequence name) {
        int h = AsciiString.hashCode(name);
        int i = h & 0xF;
        CharSequence value = null;
        MapEntry[] etr = this.entries;
        if (etr != null) {
            MapEntry e = etr[i];
            while (e != null) {
                CharSequence key = e.key;
                if (e.hash == h && (name == key || AsciiString.contentEqualsIgnoreCase(name, key))) {
                    value = e.getValue();
                }
                e = e.next;
            }
        }
        return value;
    }

    public static CharSequence toValidCharSequence(Object value) {
        if (value instanceof CharSequence) {
            return (CharSequence)value;
        }
        return value.toString();
    }

    private static void encodeHeader(CharSequence name, CharSequence value, ByteBuf buf) {
        int nameLen = name.length();
        int valueLen = value.length();
        int entryLen = nameLen + valueLen + 4;
        buf.ensureWritable(entryLen);
        int offset2 = buf.writerIndex();
        HeadersMultiMap.writeAscii(buf, offset2, name);
        ByteBufUtil.setShortBE(buf, offset2 += nameLen, 14880);
        HeadersMultiMap.writeAscii(buf, offset2 += 2, value);
        ByteBufUtil.setShortBE(buf, offset2 += valueLen, 3338);
        buf.writerIndex(offset2 += 2);
    }

    private static void writeAscii(ByteBuf buf, int offset2, CharSequence value) {
        if (value instanceof AsciiString) {
            ByteBufUtil.copy((AsciiString)value, 0, buf, offset2, value.length());
        } else {
            buf.setCharSequence(offset2, value, CharsetUtil.US_ASCII);
        }
    }

    private final class MapEntry
    implements Map.Entry<CharSequence, CharSequence> {
        private final int hash;
        private final CharSequence key;
        private CharSequence value;
        private MapEntry next;
        private MapEntry before;
        private MapEntry after;

        MapEntry(int hash, CharSequence key, CharSequence value) {
            this.hash = hash;
            this.key = key;
            this.value = value;
        }

        @Override
        public CharSequence getKey() {
            return this.key;
        }

        @Override
        public CharSequence getValue() {
            return this.value;
        }

        @Override
        public CharSequence setValue(CharSequence value) {
            assert (!HeadersMultiMap.this.readOnly && HeadersMultiMap.this.ref == null);
            Objects.requireNonNull(value, "value");
            if (HeadersMultiMap.this.validator != null) {
                HeadersMultiMap.this.validator.accept("", value);
            }
            CharSequence oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        public String toString() {
            return String.valueOf(this.getKey()) + "=" + String.valueOf(this.getValue());
        }

        private Map.Entry<String, String> stringEntry() {
            if (this.key instanceof String && this.value instanceof String) {
                return this;
            }
            return new AbstractMap.SimpleEntry<String, String>(this.key.toString(), this.value.toString());
        }
    }
}

