/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.EventLoop;
import io.netty.handler.codec.http2.EmptyHttp2Headers;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.util.concurrent.FutureListener;
import io.vertx.core.Future;
import io.vertx.core.MultiMap;
import io.vertx.core.Promise;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpFrame;
import io.vertx.core.http.StreamPriority;
import io.vertx.core.http.impl.Http2ConnectionBase;
import io.vertx.core.http.impl.HttpUtils;
import io.vertx.core.http.impl.headers.Http2HeadersAdaptor;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.PromiseInternal;
import io.vertx.core.internal.VertxInternal;
import io.vertx.core.internal.concurrent.InboundMessageQueue;
import io.vertx.core.internal.concurrent.OutboundMessageQueue;
import io.vertx.core.net.impl.ConnectionBase;
import io.vertx.core.net.impl.MessageWrite;

abstract class VertxHttp2Stream<C extends Http2ConnectionBase> {
    private static final MultiMap EMPTY = new Http2HeadersAdaptor(EmptyHttp2Headers.INSTANCE);
    private final OutboundMessageQueue<MessageWrite> outboundQueue;
    private final InboundMessageQueue<Object> inboundQueue;
    protected final C conn;
    protected final VertxInternal vertx;
    protected final ContextInternal context;
    protected Http2Stream stream;
    private boolean writable;
    private StreamPriority priority;
    private long bytesRead;
    private long bytesWritten;
    protected boolean isConnect;
    private Throwable failure;
    private long reset = -1L;

    VertxHttp2Stream(final C conn, final ContextInternal context2) {
        this.conn = conn;
        this.vertx = ((Http2ConnectionBase)conn).vertx();
        this.context = context2;
        this.inboundQueue = new InboundMessageQueue<Object>(((ConnectionBase)conn).context().eventLoop(), context2.executor()){

            @Override
            protected void handleMessage(Object item2) {
                if (item2 instanceof MultiMap) {
                    VertxHttp2Stream.this.handleEnd((MultiMap)item2);
                } else {
                    Buffer data2 = (Buffer)item2;
                    int len = data2.length();
                    conn.context().emit(null, v -> {
                        if (VertxHttp2Stream.this.stream.state().remoteSideOpen()) {
                            conn.consumeCredits(VertxHttp2Stream.this.stream, len);
                        }
                    });
                    VertxHttp2Stream.this.handleData(data2);
                }
            }
        };
        this.priority = HttpUtils.DEFAULT_STREAM_PRIORITY;
        this.isConnect = false;
        this.writable = true;
        this.outboundQueue = new OutboundMessageQueue<MessageWrite>(((ConnectionBase)conn).context().executor()){

            @Override
            public boolean test(MessageWrite msg) {
                if (VertxHttp2Stream.this.writable) {
                    msg.write();
                    return true;
                }
                return false;
            }

            @Override
            protected void handleDispose(MessageWrite messageWrite) {
                Throwable cause = VertxHttp2Stream.this.failure;
                if (cause == null) {
                    cause = HttpUtils.STREAM_CLOSED_EXCEPTION;
                }
                messageWrite.cancel(cause);
            }

            @Override
            protected void handleDrained() {
                context2.emit(VertxHttp2Stream.this, VertxHttp2Stream::handleWriteQueueDrained);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void init(Http2Stream stream) {
        VertxHttp2Stream vertxHttp2Stream = this;
        synchronized (vertxHttp2Stream) {
            this.stream = stream;
        }
        this.writable = ((Http2ConnectionBase)this.conn).handler.encoder().flowController().isWritable(stream);
        stream.setProperty(((Http2ConnectionBase)this.conn).streamKey, this);
    }

    void onClose() {
        ((ConnectionBase)this.conn).flushBytesWritten();
        this.context.execute(ex -> this.handleClose());
        this.outboundQueue.close();
    }

    void onException(Throwable cause) {
        this.failure = cause;
        this.context.emit(cause, this::handleException);
    }

    void onReset(long code) {
        this.reset = code;
        this.context.emit(code, this::handleReset);
    }

    void onPriorityChange(StreamPriority newPriority) {
        this.context.emit(newPriority, priority -> {
            if (!this.priority.equals(priority)) {
                this.priority = priority;
                this.handlePriorityChange((StreamPriority)priority);
            }
        });
    }

    void onCustomFrame(HttpFrame frame2) {
        this.context.emit(frame2, this::handleCustomFrame);
    }

    void onHeaders(Http2Headers headers, StreamPriority streamPriority) {
    }

    void onData(Buffer data2) {
        this.bytesRead += (long)data2.length();
        ((ConnectionBase)this.conn).reportBytesRead(data2.length());
        this.inboundQueue.write(data2);
    }

    void onWritabilityChanged() {
        boolean bl = this.writable = !this.writable;
        if (this.writable) {
            this.outboundQueue.tryDrain();
        }
    }

    void onEnd() {
        this.onEnd(EMPTY);
    }

    void onEnd(MultiMap trailers) {
        ((ConnectionBase)this.conn).flushBytesRead();
        this.inboundQueue.write((Object)trailers);
    }

    public int id() {
        return this.stream.id();
    }

    long bytesWritten() {
        return this.bytesWritten;
    }

    long bytesRead() {
        return this.bytesRead;
    }

    public boolean isWritable() {
        return this.outboundQueue.isWritable();
    }

    public void write(MessageWrite write) {
        this.outboundQueue.write(write);
    }

    public void doPause() {
        this.inboundQueue.pause();
    }

    public void doFetch(long amount) {
        this.inboundQueue.fetch(amount);
    }

    public boolean isNotWritable() {
        return !this.outboundQueue.isWritable();
    }

    public final Future<Void> writeFrame(int type2, int flags, ByteBuf payload) {
        PromiseInternal<Void> promise = this.context.promise();
        EventLoop eventLoop = ((ConnectionBase)this.conn).context().nettyEventLoop();
        if (eventLoop.inEventLoop()) {
            this.doWriteFrame(type2, flags, payload, promise);
        } else {
            eventLoop.execute(() -> this.doWriteFrame(type2, flags, payload, promise));
        }
        return promise.future();
    }

    public final void writeFrame(int type2, int flags, ByteBuf payload, Promise<Void> promise) {
        EventLoop eventLoop = ((ConnectionBase)this.conn).context().nettyEventLoop();
        if (eventLoop.inEventLoop()) {
            this.doWriteFrame(type2, flags, payload, promise);
        } else {
            eventLoop.execute(() -> this.doWriteFrame(type2, flags, payload, promise));
        }
    }

    private void doWriteFrame(int type2, int flags, ByteBuf payload, Promise<Void> promise) {
        ((Http2ConnectionBase)this.conn).handler.writeFrame(this.stream, (byte)type2, (short)flags, payload, (FutureListener)((Object)promise));
    }

    final void writeHeaders(final Http2Headers headers, boolean first2, final boolean end2, final boolean checkFlush, final Promise<Void> promise) {
        if (first2) {
            EventLoop eventLoop = ((ConnectionBase)this.conn).context().nettyEventLoop();
            if (eventLoop.inEventLoop()) {
                this.doWriteHeaders(headers, end2, checkFlush, promise);
            } else {
                eventLoop.execute(() -> this.doWriteHeaders(headers, end2, checkFlush, promise));
            }
        } else {
            this.outboundQueue.write(new MessageWrite(){

                @Override
                public void write() {
                    VertxHttp2Stream.this.doWriteHeaders(headers, end2, checkFlush, promise);
                }

                @Override
                public void cancel(Throwable cause) {
                    promise.fail(cause);
                }
            });
        }
    }

    void doWriteHeaders(Http2Headers headers, boolean end2, boolean checkFlush, Promise<Void> promise) {
        if (this.reset != -1L) {
            if (promise != null) {
                promise.fail("Stream reset");
            }
            return;
        }
        if (this.failure != null) {
            if (promise != null) {
                promise.fail(this.failure);
            }
            return;
        }
        if (end2) {
            this.endWritten();
        }
        ((Http2ConnectionBase)this.conn).handler.writeHeaders(this.stream, headers, end2, this.priority.getDependency(), this.priority.getWeight(), this.priority.isExclusive(), checkFlush, (FutureListener)((Object)promise));
    }

    protected void endWritten() {
    }

    private void writePriorityFrame(StreamPriority priority) {
        ((Http2ConnectionBase)this.conn).handler.writePriority(this.stream, priority.getDependency(), priority.getWeight(), priority.isExclusive());
    }

    final void writeData(final ByteBuf chunk, final boolean end2, final Promise<Void> promise) {
        this.outboundQueue.write(new MessageWrite(){

            @Override
            public void write() {
                VertxHttp2Stream.this.doWriteData(chunk, end2, promise);
            }

            @Override
            public void cancel(Throwable cause) {
                promise.fail(cause);
            }
        });
    }

    void doWriteData(ByteBuf buf, boolean end2, Promise<Void> promise) {
        if (this.reset != -1L) {
            promise.fail("Stream reset");
            return;
        }
        if (this.failure != null) {
            promise.fail(this.failure);
            return;
        }
        ByteBuf chunk = buf == null && end2 ? Unpooled.EMPTY_BUFFER : buf;
        int numOfBytes = chunk.readableBytes();
        this.bytesWritten += (long)numOfBytes;
        ((ConnectionBase)this.conn).reportBytesWritten(numOfBytes);
        if (end2) {
            this.endWritten();
        }
        ((Http2ConnectionBase)this.conn).handler.writeData(this.stream, chunk, end2, (FutureListener)((Object)promise));
    }

    final Future<Void> writeReset(long code) {
        if (code < 0L) {
            throw new IllegalArgumentException("Invalid reset code value");
        }
        PromiseInternal<Void> promise = this.context.promise();
        EventLoop eventLoop = ((ConnectionBase)this.conn).context().nettyEventLoop();
        if (eventLoop.inEventLoop()) {
            this.doWriteReset(code, promise);
        } else {
            eventLoop.execute(() -> this.doWriteReset(code, promise));
        }
        return promise.future();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doWriteReset(long code, Promise<Void> promise) {
        int streamId;
        if (this.reset != -1L) {
            promise.fail("Stream already reset");
            return;
        }
        this.reset = code;
        VertxHttp2Stream vertxHttp2Stream = this;
        synchronized (vertxHttp2Stream) {
            streamId = this.stream != null ? this.stream.id() : -1;
        }
        if (streamId != -1) {
            ((Http2ConnectionBase)this.conn).handler.writeReset(streamId, code, null);
        } else {
            this.handleReset(code);
        }
        promise.complete();
    }

    void handleWriteQueueDrained() {
    }

    void handleData(Buffer buf) {
    }

    void handleCustomFrame(HttpFrame frame2) {
    }

    void handleEnd(MultiMap trailers) {
    }

    void handleReset(long errorCode) {
    }

    void handleException(Throwable cause) {
    }

    void handleClose() {
    }

    synchronized void priority(StreamPriority streamPriority) {
        this.priority = streamPriority;
    }

    synchronized StreamPriority priority() {
        return this.priority;
    }

    synchronized void updatePriority(StreamPriority priority) {
        if (!this.priority.equals(priority)) {
            this.priority = priority;
            if (this.stream != null) {
                this.writePriorityFrame(priority);
            }
        }
    }

    void handlePriorityChange(StreamPriority newPriority) {
    }
}

