/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpFrame;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.StreamPriority;
import io.vertx.core.http.impl.HttpClientConnectionInternal;
import io.vertx.core.http.impl.HttpClientPush;
import io.vertx.core.http.impl.HttpRequestHead;
import io.vertx.core.http.impl.HttpResponseHead;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.buffer.BufferInternal;
import io.vertx.core.streams.WriteStream;

public interface HttpClientStream
extends WriteStream<Buffer> {
    public int id();

    public Object metric();

    public Object trace();

    public HttpVersion version();

    public HttpClientConnectionInternal connection();

    public ContextInternal getContext();

    public Future<Void> writeHead(HttpRequestHead var1, boolean var2, ByteBuf var3, boolean var4, StreamPriority var5, boolean var6);

    public Future<Void> writeBuffer(ByteBuf var1, boolean var2);

    public Future<Void> writeFrame(int var1, int var2, ByteBuf var3);

    public void continueHandler(Handler<Void> var1);

    public void earlyHintsHandler(Handler<MultiMap> var1);

    public void pushHandler(Handler<HttpClientPush> var1);

    public void unknownFrameHandler(Handler<HttpFrame> var1);

    @Override
    default public Future<Void> write(Buffer data2) {
        return this.writeBuffer(((BufferInternal)data2).getByteBuf(), false);
    }

    @Override
    default public Future<Void> end(Buffer data2) {
        return this.writeBuffer(((BufferInternal)data2).getByteBuf(), true);
    }

    @Override
    default public Future<Void> end() {
        return this.writeBuffer(Unpooled.EMPTY_BUFFER, true);
    }

    public void headHandler(Handler<HttpResponseHead> var1);

    public void chunkHandler(Handler<Buffer> var1);

    public void endHandler(Handler<MultiMap> var1);

    public void priorityHandler(Handler<StreamPriority> var1);

    public void closeHandler(Handler<Void> var1);

    public void doSetWriteQueueMaxSize(int var1);

    public boolean isNotWritable();

    public void doPause();

    public void doFetch(long var1);

    public Future<Void> reset(Throwable var1);

    public StreamPriority priority();

    public void updatePriority(StreamPriority var1);
}

