/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.compression.CompressionOptions;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.HttpContentCompressor;
import io.netty.handler.codec.http.HttpContentEncoder;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponse;

final class HttpChunkContentCompressor
extends HttpContentCompressor {
    public HttpChunkContentCompressor(int contentSizeThreshold, CompressionOptions ... compressionOptions) {
        super(contentSizeThreshold, compressionOptions);
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        ByteBuf buff;
        if (msg instanceof ByteBuf && (buff = (ByteBuf)msg).isReadable()) {
            msg = new DefaultHttpContent(buff);
        }
        super.write(ctx, msg, promise);
    }

    @Override
    protected HttpContentEncoder.Result beginEncode(HttpResponse httpResponse, String acceptEncoding) throws Exception {
        HttpContentEncoder.Result result2 = super.beginEncode(httpResponse, acceptEncoding);
        if (result2 == null && httpResponse.headers().contains(HttpHeaderNames.CONTENT_ENCODING, (CharSequence)"identity", true)) {
            httpResponse.headers().remove(HttpHeaderNames.CONTENT_ENCODING);
        }
        return result2;
    }
}

