/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.FileRegion;
import io.netty.handler.codec.http.FullHttpMessage;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.stream.ChunkedFile;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.GoAway;
import io.vertx.core.http.Http2Settings;
import io.vertx.core.http.HttpConnection;
import io.vertx.core.http.impl.VertxAssembledHttpResponse;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.net.impl.VertxConnection;
import java.util.concurrent.TimeUnit;

abstract class Http1xConnection
extends VertxConnection
implements HttpConnection {
    protected boolean closeInitiated;
    protected boolean shutdownInitiated;
    protected Object closeReason;
    protected long shutdownTimeout;
    protected TimeUnit shutdownUnit;
    protected ChannelPromise closePromise;

    Http1xConnection(ContextInternal context2, ChannelHandlerContext chctx) {
        this(context2, chctx, false);
    }

    Http1xConnection(ContextInternal context2, ChannelHandlerContext chctx, boolean strictMode) {
        super(context2, chctx, strictMode);
    }

    @Override
    protected void handleShutdown(Object reason, long timeout2, TimeUnit unit, ChannelPromise promise) {
        this.shutdownInitiated = true;
        this.closeReason = reason;
        this.shutdownTimeout = timeout2;
        this.shutdownUnit = unit;
        this.closePromise = promise;
    }

    @Override
    protected void handleClose(Object reason, ChannelPromise promise) {
        this.closeInitiated = true;
        super.handleClose(reason, promise);
    }

    protected void closeInternal() {
        if (!this.closeInitiated) {
            if (this.shutdownInitiated) {
                super.handleShutdown(this.closeReason, this.shutdownTimeout, this.shutdownUnit, this.closePromise);
            } else {
                this.chctx.channel().close();
            }
        }
    }

    @Override
    public Http1xConnection closeHandler(Handler<Void> handler) {
        return (Http1xConnection)super.closeHandler(handler);
    }

    @Override
    public Http1xConnection shutdownHandler(Handler<Void> handler) {
        return (Http1xConnection)super.shutdownHandler(handler);
    }

    @Override
    public Http1xConnection exceptionHandler(Handler<Throwable> handler) {
        return (Http1xConnection)super.exceptionHandler(handler);
    }

    @Override
    public HttpConnection goAway(long errorCode, int lastStreamId, Buffer debugData) {
        throw new UnsupportedOperationException("HTTP/1.x connections don't support GOAWAY");
    }

    @Override
    public HttpConnection goAwayHandler(@Nullable Handler<GoAway> handler) {
        throw new UnsupportedOperationException("HTTP/1.x connections don't support GOAWAY");
    }

    @Override
    public Http2Settings settings() {
        throw new UnsupportedOperationException("HTTP/1.x connections don't support SETTINGS");
    }

    @Override
    public Future<Void> updateSettings(Http2Settings settings) {
        throw new UnsupportedOperationException("HTTP/1.x connections don't support SETTINGS");
    }

    @Override
    public Http2Settings remoteSettings() {
        throw new UnsupportedOperationException("HTTP/1.x connections don't support SETTINGS");
    }

    @Override
    public HttpConnection remoteSettingsHandler(Handler<Http2Settings> handler) {
        throw new UnsupportedOperationException("HTTP/1.x connections don't support SETTINGS");
    }

    @Override
    public HttpConnection pingHandler(@Nullable Handler<Buffer> handler) {
        throw new UnsupportedOperationException("HTTP/1.x connections don't support PING");
    }

    @Override
    public Future<Buffer> ping(Buffer data2) {
        throw new UnsupportedOperationException("HTTP/1.x connections don't support PING");
    }

    @Override
    protected long sizeof(Object obj) {
        if (obj == Unpooled.EMPTY_BUFFER || obj == LastHttpContent.EMPTY_LAST_CONTENT) {
            return 0L;
        }
        if (obj instanceof VertxAssembledHttpResponse) {
            return ((VertxAssembledHttpResponse)obj).content().readableBytes();
        }
        if (obj instanceof Buffer) {
            return ((Buffer)obj).length();
        }
        if (obj instanceof ByteBuf) {
            return ((ByteBuf)obj).readableBytes();
        }
        if (obj instanceof FullHttpMessage) {
            return ((FullHttpMessage)obj).content().readableBytes();
        }
        if (obj instanceof LastHttpContent) {
            return ((LastHttpContent)obj).content().readableBytes();
        }
        if (obj instanceof HttpContent) {
            return ((HttpContent)obj).content().readableBytes();
        }
        if (obj instanceof FileRegion) {
            return ((FileRegion)obj).count();
        }
        if (obj instanceof ChunkedFile) {
            ChunkedFile file = (ChunkedFile)obj;
            return file.endOffset() - file.startOffset();
        }
        return 0L;
    }
}

