/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.vertx.core.net.ClientSSLOptions;
import io.vertx.core.net.HostAndPort;
import io.vertx.core.net.ProxyOptions;
import io.vertx.core.net.SocketAddress;
import java.util.Objects;

public final class EndpointKey {
    final boolean ssl;
    final SocketAddress server;
    final HostAndPort authority;
    final ProxyOptions proxyOptions;
    final ClientSSLOptions sslOptions;

    public EndpointKey(boolean ssl, ClientSSLOptions sslOptions, ProxyOptions proxyOptions, SocketAddress server, HostAndPort authority) {
        if (server == null) {
            throw new NullPointerException("No null server address");
        }
        this.ssl = ssl;
        this.sslOptions = sslOptions;
        this.proxyOptions = proxyOptions;
        this.authority = authority;
        this.server = server;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof EndpointKey) {
            EndpointKey that = (EndpointKey)o;
            return this.ssl == that.ssl && this.server.equals(that.server) && Objects.equals(this.authority, that.authority) && Objects.equals(this.sslOptions, that.sslOptions) && EndpointKey.equals(this.proxyOptions, that.proxyOptions);
        }
        return false;
    }

    public int hashCode() {
        int result2 = this.ssl ? 1 : 0;
        result2 = 31 * result2 + this.server.hashCode();
        if (this.authority != null) {
            result2 = 31 * result2 + this.authority.hashCode();
        }
        if (this.sslOptions != null) {
            result2 = 31 * result2 + this.sslOptions.hashCode();
        }
        if (this.proxyOptions != null) {
            result2 = 31 * result2 + EndpointKey.hashCode(this.proxyOptions);
        }
        return result2;
    }

    private static boolean equals(ProxyOptions options1, ProxyOptions options2) {
        if (options1 == options2) {
            return true;
        }
        if (options1 != null && options2 != null) {
            return Objects.equals(options1.getHost(), options2.getHost()) && options1.getPort() == options2.getPort() && Objects.equals(options1.getUsername(), options2.getUsername()) && Objects.equals(options1.getPassword(), options2.getPassword());
        }
        return false;
    }

    private static int hashCode(ProxyOptions options2) {
        if (options2.getUsername() != null && options2.getPassword() != null) {
            return Objects.hash(new Object[]{options2.getHost(), options2.getPort(), options2.getType(), options2.getUsername(), options2.getPassword()});
        }
        return Objects.hash(new Object[]{options2.getHost(), options2.getPort(), options2.getType()});
    }

    public String toString() {
        return this.server.toString();
    }
}

