/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http;

import io.vertx.core.http.Http2Settings;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.tracing.TracingPolicy;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class HttpServerOptionsConverter {
    static void fromJson(Iterable<Map.Entry<String, Object>> json2, HttpServerOptions obj) {
        for (Map.Entry<String, Object> member : json2) {
            switch (member.getKey()) {
                case "compressionSupported": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setCompressionSupported((Boolean)member.getValue());
                    break;
                }
                case "compressionLevel": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setCompressionLevel(((Number)member.getValue()).intValue());
                    break;
                }
                case "compressionContentSizeThreshold": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setCompressionContentSizeThreshold(((Number)member.getValue()).intValue());
                    break;
                }
                case "acceptUnmaskedFrames": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setAcceptUnmaskedFrames((Boolean)member.getValue());
                    break;
                }
                case "maxWebSocketFrameSize": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setMaxWebSocketFrameSize(((Number)member.getValue()).intValue());
                    break;
                }
                case "maxWebSocketMessageSize": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setMaxWebSocketMessageSize(((Number)member.getValue()).intValue());
                    break;
                }
                case "webSocketSubProtocols": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<String> list2 = new ArrayList<String>();
                    ((Iterable)member.getValue()).forEach(item2 -> {
                        if (item2 instanceof String) {
                            list2.add((String)item2);
                        }
                    });
                    obj.setWebSocketSubProtocols(list2);
                    break;
                }
                case "handle100ContinueAutomatically": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setHandle100ContinueAutomatically((Boolean)member.getValue());
                    break;
                }
                case "maxChunkSize": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setMaxChunkSize(((Number)member.getValue()).intValue());
                    break;
                }
                case "maxInitialLineLength": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setMaxInitialLineLength(((Number)member.getValue()).intValue());
                    break;
                }
                case "maxHeaderSize": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setMaxHeaderSize(((Number)member.getValue()).intValue());
                    break;
                }
                case "maxFormAttributeSize": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setMaxFormAttributeSize(((Number)member.getValue()).intValue());
                    break;
                }
                case "maxFormFields": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setMaxFormFields(((Number)member.getValue()).intValue());
                    break;
                }
                case "maxFormBufferedBytes": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setMaxFormBufferedBytes(((Number)member.getValue()).intValue());
                    break;
                }
                case "initialSettings": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setInitialSettings(new Http2Settings((JsonObject)member.getValue()));
                    break;
                }
                case "alpnVersions": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<String> list2 = new ArrayList();
                    ((Iterable)member.getValue()).forEach(item2 -> {
                        if (item2 instanceof String) {
                            list2.add((String)((Object)HttpVersion.valueOf((String)item2)));
                        }
                    });
                    obj.setAlpnVersions(list2);
                    break;
                }
                case "http2ClearTextEnabled": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setHttp2ClearTextEnabled((Boolean)member.getValue());
                    break;
                }
                case "http2ConnectionWindowSize": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setHttp2ConnectionWindowSize(((Number)member.getValue()).intValue());
                    break;
                }
                case "decompressionSupported": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setDecompressionSupported((Boolean)member.getValue());
                    break;
                }
                case "decoderInitialBufferSize": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setDecoderInitialBufferSize(((Number)member.getValue()).intValue());
                    break;
                }
                case "perFrameWebSocketCompressionSupported": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setPerFrameWebSocketCompressionSupported((Boolean)member.getValue());
                    break;
                }
                case "perMessageWebSocketCompressionSupported": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setPerMessageWebSocketCompressionSupported((Boolean)member.getValue());
                    break;
                }
                case "webSocketCompressionLevel": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setWebSocketCompressionLevel(((Number)member.getValue()).intValue());
                    break;
                }
                case "webSocketAllowServerNoContext": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setWebSocketAllowServerNoContext((Boolean)member.getValue());
                    break;
                }
                case "webSocketPreferredClientNoContext": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setWebSocketPreferredClientNoContext((Boolean)member.getValue());
                    break;
                }
                case "webSocketClosingTimeout": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setWebSocketClosingTimeout(((Number)member.getValue()).intValue());
                    break;
                }
                case "tracingPolicy": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setTracingPolicy(TracingPolicy.valueOf((String)member.getValue()));
                    break;
                }
                case "registerWebSocketWriteHandlers": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setRegisterWebSocketWriteHandlers((Boolean)member.getValue());
                    break;
                }
                case "http2RstFloodMaxRstFramePerWindow": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setHttp2RstFloodMaxRstFramePerWindow(((Number)member.getValue()).intValue());
                    break;
                }
                case "http2RstFloodWindowDuration": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setHttp2RstFloodWindowDuration(((Number)member.getValue()).intValue());
                    break;
                }
                case "http2RstFloodWindowDurationTimeUnit": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setHttp2RstFloodWindowDurationTimeUnit(TimeUnit.valueOf((String)member.getValue()));
                    break;
                }
                case "strictThreadMode": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setStrictThreadMode((Boolean)member.getValue());
                }
            }
        }
    }

    static void toJson(HttpServerOptions obj, JsonObject json2) {
        HttpServerOptionsConverter.toJson(obj, json2.getMap());
    }

    static void toJson(HttpServerOptions obj, Map<String, Object> json2) {
        JsonArray array;
        json2.put("compressionSupported", obj.isCompressionSupported());
        json2.put("compressionLevel", obj.getCompressionLevel());
        json2.put("compressionContentSizeThreshold", obj.getCompressionContentSizeThreshold());
        json2.put("acceptUnmaskedFrames", obj.isAcceptUnmaskedFrames());
        json2.put("maxWebSocketFrameSize", obj.getMaxWebSocketFrameSize());
        json2.put("maxWebSocketMessageSize", obj.getMaxWebSocketMessageSize());
        if (obj.getWebSocketSubProtocols() != null) {
            array = new JsonArray();
            obj.getWebSocketSubProtocols().forEach(item2 -> array.add(item2));
            json2.put("webSocketSubProtocols", array);
        }
        json2.put("handle100ContinueAutomatically", obj.isHandle100ContinueAutomatically());
        json2.put("maxChunkSize", obj.getMaxChunkSize());
        json2.put("maxInitialLineLength", obj.getMaxInitialLineLength());
        json2.put("maxHeaderSize", obj.getMaxHeaderSize());
        json2.put("maxFormAttributeSize", obj.getMaxFormAttributeSize());
        json2.put("maxFormFields", obj.getMaxFormFields());
        json2.put("maxFormBufferedBytes", obj.getMaxFormBufferedBytes());
        if (obj.getInitialSettings() != null) {
            json2.put("initialSettings", obj.getInitialSettings().toJson());
        }
        if (obj.getAlpnVersions() != null) {
            array = new JsonArray();
            obj.getAlpnVersions().forEach(item2 -> array.add(item2.name()));
            json2.put("alpnVersions", array);
        }
        json2.put("http2ClearTextEnabled", obj.isHttp2ClearTextEnabled());
        json2.put("http2ConnectionWindowSize", obj.getHttp2ConnectionWindowSize());
        json2.put("decompressionSupported", obj.isDecompressionSupported());
        json2.put("decoderInitialBufferSize", obj.getDecoderInitialBufferSize());
        json2.put("perFrameWebSocketCompressionSupported", obj.getPerFrameWebSocketCompressionSupported());
        json2.put("perMessageWebSocketCompressionSupported", obj.getPerMessageWebSocketCompressionSupported());
        json2.put("webSocketCompressionLevel", obj.getWebSocketCompressionLevel());
        json2.put("webSocketAllowServerNoContext", obj.getWebSocketAllowServerNoContext());
        json2.put("webSocketPreferredClientNoContext", obj.getWebSocketPreferredClientNoContext());
        json2.put("webSocketClosingTimeout", obj.getWebSocketClosingTimeout());
        if (obj.getTracingPolicy() != null) {
            json2.put("tracingPolicy", obj.getTracingPolicy().name());
        }
        json2.put("registerWebSocketWriteHandlers", obj.isRegisterWebSocketWriteHandlers());
        json2.put("http2RstFloodMaxRstFramePerWindow", obj.getHttp2RstFloodMaxRstFramePerWindow());
        json2.put("http2RstFloodWindowDuration", obj.getHttp2RstFloodWindowDuration());
        if (obj.getHttp2RstFloodWindowDurationTimeUnit() != null) {
            json2.put("http2RstFloodWindowDurationTimeUnit", obj.getHttp2RstFloodWindowDurationTimeUnit().name());
        }
        json2.put("strictThreadMode", obj.getStrictThreadMode());
    }
}

