/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.json.annotations.JsonGen;
import io.vertx.core.VertxException;
import io.vertx.core.http.HttpConnectOptionsConverter;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.Address;
import io.vertx.core.net.ClientSSLOptions;
import io.vertx.core.net.ProxyOptions;
import io.vertx.core.net.SocketAddress;
import java.net.MalformedURLException;
import java.net.URL;

@DataObject
@JsonGen(publicConverter=false)
public class HttpConnectOptions {
    public static final ProxyOptions DEFAULT_PROXY_OPTIONS = null;
    public static final SocketAddress DEFAULT_SERVER = null;
    public static final String DEFAULT_HOST = null;
    public static final Integer DEFAULT_PORT = null;
    public static final Boolean DEFAULT_SSL = null;
    public static final long DEFAULT_CONNECT_TIMEOUT = -1L;
    private ProxyOptions proxyOptions;
    private Address server;
    private String host;
    private Integer port;
    private Boolean ssl;
    private ClientSSLOptions sslOptions;
    private long connectTimeout;

    public HttpConnectOptions() {
        this.init();
    }

    public HttpConnectOptions(HttpConnectOptions other) {
        this.init();
        this.setProxyOptions(other.proxyOptions);
        this.setServer(other.server);
        this.setHost(other.host);
        this.setPort(other.port);
        this.setSsl(other.ssl);
        this.sslOptions = other.sslOptions != null ? new ClientSSLOptions(other.sslOptions) : null;
        this.setConnectTimeout(other.connectTimeout);
    }

    public HttpConnectOptions(JsonObject json2) {
        this.init();
        HttpConnectOptionsConverter.fromJson(json2, this);
        JsonObject server = json2.getJsonObject("server");
        if (server != null) {
            this.server = SocketAddress.fromJson(server);
        }
    }

    protected void init() {
        this.proxyOptions = DEFAULT_PROXY_OPTIONS;
        this.server = DEFAULT_SERVER;
        this.host = DEFAULT_HOST;
        this.port = DEFAULT_PORT;
        this.ssl = DEFAULT_SSL;
        this.sslOptions = null;
        this.connectTimeout = -1L;
    }

    public ProxyOptions getProxyOptions() {
        return this.proxyOptions;
    }

    public HttpConnectOptions setProxyOptions(ProxyOptions proxyOptions) {
        this.proxyOptions = proxyOptions;
        return this;
    }

    public Address getServer() {
        return this.server;
    }

    public HttpConnectOptions setServer(Address server) {
        this.server = server;
        return this;
    }

    public String getHost() {
        return this.host;
    }

    public HttpConnectOptions setHost(String host) {
        this.host = host;
        return this;
    }

    public Integer getPort() {
        return this.port;
    }

    public HttpConnectOptions setPort(Integer port) {
        this.port = port;
        return this;
    }

    public Boolean isSsl() {
        return this.ssl;
    }

    public HttpConnectOptions setSsl(Boolean ssl) {
        this.ssl = ssl;
        return this;
    }

    public ClientSSLOptions getSslOptions() {
        return this.sslOptions;
    }

    public HttpConnectOptions setSslOptions(ClientSSLOptions sslOptions) {
        this.sslOptions = sslOptions;
        return this;
    }

    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    public HttpConnectOptions setConnectTimeout(long timeout2) {
        this.connectTimeout = timeout2;
        return this;
    }

    private URL parseUrl(String surl) {
        try {
            return new URL(surl);
        }
        catch (MalformedURLException e) {
            throw new VertxException("Invalid url: " + surl, e);
        }
    }

    public JsonObject toJson() {
        JsonObject json2 = new JsonObject();
        HttpConnectOptionsConverter.toJson(this, json2);
        Address serverAddr = this.server;
        if (serverAddr instanceof SocketAddress) {
            SocketAddress socketAddr = (SocketAddress)serverAddr;
            json2.put("server", socketAddr.toJson());
        }
        return json2;
    }
}

