/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http;

import io.vertx.core.http.Http2Settings;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.tracing.TracingPolicy;
import java.util.ArrayList;
import java.util.Map;

public class HttpClientOptionsConverter {
    static void fromJson(Iterable<Map.Entry<String, Object>> json2, HttpClientOptions obj) {
        for (Map.Entry<String, Object> member : json2) {
            switch (member.getKey()) {
                case "http2MultiplexingLimit": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setHttp2MultiplexingLimit(((Number)member.getValue()).intValue());
                    break;
                }
                case "http2ConnectionWindowSize": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setHttp2ConnectionWindowSize(((Number)member.getValue()).intValue());
                    break;
                }
                case "http2KeepAliveTimeout": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setHttp2KeepAliveTimeout(((Number)member.getValue()).intValue());
                    break;
                }
                case "http2UpgradeMaxContentLength": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setHttp2UpgradeMaxContentLength(((Number)member.getValue()).intValue());
                    break;
                }
                case "keepAlive": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setKeepAlive((Boolean)member.getValue());
                    break;
                }
                case "keepAliveTimeout": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setKeepAliveTimeout(((Number)member.getValue()).intValue());
                    break;
                }
                case "pipelining": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setPipelining((Boolean)member.getValue());
                    break;
                }
                case "pipeliningLimit": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setPipeliningLimit(((Number)member.getValue()).intValue());
                    break;
                }
                case "verifyHost": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setVerifyHost((Boolean)member.getValue());
                    break;
                }
                case "decompressionSupported": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setDecompressionSupported((Boolean)member.getValue());
                    break;
                }
                case "defaultHost": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setDefaultHost((String)member.getValue());
                    break;
                }
                case "defaultPort": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setDefaultPort(((Number)member.getValue()).intValue());
                    break;
                }
                case "protocolVersion": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setProtocolVersion(HttpVersion.valueOf((String)member.getValue()));
                    break;
                }
                case "maxChunkSize": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setMaxChunkSize(((Number)member.getValue()).intValue());
                    break;
                }
                case "maxInitialLineLength": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setMaxInitialLineLength(((Number)member.getValue()).intValue());
                    break;
                }
                case "maxHeaderSize": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setMaxHeaderSize(((Number)member.getValue()).intValue());
                    break;
                }
                case "initialSettings": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setInitialSettings(new Http2Settings((JsonObject)member.getValue()));
                    break;
                }
                case "alpnVersions": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<HttpVersion> list2 = new ArrayList<HttpVersion>();
                    ((Iterable)member.getValue()).forEach(item2 -> {
                        if (item2 instanceof String) {
                            list2.add(HttpVersion.valueOf((String)item2));
                        }
                    });
                    obj.setAlpnVersions(list2);
                    break;
                }
                case "http2ClearTextUpgrade": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setHttp2ClearTextUpgrade((Boolean)member.getValue());
                    break;
                }
                case "http2ClearTextUpgradeWithPreflightRequest": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setHttp2ClearTextUpgradeWithPreflightRequest((Boolean)member.getValue());
                    break;
                }
                case "maxRedirects": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setMaxRedirects(((Number)member.getValue()).intValue());
                    break;
                }
                case "forceSni": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setForceSni((Boolean)member.getValue());
                    break;
                }
                case "decoderInitialBufferSize": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setDecoderInitialBufferSize(((Number)member.getValue()).intValue());
                    break;
                }
                case "tracingPolicy": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setTracingPolicy(TracingPolicy.valueOf((String)member.getValue()));
                    break;
                }
                case "shared": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setShared((Boolean)member.getValue());
                    break;
                }
                case "name": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setName((String)member.getValue());
                }
            }
        }
    }

    static void toJson(HttpClientOptions obj, JsonObject json2) {
        HttpClientOptionsConverter.toJson(obj, json2.getMap());
    }

    static void toJson(HttpClientOptions obj, Map<String, Object> json2) {
        json2.put("http2MultiplexingLimit", obj.getHttp2MultiplexingLimit());
        json2.put("http2ConnectionWindowSize", obj.getHttp2ConnectionWindowSize());
        json2.put("http2KeepAliveTimeout", obj.getHttp2KeepAliveTimeout());
        json2.put("http2UpgradeMaxContentLength", obj.getHttp2UpgradeMaxContentLength());
        json2.put("keepAlive", obj.isKeepAlive());
        json2.put("keepAliveTimeout", obj.getKeepAliveTimeout());
        json2.put("pipelining", obj.isPipelining());
        json2.put("pipeliningLimit", obj.getPipeliningLimit());
        json2.put("verifyHost", obj.isVerifyHost());
        json2.put("decompressionSupported", obj.isDecompressionSupported());
        if (obj.getDefaultHost() != null) {
            json2.put("defaultHost", obj.getDefaultHost());
        }
        json2.put("defaultPort", obj.getDefaultPort());
        if (obj.getProtocolVersion() != null) {
            json2.put("protocolVersion", obj.getProtocolVersion().name());
        }
        json2.put("maxChunkSize", obj.getMaxChunkSize());
        json2.put("maxInitialLineLength", obj.getMaxInitialLineLength());
        json2.put("maxHeaderSize", obj.getMaxHeaderSize());
        if (obj.getInitialSettings() != null) {
            json2.put("initialSettings", obj.getInitialSettings().toJson());
        }
        if (obj.getAlpnVersions() != null) {
            JsonArray array = new JsonArray();
            obj.getAlpnVersions().forEach(item2 -> array.add(item2.name()));
            json2.put("alpnVersions", array);
        }
        json2.put("http2ClearTextUpgrade", obj.isHttp2ClearTextUpgrade());
        json2.put("http2ClearTextUpgradeWithPreflightRequest", obj.isHttp2ClearTextUpgradeWithPreflightRequest());
        json2.put("maxRedirects", obj.getMaxRedirects());
        json2.put("forceSni", obj.isForceSni());
        json2.put("decoderInitialBufferSize", obj.getDecoderInitialBufferSize());
        if (obj.getTracingPolicy() != null) {
            json2.put("tracingPolicy", obj.getTracingPolicy().name());
        }
        json2.put("shared", obj.isShared());
        if (obj.getName() != null) {
            json2.put("name", obj.getName());
        }
    }
}

