/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.file.impl;

import io.netty.util.internal.PlatformDependent;
import io.vertx.core.VertxException;
import io.vertx.core.file.FileSystemOptions;
import io.vertx.core.file.impl.FileCache;
import io.vertx.core.file.impl.FileSystemImpl;
import io.vertx.core.impl.Utils;
import io.vertx.core.internal.net.RFC3986;
import io.vertx.core.spi.file.FileResolver;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class FileResolverImpl
implements FileResolver {
    private static final boolean NON_UNIX_FILE_SEP = File.separatorChar != '/';
    private static final String JAR_URL_SEP = "!/";
    private final boolean enableCaching;
    private final boolean enableCPResolving;
    private final FileCache cache;

    public FileResolverImpl() {
        this(new FileSystemOptions());
    }

    public FileResolverImpl(FileSystemOptions fileSystemOptions) {
        this.enableCaching = fileSystemOptions.isFileCachingEnabled();
        this.enableCPResolving = fileSystemOptions.isClassPathResolvingEnabled();
        this.cache = this.enableCPResolving ? FileCache.setupCache(fileSystemOptions.getFileCacheDir()) : null;
    }

    public String cacheDir() {
        if (this.cache != null) {
            return this.cache.cacheDir();
        }
        return null;
    }

    public FileCache getFileCache() {
        return this.cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.enableCPResolving) {
            FileCache fileCache = this.cache;
            synchronized (fileCache) {
                this.cache.close();
            }
        }
    }

    @Override
    public File resolve(String fileName) {
        int idx = fileName.length() - 1;
        if (idx >= 0 && fileName.charAt(idx) == '/') {
            fileName = fileName.substring(0, idx);
        }
        return this.resolveFile2(fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File resolveFile2(String fileName) {
        File file = new File(fileName);
        boolean absolute = file.isAbsolute();
        if (this.cache == null) {
            return file;
        }
        if (file.getPath().isEmpty() || !file.exists()) {
            FileCache fileCache = this.cache;
            synchronized (fileCache) {
                File cacheFile = this.cache.getCanonicalFile(file);
                if (cacheFile == null) {
                    return file;
                }
                String relativize = this.cache.relativize(cacheFile.getPath());
                if (relativize != null) {
                    if (this.enableCaching && cacheFile.exists()) {
                        return cacheFile;
                    }
                    if (absolute) {
                        fileName = relativize;
                        file = new File(relativize);
                        absolute = false;
                    }
                }
                if (!absolute) {
                    URL url;
                    ClassLoader cl = this.getClassLoader();
                    for (File parentFile = file.getParentFile(); parentFile != null; parentFile = parentFile.getParentFile()) {
                        URL directoryContents;
                        String parentFileName = parentFile.getPath();
                        if (NON_UNIX_FILE_SEP) {
                            parentFileName = parentFileName.replace(File.separatorChar, '/');
                        }
                        if ((directoryContents = FileResolverImpl.getValidClassLoaderResource(cl, parentFileName)) == null) continue;
                        this.unpackUrlResource(directoryContents, parentFileName, cl, true);
                    }
                    if (NON_UNIX_FILE_SEP) {
                        fileName = fileName.replace(File.separatorChar, '/');
                    }
                    if ((url = FileResolverImpl.getValidClassLoaderResource(cl, fileName)) != null) {
                        return this.unpackUrlResource(url, fileName, cl, false);
                    }
                }
            }
        }
        return file;
    }

    private static boolean isValidWindowsCachePath(char c) {
        if (c < ' ') {
            return false;
        }
        switch (c) {
            case '\"': 
            case '*': 
            case ':': 
            case '<': 
            case '>': 
            case '?': 
            case '|': {
                return false;
            }
        }
        return true;
    }

    private static boolean isValidCachePath(String fileName) {
        if (PlatformDependent.isWindows()) {
            int len = fileName.length();
            for (int i = 0; i < len; ++i) {
                char c = fileName.charAt(i);
                if (!FileResolverImpl.isValidWindowsCachePath(c)) {
                    return false;
                }
                if (c != ' ' || i + 1 != len && fileName.charAt(i + 1) != '/') continue;
                return false;
            }
            return true;
        }
        return fileName.indexOf(0) == -1;
    }

    private static URL getValidClassLoaderResource(ClassLoader cl, String fileName) {
        URL resource2 = cl.getResource(fileName);
        if (resource2 != null && !FileResolverImpl.isValidCachePath(fileName)) {
            return null;
        }
        return resource2;
    }

    private File unpackUrlResource(URL url, String fileName, ClassLoader cl, boolean isDir) {
        String prot;
        switch (prot = url.getProtocol()) {
            case "file": {
                return this.unpackFromFileURL(url, fileName, cl);
            }
            case "jar": {
                return this.unpackFromJarURL(url, fileName, cl);
            }
            case "bundle": 
            case "bundleentry": 
            case "bundleresource": 
            case "jrt": 
            case "resource": 
            case "vfs": {
                return this.unpackFromBundleURL(url, fileName, isDir);
            }
        }
        throw new IllegalStateException("Invalid url protocol: " + prot);
    }

    private File unpackFromFileURL(URL url, String fileName, ClassLoader cl) {
        String[] listing;
        File cacheFile;
        File resource2 = new File(RFC3986.decodeURIComponent(url.getPath(), false));
        boolean isDirectory = resource2.isDirectory();
        try {
            cacheFile = this.cache.cacheFile(fileName, resource2, !this.enableCaching);
        }
        catch (IOException e) {
            throw new VertxException(FileSystemImpl.getFileAccessErrorMessage("unpack", resource2.getAbsolutePath()), e);
        }
        if (isDirectory && (listing = resource2.list()) != null) {
            for (String file : listing) {
                String subResource = fileName + "/" + file;
                URL url2 = FileResolverImpl.getValidClassLoaderResource(cl, subResource);
                this.unpackFromFileURL(url2, subResource, cl);
            }
        }
        return cacheFile;
    }

    private List<String> listOfEntries(URL url) {
        String path = url.getPath();
        ArrayList<String> list2 = new ArrayList<String>();
        int last2 = path.length();
        int i = path.length() - 2;
        while (i >= 0) {
            if (path.charAt(i) == '!' && path.charAt(i + 1) == '/') {
                list2.add(path.substring(2 + i, last2));
                last2 = i;
                i -= 2;
                continue;
            }
            --i;
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File unpackFromJarURL(URL url, String fileName, ClassLoader cl) {
        try {
            List<String> listOfEntries = this.listOfEntries(url);
            switch (listOfEntries.size()) {
                case 1: {
                    JarURLConnection conn = (JarURLConnection)url.openConnection();
                    if (conn.getContentLength() == -1) {
                        return this.cache.getFile(fileName);
                    }
                    JarFile zip2 = conn.getJarFile();
                    try {
                        this.extractFilesFromJarFile(zip2, fileName);
                        break;
                    }
                    finally {
                        if (!conn.getUseCaches()) {
                            zip2.close();
                        }
                    }
                }
                case 2: {
                    URL nestedURL = cl.getResource(listOfEntries.get(1));
                    if (nestedURL != null && nestedURL.getProtocol().equals("jar")) {
                        File root = this.unpackFromJarURL(nestedURL, listOfEntries.get(1), cl);
                        if (root.isDirectory()) {
                            final Path path = root.toPath();
                            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                                @Override
                                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                                    Path relative = path.relativize(dir);
                                    FileResolverImpl.this.cache.cacheDir(relative.toString());
                                    return FileVisitResult.CONTINUE;
                                }

                                @Override
                                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                                    Path relative = path.relativize(file);
                                    FileResolverImpl.this.cache.cacheFile(relative.toString(), file.toFile(), false);
                                    return FileVisitResult.CONTINUE;
                                }
                            });
                            break;
                        }
                        try (ZipFile zip3 = new ZipFile(root);){
                            this.extractFilesFromJarFile(zip3, fileName);
                            break;
                        }
                    }
                    throw new VertxException("Unexpected nested url : " + String.valueOf(nestedURL));
                }
                default: {
                    throw new VertxException("Nesting more than two levels is not supported");
                }
            }
        }
        catch (IOException e) {
            throw new VertxException(FileSystemImpl.getFileAccessErrorMessage("unpack", url.toString()), e);
        }
        return this.cache.getFile(fileName);
    }

    private void extractFilesFromJarFile(ZipFile zip2, String entryFilter) throws IOException {
        Enumeration<? extends ZipEntry> entries2 = zip2.entries();
        while (entries2.hasMoreElements()) {
            ZipEntry entry = entries2.nextElement();
            String name = entry.getName();
            int len = name.length();
            if (len == 0) {
                return;
            }
            if (name.charAt(len - 1) == ' ' && Utils.isWindows() || !name.startsWith(entryFilter)) continue;
            if (name.charAt(len - 1) == '/') {
                this.cache.cacheDir(name);
                continue;
            }
            InputStream is = zip2.getInputStream(entry);
            try {
                this.cache.cacheFile(name, is, !this.enableCaching);
            }
            finally {
                if (is == null) continue;
                is.close();
            }
        }
    }

    private boolean isBundleUrlDirectory(URL url) {
        return url.toExternalForm().endsWith("/") || FileResolverImpl.getValidClassLoaderResource(this.getClassLoader(), url.getPath().substring(1) + "/") != null;
    }

    private File unpackFromBundleURL(URL url, String fileName, boolean isDir) {
        block9: {
            try {
                if (this.getClassLoader() != null && this.isBundleUrlDirectory(url) || isDir) {
                    this.cache.cacheDir(fileName);
                    break block9;
                }
                try (InputStream is = url.openStream();){
                    this.cache.cacheFile(fileName, is, !this.enableCaching);
                }
            }
            catch (IOException e) {
                throw new VertxException(FileSystemImpl.getFileAccessErrorMessage("unpack", url.toString()), e);
            }
        }
        return this.cache.getFile(fileName);
    }

    private ClassLoader getClassLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = this.getClass().getClassLoader();
        }
        if (cl == null) {
            cl = Object.class.getClassLoader();
        }
        return cl;
    }
}

