/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.eventbus.impl.clustered;

import io.netty.util.internal.PlatformDependent;
import io.vertx.core.Completable;
import io.vertx.core.eventbus.impl.clustered.NodeSelector;
import io.vertx.core.eventbus.impl.clustered.selector.NullRoundRobinSelector;
import io.vertx.core.eventbus.impl.clustered.selector.RoundRobinSelector;
import io.vertx.core.eventbus.impl.clustered.selector.SimpleRoundRobinSelector;
import io.vertx.core.eventbus.impl.clustered.selector.Weight;
import io.vertx.core.eventbus.impl.clustered.selector.WeightedRoundRobinSelector;
import io.vertx.core.spi.cluster.ClusteredNode;
import io.vertx.core.spi.cluster.RegistrationInfo;
import io.vertx.core.spi.cluster.RegistrationUpdateEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

public class DefaultNodeSelector
implements NodeSelector {
    private ClusteredNode clusterManager;
    private final ConcurrentMap<String, Node> entries = new ConcurrentHashMap<String, Node>();

    private <T> void selectFor(String address, Op<T> op, Completable<T> callback) {
        Node node = (Node)this.entries.get(address);
        if (node == null) {
            node = new Node();
            node.queue.add(new Select<T>(op, callback));
            Node phantom = this.entries.putIfAbsent(address, node);
            if (phantom != null) {
                node = phantom;
            } else {
                this.initializeNode(node, address);
                return;
            }
        }
        if (node.wip.get() == 0) {
            Object v = node.value;
            if (v instanceof RoundRobinSelector) {
                callback.succeed(op.select((RoundRobinSelector)v));
            } else {
                callback.fail((Throwable)v);
            }
        } else {
            node.queue.add(new Select<T>(op, callback));
            int amount = node.wip.incrementAndGet();
            if (amount == 1) {
                node.signal(node.value, amount);
            }
        }
    }

    private void initializeNode(Node node, String address) {
        this.clusterManager.getRegistrations(address, (res, err) -> {
            if (err == null) {
                this.succeed(node, address, (List<RegistrationInfo>)res);
            } else {
                this.fail(node, address, err);
            }
        });
    }

    private void succeed(Node node, String address, List<RegistrationInfo> registrations) {
        List<String> accessible2 = this.computeAccessible(registrations);
        RoundRobinSelector selector = this.data(accessible2);
        if (selector != null) {
            node.signal(selector, node.wip.get());
        } else if (this.entries.remove(address, node)) {
            node.signal(NullRoundRobinSelector.INSTANCE, node.wip.get());
        }
    }

    private void fail(Node node, String address, Throwable cause) {
        this.entries.remove(address, node);
        node.signal(cause, node.wip.get());
    }

    @Override
    public void init(ClusteredNode clusterManager) {
        this.clusterManager = clusterManager;
    }

    @Override
    public void selectForSend(String address, Completable<String> promise) {
        this.selectFor(address, Op.SEND, promise);
    }

    @Override
    public void selectForPublish(String address, Completable<Iterable<String>> promise) {
        this.selectFor(address, Op.PUBLISH, promise);
    }

    @Override
    public boolean wantsUpdatesFor(String address) {
        return this.entries.containsKey(address);
    }

    private RoundRobinSelector data(List<String> nodeIds) {
        if (nodeIds == null || nodeIds.isEmpty()) {
            return null;
        }
        Map<String, Weight> weights = this.computeWeights(nodeIds);
        RoundRobinSelector selector = this.isEvenlyDistributed(weights) ? new SimpleRoundRobinSelector(new ArrayList<String>(weights.keySet())) : new WeightedRoundRobinSelector(weights);
        return selector;
    }

    private Map<String, Weight> computeWeights(List<String> nodeIds) {
        HashMap<String, Weight> weights = new HashMap<String, Weight>();
        for (String nodeId : nodeIds) {
            weights.compute(nodeId, (s, weight) -> weight == null ? new Weight(0) : weight.increment());
        }
        return weights;
    }

    private boolean isEvenlyDistributed(Map<String, Weight> weights) {
        if (weights.size() > 1) {
            Weight previous = null;
            for (Weight weight : weights.values()) {
                if (previous != null && previous.value() != weight.value()) {
                    return false;
                }
                previous = weight;
            }
        }
        return true;
    }

    private List<String> computeAccessible(List<RegistrationInfo> registrations) {
        if (registrations == null || registrations.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> list2 = new ArrayList<String>(registrations.size());
        for (RegistrationInfo registration : registrations) {
            if (!this.isAccessible(registration)) continue;
            String nodeId = registration.nodeId();
            list2.add(nodeId);
        }
        list2.trimToSize();
        return list2;
    }

    private boolean isAccessible(RegistrationInfo registrationInfo) {
        return !registrationInfo.localOnly() || this.clusterManager.getNodeId().equals(registrationInfo.nodeId());
    }

    @Override
    public void eventBusStarted() {
    }

    @Override
    public void registrationsUpdated(RegistrationUpdateEvent event) {
        String address = event.address();
        List<String> accessible2 = this.computeAccessible(event.registrations());
        RoundRobinSelector selector = this.data(accessible2);
        if (selector != null) {
            Node node = (Node)this.entries.get(address);
            if (node != null) {
                node.queue.add(new Update(selector));
                int amount = node.wip.incrementAndGet();
                if (amount == 1) {
                    node.signal(selector, amount);
                }
            }
        } else {
            this.entries.remove(address);
        }
    }

    private static class Select<T>
    implements Action {
        final Op<T> op;
        final Completable<T> callback;

        Select(Op<T> op, Completable<T> callback) {
            this.op = op;
            this.callback = callback;
        }

        void resolve(RoundRobinSelector selector) {
            this.callback.succeed(this.op.select(selector));
        }

        void fail(Throwable err) {
            this.callback.fail(err);
        }
    }

    private static class Update
    implements Action {
        final RoundRobinSelector selector;

        Update(RoundRobinSelector selector) {
            this.selector = selector;
        }
    }

    private static interface Action {
    }

    private static class Node {
        final AtomicInteger wip = new AtomicInteger(1);
        final Queue<Action> queue = PlatformDependent.newMpscQueue();
        Object value;

        private Node() {
        }

        private void signal(Object value, int amount) {
            while (amount > 0) {
                for (int i = 0; i < amount; ++i) {
                    Action a = this.queue.poll();
                    assert (a != null);
                    if (a instanceof Select) {
                        Select s = (Select)a;
                        if (value instanceof RoundRobinSelector) {
                            s.resolve((RoundRobinSelector)value);
                            continue;
                        }
                        s.fail((Throwable)value);
                        continue;
                    }
                    if (a instanceof Update) {
                        value = ((Update)a).selector;
                        continue;
                    }
                    throw new UnsupportedOperationException();
                }
                this.value = value;
                amount = this.wip.addAndGet(-amount);
            }
        }
    }

    private static interface Op<T> {
        public static final Op<String> SEND = RoundRobinSelector::selectForSend;
        public static final Op<Iterable<String>> PUBLISH = RoundRobinSelector::selectForPublish;

        public T select(RoundRobinSelector var1);
    }
}

