/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.eventbus.impl;

import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.eventbus.MessageProducer;
import io.vertx.core.eventbus.impl.EventBusImpl;
import io.vertx.core.eventbus.impl.MessageImpl;
import io.vertx.core.internal.ContextInternal;

public class MessageProducerImpl<T>
implements MessageProducer<T> {
    private final Vertx vertx;
    private final EventBusImpl bus;
    private final boolean send;
    private final String address;
    private final boolean localOnly;
    private DeliveryOptions options;

    public MessageProducerImpl(Vertx vertx, String address, boolean send2, DeliveryOptions options2) {
        this.vertx = vertx;
        this.bus = (EventBusImpl)vertx.eventBus();
        this.address = address;
        this.send = send2;
        this.options = options2;
        this.localOnly = vertx.isClustered() ? options2.isLocalOnly() : true;
    }

    @Override
    public synchronized MessageProducer<T> deliveryOptions(DeliveryOptions options2) {
        this.options = options2;
        return this;
    }

    @Override
    public Future<Void> write(T body) {
        MessageImpl msg = this.bus.createMessage(this.send, this.localOnly, this.address, this.options.getHeaders(), body, this.options.getCodecName());
        return this.bus.sendOrPubInternal(msg, this.options, null);
    }

    @Override
    public String address() {
        return this.address;
    }

    @Override
    public Future<Void> close() {
        return ((ContextInternal)this.vertx.getOrCreateContext()).succeededFuture();
    }
}

