/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.eventbus.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Completable;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Promise;
import io.vertx.core.eventbus.DeliveryContext;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.eventbus.Message;
import io.vertx.core.eventbus.MessageCodec;
import io.vertx.core.eventbus.MessageConsumer;
import io.vertx.core.eventbus.MessageConsumerOptions;
import io.vertx.core.eventbus.MessageProducer;
import io.vertx.core.eventbus.ReplyException;
import io.vertx.core.eventbus.ReplyFailure;
import io.vertx.core.eventbus.impl.CodecManager;
import io.vertx.core.eventbus.impl.EventBusInternal;
import io.vertx.core.eventbus.impl.HandlerHolder;
import io.vertx.core.eventbus.impl.HandlerRegistration;
import io.vertx.core.eventbus.impl.MessageConsumerImpl;
import io.vertx.core.eventbus.impl.MessageImpl;
import io.vertx.core.eventbus.impl.MessageProducerImpl;
import io.vertx.core.eventbus.impl.OutboundDeliveryContext;
import io.vertx.core.eventbus.impl.ReplyHandler;
import io.vertx.core.impl.Arguments;
import io.vertx.core.impl.utils.ConcurrentCyclicSequence;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.VertxInternal;
import io.vertx.core.spi.metrics.EventBusMetrics;
import io.vertx.core.spi.metrics.MetricsProvider;
import io.vertx.core.spi.metrics.VertxMetrics;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Consumer;
import java.util.function.Function;

public class EventBusImpl
implements EventBusInternal,
MetricsProvider {
    private static final AtomicReferenceFieldUpdater<EventBusImpl, Handler[]> OUTBOUND_INTERCEPTORS_UPDATER = AtomicReferenceFieldUpdater.newUpdater(EventBusImpl.class, Handler[].class, "outboundInterceptors");
    private static final AtomicReferenceFieldUpdater<EventBusImpl, Handler[]> INBOUND_INTERCEPTORS_UPDATER = AtomicReferenceFieldUpdater.newUpdater(EventBusImpl.class, Handler[].class, "inboundInterceptors");
    private volatile Handler<DeliveryContext>[] outboundInterceptors = new Handler[0];
    private volatile Handler<DeliveryContext>[] inboundInterceptors = new Handler[0];
    private final AtomicLong replySequence = new AtomicLong(0L);
    protected final VertxInternal vertx;
    protected final EventBusMetrics metrics;
    protected final ConcurrentMap<String, ConcurrentCyclicSequence<HandlerHolder>> handlerMap = new ConcurrentHashMap<String, ConcurrentCyclicSequence<HandlerHolder>>();
    protected final CodecManager codecManager = new CodecManager();
    protected volatile boolean started;

    public EventBusImpl(VertxInternal vertx) {
        VertxMetrics metrics2 = vertx.metrics();
        this.vertx = vertx;
        this.metrics = metrics2 != null ? metrics2.createEventBusMetrics() : null;
    }

    @Override
    public <T> EventBus addOutboundInterceptor(Handler<DeliveryContext<T>> interceptor) {
        this.addInterceptor(OUTBOUND_INTERCEPTORS_UPDATER, Objects.requireNonNull(interceptor));
        return this;
    }

    @Override
    public <T> EventBus addInboundInterceptor(Handler<DeliveryContext<T>> interceptor) {
        this.addInterceptor(INBOUND_INTERCEPTORS_UPDATER, Objects.requireNonNull(interceptor));
        return this;
    }

    @Override
    public <T> EventBus removeOutboundInterceptor(Handler<DeliveryContext<T>> interceptor) {
        this.removeInterceptor(OUTBOUND_INTERCEPTORS_UPDATER, Objects.requireNonNull(interceptor));
        return this;
    }

    @Override
    public <T> EventBus removeInboundInterceptor(Handler<DeliveryContext<T>> interceptor) {
        this.removeInterceptor(INBOUND_INTERCEPTORS_UPDATER, Objects.requireNonNull(interceptor));
        return this;
    }

    Handler<DeliveryContext>[] inboundInterceptors() {
        return this.inboundInterceptors;
    }

    Handler<DeliveryContext>[] outboundInterceptors() {
        return this.outboundInterceptors;
    }

    @Override
    public EventBus clusterSerializableChecker(Function<String, Boolean> classNamePredicate) {
        this.codecManager.clusterSerializableCheck(classNamePredicate);
        return this;
    }

    @Override
    public EventBus serializableChecker(Function<String, Boolean> classNamePredicate) {
        this.codecManager.serializableCheck(classNamePredicate);
        return this;
    }

    @Override
    public synchronized void start(Promise<Void> promise) {
        if (this.started) {
            throw new IllegalStateException("Already started");
        }
        this.started = true;
        promise.complete();
    }

    @Override
    public EventBus send(String address, Object message) {
        return this.send(address, message, new DeliveryOptions());
    }

    @Override
    public EventBus send(String address, Object message, DeliveryOptions options2) {
        MessageImpl msg = this.createMessage(true, this.isLocalOnly(options2), address, options2.getHeaders(), message, options2.getCodecName());
        this.sendOrPubInternal(msg, options2, null);
        return this;
    }

    @Override
    public <T> Future<Message<T>> request(String address, Object message, DeliveryOptions options2) {
        MessageImpl msg = this.createMessage(true, this.isLocalOnly(options2), address, options2.getHeaders(), message, options2.getCodecName());
        ReplyHandler<T> handler = this.createReplyHandler(msg, true, options2);
        this.sendOrPubInternal(msg, options2, handler);
        return handler.result();
    }

    @Override
    public <T> MessageProducer<T> sender(String address) {
        Objects.requireNonNull(address, "address");
        return new MessageProducerImpl(this.vertx, address, true, new DeliveryOptions());
    }

    @Override
    public <T> MessageProducer<T> sender(String address, DeliveryOptions options2) {
        Objects.requireNonNull(address, "address");
        Objects.requireNonNull(options2, "options");
        return new MessageProducerImpl(this.vertx, address, true, options2);
    }

    @Override
    public <T> MessageProducer<T> publisher(String address) {
        Objects.requireNonNull(address, "address");
        return new MessageProducerImpl(this.vertx, address, false, new DeliveryOptions());
    }

    @Override
    public <T> MessageProducer<T> publisher(String address, DeliveryOptions options2) {
        Objects.requireNonNull(address, "address");
        Objects.requireNonNull(options2, "options");
        return new MessageProducerImpl(this.vertx, address, false, options2);
    }

    @Override
    public EventBus publish(String address, Object message) {
        return this.publish(address, message, new DeliveryOptions());
    }

    @Override
    public EventBus publish(String address, Object message, DeliveryOptions options2) {
        this.sendOrPubInternal(this.createMessage(false, this.isLocalOnly(options2), address, options2.getHeaders(), message, options2.getCodecName()), options2, null);
        return this;
    }

    @Override
    public <T> MessageConsumer<T> consumer(MessageConsumerOptions options2) {
        this.checkStarted();
        String address = options2.getAddress();
        Arguments.require(options2.getAddress() != null, "Consumer address must not be null");
        return new MessageConsumerImpl(this.vertx.getOrCreateContext(), this, address, options2.isLocalOnly(), options2.getMaxBufferedMessages());
    }

    @Override
    public <T> MessageConsumer<T> consumer(MessageConsumerOptions options2, Handler<Message<T>> handler) {
        Objects.requireNonNull(handler, "handler");
        MessageConsumer<T> consumer2 = this.consumer(options2);
        consumer2.handler((Handler)handler);
        return consumer2;
    }

    @Override
    public <T> MessageConsumer<T> consumer(String address) {
        this.checkStarted();
        Objects.requireNonNull(address, "address");
        return new MessageConsumerImpl(this.vertx.getOrCreateContext(), this, address, false, 1000);
    }

    @Override
    public <T> MessageConsumer<T> consumer(String address, Handler<Message<T>> handler) {
        Objects.requireNonNull(handler, "handler");
        MessageConsumer<T> consumer2 = this.consumer(address);
        consumer2.handler((Handler)handler);
        return consumer2;
    }

    @Override
    public <T> MessageConsumer<T> localConsumer(String address) {
        this.checkStarted();
        Objects.requireNonNull(address, "address");
        return new MessageConsumerImpl(this.vertx.getOrCreateContext(), this, address, true, 1000);
    }

    @Override
    public <T> MessageConsumer<T> localConsumer(String address, Handler<Message<T>> handler) {
        Objects.requireNonNull(handler, "handler");
        MessageConsumer<T> consumer2 = this.localConsumer(address);
        consumer2.handler((Handler)handler);
        return consumer2;
    }

    @Override
    public EventBus registerCodec(MessageCodec codec) {
        this.codecManager.registerCodec(codec);
        return this;
    }

    @Override
    public EventBus unregisterCodec(String name) {
        this.codecManager.unregisterCodec(name);
        return this;
    }

    @Override
    public <T> EventBus registerDefaultCodec(Class<T> clazz, MessageCodec<T, ?> codec) {
        this.codecManager.registerDefaultCodec(clazz, codec);
        return this;
    }

    @Override
    public EventBus unregisterDefaultCodec(Class clazz) {
        this.codecManager.unregisterDefaultCodec(clazz);
        return this;
    }

    @Override
    public EventBus codecSelector(Function<Object, String> selector) {
        this.codecManager.codecSelector(selector);
        return this;
    }

    @Override
    public void close(Promise<Void> promise) {
        if (!this.started) {
            promise.complete();
            return;
        }
        this.unregisterAll().onComplete(ar -> {
            if (this.metrics != null) {
                this.metrics.close();
            }
            promise.handle((AsyncResult<Void>)ar);
        });
    }

    @Override
    public boolean isMetricsEnabled() {
        return this.metrics != null;
    }

    @Override
    public EventBusMetrics<?> getMetrics() {
        return this.metrics;
    }

    public MessageImpl createMessage(boolean send2, boolean localOnly, String address, MultiMap headers, Object body, String codecName) {
        Objects.requireNonNull(address, "no null address accepted");
        MessageCodec codec = this.codecManager.lookupCodec(body, codecName, localOnly);
        MessageImpl msg = new MessageImpl(address, headers, body, codec, send2, this);
        return msg;
    }

    protected <T> Consumer<Promise<Void>> addRegistration(String address, HandlerRegistration<T> registration, boolean broadcast2, boolean localOnly, Completable<Void> promise) {
        HandlerHolder holder2 = this.addLocalRegistration(address, registration, localOnly);
        if (broadcast2) {
            this.onLocalRegistration(holder2, promise);
        } else {
            promise.succeed();
        }
        return p -> this.removeRegistration(holder2, broadcast2, (Promise<Void>)p);
    }

    protected <T> void onLocalRegistration(HandlerHolder<T> handlerHolder, Completable<Void> promise) {
        promise.succeed();
    }

    private <T> HandlerHolder<T> addLocalRegistration(String address, HandlerRegistration<T> registration, boolean localOnly) {
        Objects.requireNonNull(address, "address");
        ContextInternal context2 = registration.context;
        HandlerHolder<T> holder2 = this.createHandlerHolder(registration, localOnly, context2);
        ConcurrentCyclicSequence<HandlerHolder<T>> handlers = new ConcurrentCyclicSequence<HandlerHolder<T>>().add(holder2);
        ConcurrentCyclicSequence actualHandlers = this.handlerMap.merge(address, handlers, (old, prev) -> old.add((HandlerHolder)prev.first()));
        if (context2.isDeployment()) {
            context2.addCloseHook(registration);
        }
        return holder2;
    }

    protected <T> HandlerHolder<T> createHandlerHolder(HandlerRegistration<T> registration, boolean localOnly, ContextInternal context2) {
        return new HandlerHolder<T>(registration, localOnly, context2);
    }

    protected <T> void removeRegistration(HandlerHolder<T> handlerHolder, boolean broadcast2, Promise<Void> promise) {
        this.removeLocalRegistration(handlerHolder);
        if (broadcast2) {
            this.onLocalUnregistration(handlerHolder, promise);
        } else {
            promise.complete();
        }
    }

    protected <T> void onLocalUnregistration(HandlerHolder<T> handlerHolder, Completable<Void> promise) {
        promise.succeed();
    }

    private <T> void removeLocalRegistration(HandlerHolder<T> holder2) {
        String address = holder2.getHandler().address;
        this.handlerMap.compute(address, (key, val) -> {
            if (val == null) {
                return null;
            }
            ConcurrentCyclicSequence<HandlerHolder> next2 = val.remove(holder2);
            return next2.size() == 0 ? null : next2;
        });
        if (holder2.setRemoved() && holder2.getContext().deploymentID() != null) {
            holder2.getContext().removeCloseHook(holder2.getHandler());
        }
    }

    protected <T> void sendReply(MessageImpl replyMessage, DeliveryOptions options2, ReplyHandler<T> replyHandler) {
        if (replyMessage.address() == null) {
            throw new IllegalStateException("address not specified");
        }
        this.sendOrPubInternal(new OutboundDeliveryContext<T>(this.vertx.getOrCreateContext(), replyMessage, options2, replyHandler));
    }

    protected <T> void sendOrPub(ContextInternal ctx, MessageImpl<?, T> message, DeliveryOptions options2, Promise<Void> writePromise) {
        this.sendLocally(message, writePromise);
    }

    protected <T> void sendOrPub(OutboundDeliveryContext<T> sendContext) {
        this.sendOrPub(sendContext.ctx, sendContext.message, sendContext.options, sendContext);
    }

    protected <T> void sendLocally(MessageImpl<?, T> message, Promise<Void> writePromise) {
        ReplyException failure = this.deliverMessageLocally(message);
        if (failure != null) {
            writePromise.tryFail(failure);
        } else {
            writePromise.tryComplete();
        }
    }

    protected boolean isMessageLocal(MessageImpl msg) {
        return true;
    }

    protected ReplyException deliverMessageLocally(MessageImpl msg) {
        ConcurrentCyclicSequence handlers = (ConcurrentCyclicSequence)this.handlerMap.get(msg.address());
        boolean messageLocal = this.isMessageLocal(msg);
        if (handlers != null) {
            if (msg.isSend()) {
                HandlerHolder holder2 = this.nextHandler(handlers, messageLocal);
                if (this.metrics != null) {
                    this.metrics.messageReceived(msg.address(), !msg.isSend(), messageLocal, holder2 != null ? 1 : 0);
                }
                if (holder2 != null) {
                    holder2.handler.receive(msg.copyBeforeReceive());
                }
            } else {
                if (this.metrics != null) {
                    this.metrics.messageReceived(msg.address(), !msg.isSend(), messageLocal, handlers.size());
                }
                for (HandlerHolder holder3 : handlers) {
                    if (!messageLocal && holder3.isLocalOnly()) continue;
                    holder3.handler.receive(msg.copyBeforeReceive());
                }
            }
            return null;
        }
        if (this.metrics != null) {
            this.metrics.messageReceived(msg.address(), !msg.isSend(), messageLocal, 0);
        }
        return new ReplyException(ReplyFailure.NO_HANDLERS, "No handlers for address " + msg.address);
    }

    protected HandlerHolder nextHandler(ConcurrentCyclicSequence<HandlerHolder> handlers, boolean messageLocal) {
        return handlers.next();
    }

    protected void checkStarted() {
        if (!this.started) {
            throw new IllegalStateException("Event Bus is not started");
        }
    }

    protected String generateReplyAddress() {
        return "__vertx.reply." + Long.toString(this.replySequence.incrementAndGet());
    }

    <T> ReplyHandler<T> createReplyHandler(MessageImpl message, boolean src, DeliveryOptions options2) {
        long timeout2 = options2.getSendTimeout();
        String replyAddress = this.generateReplyAddress();
        message.setReplyAddress(replyAddress);
        ReplyHandler handler = new ReplyHandler(this, this.vertx.getOrCreateContext(), replyAddress, message.address, src, timeout2);
        handler.register();
        return handler;
    }

    public <T> OutboundDeliveryContext<T> newSendContext(MessageImpl message, DeliveryOptions options2, ReplyHandler<T> handler) {
        return new OutboundDeliveryContext<T>(this.vertx.getOrCreateContext(), message, options2, handler);
    }

    public <T> void sendOrPubInternal(OutboundDeliveryContext<T> senderCtx) {
        this.checkStarted();
        senderCtx.bus = this;
        senderCtx.metrics = this.metrics;
        senderCtx.next();
    }

    public <T> Future<Void> sendOrPubInternal(MessageImpl message, DeliveryOptions options2, ReplyHandler<T> handler) {
        this.checkStarted();
        OutboundDeliveryContext<T> ctx = this.newSendContext(message, options2, handler);
        this.sendOrPubInternal(ctx);
        Future<Void> future = ctx.writePromise.future();
        if (message.send) {
            return future;
        }
        return future.recover(throwable -> {
            if (throwable instanceof ReplyException) {
                return Future.failedFuture(throwable);
            }
            return Future.succeededFuture();
        });
    }

    private Future<Void> unregisterAll() {
        ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>();
        for (ConcurrentCyclicSequence handlers : this.handlerMap.values()) {
            for (HandlerHolder holder2 : handlers) {
                futures.add(holder2.getHandler().unregister());
            }
        }
        return Future.join(futures).mapEmpty();
    }

    private void addInterceptor(AtomicReferenceFieldUpdater<EventBusImpl, Handler[]> updater, Handler interceptor) {
        Handler[] copy2;
        Handler[] interceptors;
        do {
            interceptors = updater.get(this);
            copy2 = Arrays.copyOf(interceptors, interceptors.length + 1);
            copy2[interceptors.length] = interceptor;
        } while (!updater.compareAndSet(this, interceptors, copy2));
    }

    private void removeInterceptor(AtomicReferenceFieldUpdater<EventBusImpl, Handler[]> updater, Handler interceptor) {
        Handler[] copy2;
        Handler[] interceptors;
        do {
            interceptors = updater.get(this);
            int idx = -1;
            for (int i = 0; i < interceptors.length; ++i) {
                if (!interceptors[i].equals(interceptor)) continue;
                idx = i;
                break;
            }
            if (idx == -1) {
                return;
            }
            copy2 = new Handler[interceptors.length - 1];
            System.arraycopy(interceptors, 0, copy2, 0, idx);
            System.arraycopy(interceptors, idx + 1, copy2, idx, copy2.length - idx);
        } while (!updater.compareAndSet(this, interceptors, copy2));
    }

    private boolean isLocalOnly(DeliveryOptions options2) {
        if (this.vertx.isClustered()) {
            return options2.isLocalOnly();
        }
        return true;
    }
}

