/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.dns;

import io.netty.handler.logging.ByteBufFormat;
import io.vertx.core.dns.DnsClientOptions;
import io.vertx.core.json.JsonObject;
import java.util.Map;

public class DnsClientOptionsConverter {
    static void fromJson(Iterable<Map.Entry<String, Object>> json2, DnsClientOptions obj) {
        for (Map.Entry<String, Object> member : json2) {
            switch (member.getKey()) {
                case "port": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setPort(((Number)member.getValue()).intValue());
                    break;
                }
                case "host": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setHost((String)member.getValue());
                    break;
                }
                case "queryTimeout": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setQueryTimeout(((Number)member.getValue()).longValue());
                    break;
                }
                case "logActivity": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setLogActivity((Boolean)member.getValue());
                    break;
                }
                case "activityLogFormat": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setActivityLogFormat(ByteBufFormat.valueOf((String)member.getValue()));
                    break;
                }
                case "recursionDesired": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setRecursionDesired((Boolean)member.getValue());
                }
            }
        }
    }

    static void toJson(DnsClientOptions obj, JsonObject json2) {
        DnsClientOptionsConverter.toJson(obj, json2.getMap());
    }

    static void toJson(DnsClientOptions obj, Map<String, Object> json2) {
        json2.put("port", obj.getPort());
        if (obj.getHost() != null) {
            json2.put("host", obj.getHost());
        }
        json2.put("queryTimeout", obj.getQueryTimeout());
        json2.put("logActivity", obj.getLogActivity());
        if (obj.getActivityLogFormat() != null) {
            json2.put("activityLogFormat", obj.getActivityLogFormat().name());
        }
        json2.put("recursionDesired", obj.isRecursionDesired());
    }
}

