/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.dns;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.dns.AddressResolverOptions;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.ArrayList;
import java.util.Map;

public class AddressResolverOptionsConverter {
    static void fromJson(Iterable<Map.Entry<String, Object>> json2, AddressResolverOptions obj) {
        for (Map.Entry<String, Object> member : json2) {
            switch (member.getKey()) {
                case "hostsPath": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setHostsPath((String)member.getValue());
                    break;
                }
                case "hostsValue": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setHostsValue(Buffer.fromJson((String)member.getValue()));
                    break;
                }
                case "hostsRefreshPeriod": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setHostsRefreshPeriod(((Number)member.getValue()).intValue());
                    break;
                }
                case "servers": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<String> list2 = new ArrayList<String>();
                    ((Iterable)member.getValue()).forEach(item2 -> {
                        if (item2 instanceof String) {
                            list2.add((String)item2);
                        }
                    });
                    obj.setServers(list2);
                    break;
                }
                case "optResourceEnabled": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setOptResourceEnabled((Boolean)member.getValue());
                    break;
                }
                case "cacheMinTimeToLive": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setCacheMinTimeToLive(((Number)member.getValue()).intValue());
                    break;
                }
                case "cacheMaxTimeToLive": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setCacheMaxTimeToLive(((Number)member.getValue()).intValue());
                    break;
                }
                case "cacheNegativeTimeToLive": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setCacheNegativeTimeToLive(((Number)member.getValue()).intValue());
                    break;
                }
                case "queryTimeout": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setQueryTimeout(((Number)member.getValue()).longValue());
                    break;
                }
                case "maxQueries": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setMaxQueries(((Number)member.getValue()).intValue());
                    break;
                }
                case "rdFlag": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setRdFlag((Boolean)member.getValue());
                    break;
                }
                case "searchDomains": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<String> list2 = new ArrayList();
                    ((Iterable)member.getValue()).forEach(item2 -> {
                        if (item2 instanceof String) {
                            list2.add((String)item2);
                        }
                    });
                    obj.setSearchDomains(list2);
                    break;
                }
                case "ndots": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setNdots(((Number)member.getValue()).intValue());
                    break;
                }
                case "rotateServers": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setRotateServers((Boolean)member.getValue());
                    break;
                }
                case "roundRobinInetAddress": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setRoundRobinInetAddress((Boolean)member.getValue());
                }
            }
        }
    }

    static void toJson(AddressResolverOptions obj, JsonObject json2) {
        AddressResolverOptionsConverter.toJson(obj, json2.getMap());
    }

    static void toJson(AddressResolverOptions obj, Map<String, Object> json2) {
        JsonArray array;
        if (obj.getHostsPath() != null) {
            json2.put("hostsPath", obj.getHostsPath());
        }
        if (obj.getHostsValue() != null) {
            json2.put("hostsValue", obj.getHostsValue().toJson());
        }
        json2.put("hostsRefreshPeriod", obj.getHostsRefreshPeriod());
        if (obj.getServers() != null) {
            array = new JsonArray();
            obj.getServers().forEach(item2 -> array.add(item2));
            json2.put("servers", array);
        }
        json2.put("optResourceEnabled", obj.isOptResourceEnabled());
        json2.put("cacheMinTimeToLive", obj.getCacheMinTimeToLive());
        json2.put("cacheMaxTimeToLive", obj.getCacheMaxTimeToLive());
        json2.put("cacheNegativeTimeToLive", obj.getCacheNegativeTimeToLive());
        json2.put("queryTimeout", obj.getQueryTimeout());
        json2.put("maxQueries", obj.getMaxQueries());
        json2.put("rdFlag", obj.getRdFlag());
        if (obj.getSearchDomains() != null) {
            array = new JsonArray();
            obj.getSearchDomains().forEach(item2 -> array.add(item2));
            json2.put("searchDomains", array);
        }
        json2.put("ndots", obj.getNdots());
        json2.put("rotateServers", obj.isRotateServers());
        json2.put("roundRobinInetAddress", obj.isRoundRobinInetAddress());
    }
}

