/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.core.AsyncResult;
import io.vertx.core.Completable;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Context;
import io.vertx.core.Expectation;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.impl.Utils;
import io.vertx.core.impl.WorkerExecutor;
import io.vertx.core.impl.future.CompositeFutureImpl;
import io.vertx.core.impl.future.FailedFuture;
import io.vertx.core.impl.future.SucceededFuture;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.PromiseInternal;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;

public interface Future<T>
extends AsyncResult<T> {
    public static CompositeFuture all(Future<?> f1, Future<?> f2) {
        return CompositeFutureImpl.all(new Future[]{f1, f2});
    }

    public static CompositeFuture all(Future<?> f1, Future<?> f2, Future<?> f3) {
        return CompositeFutureImpl.all(new Future[]{f1, f2, f3});
    }

    public static CompositeFuture all(Future<?> f1, Future<?> f2, Future<?> f3, Future<?> f4) {
        return CompositeFutureImpl.all(new Future[]{f1, f2, f3, f4});
    }

    public static CompositeFuture all(Future<?> f1, Future<?> f2, Future<?> f3, Future<?> f4, Future<?> f5) {
        return CompositeFutureImpl.all(new Future[]{f1, f2, f3, f4, f5});
    }

    public static CompositeFuture all(Future<?> f1, Future<?> f2, Future<?> f3, Future<?> f4, Future<?> f5, Future<?> f6) {
        return CompositeFutureImpl.all(new Future[]{f1, f2, f3, f4, f5, f6});
    }

    public static <T> CompositeFuture all(List<? extends Future<?>> futures) {
        return CompositeFutureImpl.all(futures.toArray(new Future[0]));
    }

    public static CompositeFuture any(Future<?> f1, Future<?> f2) {
        return CompositeFutureImpl.any(new Future[]{f1, f2});
    }

    public static CompositeFuture any(Future<?> f1, Future<?> f2, Future<?> f3) {
        return CompositeFutureImpl.any(new Future[]{f1, f2, f3});
    }

    public static CompositeFuture any(Future<?> f1, Future<?> f2, Future<?> f3, Future<?> f4) {
        return CompositeFutureImpl.any(new Future[]{f1, f2, f3, f4});
    }

    public static CompositeFuture any(Future<?> f1, Future<?> f2, Future<?> f3, Future<?> f4, Future<?> f5) {
        return CompositeFutureImpl.any(new Future[]{f1, f2, f3, f4, f5});
    }

    public static CompositeFuture any(Future<?> f1, Future<?> f2, Future<?> f3, Future<?> f4, Future<?> f5, Future<?> f6) {
        return CompositeFutureImpl.any(new Future[]{f1, f2, f3, f4, f5, f6});
    }

    public static CompositeFuture any(List<? extends Future<?>> futures) {
        return CompositeFutureImpl.any(futures.toArray(new Future[0]));
    }

    public static CompositeFuture join(Future<?> f1, Future<?> f2) {
        return CompositeFutureImpl.join(new Future[]{f1, f2});
    }

    public static CompositeFuture join(Future<?> f1, Future<?> f2, Future<?> f3) {
        return CompositeFutureImpl.join(new Future[]{f1, f2, f3});
    }

    public static CompositeFuture join(Future<?> f1, Future<?> f2, Future<?> f3, Future<?> f4) {
        return CompositeFutureImpl.join(new Future[]{f1, f2, f3, f4});
    }

    public static CompositeFuture join(Future<?> f1, Future<?> f2, Future<?> f3, Future<?> f4, Future<?> f5) {
        return CompositeFutureImpl.join(new Future[]{f1, f2, f3, f4, f5});
    }

    public static CompositeFuture join(Future<?> f1, Future<?> f2, Future<?> f3, Future<?> f4, Future<?> f5, Future<?> f6) {
        return CompositeFutureImpl.join(new Future[]{f1, f2, f3, f4, f5, f6});
    }

    public static CompositeFuture join(List<? extends Future<?>> futures) {
        return CompositeFutureImpl.join(futures.toArray(new Future[0]));
    }

    public static <T> Future<T> future(Handler<Promise<T>> handler) {
        Promise promise = Promise.promise();
        try {
            handler.handle(promise);
        }
        catch (Throwable e) {
            promise.tryFail(e);
        }
        return promise.future();
    }

    public static <T> Future<T> succeededFuture() {
        return SucceededFuture.EMPTY;
    }

    public static <T> Future<T> succeededFuture(T result2) {
        if (result2 == null) {
            return Future.succeededFuture();
        }
        return new SucceededFuture<T>(result2);
    }

    public static <T> Future<T> failedFuture(Throwable t) {
        return new FailedFuture(t);
    }

    public static <T> Future<T> failedFuture(String failureMessage) {
        return new FailedFuture(failureMessage);
    }

    public boolean isComplete();

    @Fluent
    public Future<T> onComplete(Handler<AsyncResult<T>> var1);

    default public Future<T> onComplete(Handler<? super T> successHandler, Handler<? super Throwable> failureHandler) {
        return this.onComplete((AsyncResult<T> ar) -> {
            if (successHandler != null && ar.succeeded()) {
                successHandler.handle((Object)ar.result());
            } else if (failureHandler != null && ar.failed()) {
                failureHandler.handle(ar.cause());
            }
        });
    }

    default public Future<T> onComplete(Completable<? super T> handler) {
        return this.onComplete((AsyncResult<T> ar) -> handler.complete((Object)(ar.succeeded() ? (Object)ar.result() : null), ar.failed() ? ar.cause() : null));
    }

    @Fluent
    default public Future<T> onSuccess(Handler<? super T> handler) {
        return this.onComplete(handler, null);
    }

    @Fluent
    default public Future<T> onFailure(Handler<? super Throwable> handler) {
        return this.onComplete(null, handler);
    }

    @Override
    public T result();

    @Override
    public Throwable cause();

    @Override
    public boolean succeeded();

    @Override
    public boolean failed();

    default public <U> Future<U> flatMap(Function<? super T, Future<U>> mapper) {
        return this.compose(mapper);
    }

    default public <U> Future<U> compose(Function<? super T, Future<U>> mapper) {
        return this.compose(mapper, Future::failedFuture);
    }

    default public Future<T> recover(Function<Throwable, Future<T>> mapper) {
        return this.compose(Future::succeededFuture, mapper);
    }

    public <U> Future<U> compose(Function<? super T, Future<U>> var1, Function<Throwable, Future<U>> var2);

    public <U> Future<U> transform(Function<AsyncResult<T>, Future<U>> var1);

    default public <U> Future<U> transform(BiFunction<? super T, ? super Throwable, Future<U>> mapper) {
        return this.transform((AsyncResult<T> ar) -> (Future)mapper.apply((Object)(ar.succeeded() ? (Object)ar.result() : null), ar.failed() ? ar.cause() : null));
    }

    public <U> Future<T> eventually(Supplier<Future<U>> var1);

    @Override
    public <U> Future<U> map(Function<? super T, U> var1);

    @Override
    public <V> Future<V> map(V var1);

    @Override
    default public <V> Future<V> mapEmpty() {
        return (Future)AsyncResult.super.mapEmpty();
    }

    @Override
    public Future<T> otherwise(Function<Throwable, T> var1);

    @Override
    public Future<T> otherwise(T var1);

    @Override
    default public Future<T> otherwiseEmpty() {
        return (Future)AsyncResult.super.otherwiseEmpty();
    }

    default public Future<T> andThen(Handler<AsyncResult<T>> handler) {
        return this.transform((AsyncResult<T> ar) -> {
            handler.handle((AsyncResult)ar);
            return (Future)ar;
        });
    }

    default public Future<T> andThen(Completable<? super T> handler) {
        return this.andThen((AsyncResult<T> ar) -> handler.complete((Object)(ar.succeeded() ? (Object)ar.result() : null), ar.failed() ? ar.cause() : null));
    }

    public Future<T> expecting(Expectation<? super T> var1);

    public Future<T> timeout(long var1, TimeUnit var3);

    @GenIgnore
    default public CompletionStage<T> toCompletionStage() {
        CompletableFuture completableFuture = new CompletableFuture();
        this.onComplete((AsyncResult<T> ar) -> {
            if (ar.succeeded()) {
                completableFuture.complete(ar.result());
            } else {
                completableFuture.completeExceptionally(ar.cause());
            }
        });
        return completableFuture;
    }

    @GenIgnore
    public static <T> Future<T> fromCompletionStage(CompletionStage<T> completionStage) {
        Promise promise = Promise.promise();
        completionStage.whenComplete((value, err) -> {
            if (err != null) {
                promise.fail((Throwable)err);
            } else {
                promise.complete(value);
            }
        });
        return promise.future();
    }

    @GenIgnore
    public static <T> Future<T> fromCompletionStage(CompletionStage<T> completionStage, Context context2) {
        PromiseInternal promise = ((ContextInternal)context2).promise();
        completionStage.whenComplete((value, err) -> {
            if (err != null) {
                promise.fail((Throwable)err);
            } else {
                promise.complete(value);
            }
        });
        return promise.future();
    }

    private CountDownLatch trySuspend() {
        CountDownLatch latch;
        WorkerExecutor executor = WorkerExecutor.unwrapWorkerExecutor();
        if (executor != null) {
            WorkerExecutor.Execution execution = executor.currentExecution();
            this.onComplete((AsyncResult<T> ar) -> execution.resume());
            latch = execution.trySuspend();
        } else {
            latch = new CountDownLatch(1);
            this.onComplete((AsyncResult<T> ar) -> latch.countDown());
        }
        return latch;
    }

    private T getOrFail() {
        if (this.succeeded()) {
            return this.result();
        }
        if (this.failed()) {
            Utils.throwAsUnchecked(this.cause());
            return null;
        }
        Utils.throwAsUnchecked(new InterruptedException("Context closed"));
        return null;
    }

    default public T await() {
        CountDownLatch continuation = this.trySuspend();
        if (continuation != null) {
            try {
                continuation.await();
            }
            catch (InterruptedException e) {
                Utils.throwAsUnchecked(e);
                return null;
            }
        }
        return this.getOrFail();
    }

    default public T await(long timeout2, TimeUnit unit) throws TimeoutException {
        if (unit == null) {
            throw new NullPointerException("Unit must not be null");
        }
        CountDownLatch continuation = this.trySuspend();
        if (continuation != null) {
            try {
                if (!continuation.await(timeout2, unit)) {
                    throw new TimeoutException();
                }
            }
            catch (InterruptedException e) {
                Utils.throwAsUnchecked(e);
                return null;
            }
        }
        return this.getOrFail();
    }

    public static <T> T await(Future<T> future) {
        return future.await();
    }
}

