/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core;

import io.vertx.core.DeploymentOptions;
import io.vertx.core.ThreadingModel;
import io.vertx.core.json.JsonObject;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class DeploymentOptionsConverter {
    static void fromJson(Iterable<Map.Entry<String, Object>> json2, DeploymentOptions obj) {
        for (Map.Entry<String, Object> member : json2) {
            switch (member.getKey()) {
                case "config": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setConfig(((JsonObject)member.getValue()).copy());
                    break;
                }
                case "threadingModel": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setThreadingModel(ThreadingModel.valueOf((String)member.getValue()));
                    break;
                }
                case "ha": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setHa((Boolean)member.getValue());
                    break;
                }
                case "instances": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setInstances(((Number)member.getValue()).intValue());
                    break;
                }
                case "workerPoolName": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setWorkerPoolName((String)member.getValue());
                    break;
                }
                case "workerPoolSize": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setWorkerPoolSize(((Number)member.getValue()).intValue());
                    break;
                }
                case "maxWorkerExecuteTime": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setMaxWorkerExecuteTime(((Number)member.getValue()).longValue());
                    break;
                }
                case "maxWorkerExecuteTimeUnit": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setMaxWorkerExecuteTimeUnit(TimeUnit.valueOf((String)member.getValue()));
                }
            }
        }
    }

    static void toJson(DeploymentOptions obj, JsonObject json2) {
        DeploymentOptionsConverter.toJson(obj, json2.getMap());
    }

    static void toJson(DeploymentOptions obj, Map<String, Object> json2) {
        if (obj.getConfig() != null) {
            json2.put("config", obj.getConfig());
        }
        if (obj.getThreadingModel() != null) {
            json2.put("threadingModel", obj.getThreadingModel().name());
        }
        json2.put("ha", obj.isHa());
        json2.put("instances", obj.getInstances());
        if (obj.getWorkerPoolName() != null) {
            json2.put("workerPoolName", obj.getWorkerPoolName());
        }
        json2.put("workerPoolSize", obj.getWorkerPoolSize());
        json2.put("maxWorkerExecuteTime", obj.getMaxWorkerExecuteTime());
        if (obj.getMaxWorkerExecuteTimeUnit() != null) {
            json2.put("maxWorkerExecuteTimeUnit", obj.getMaxWorkerExecuteTimeUnit().name());
        }
    }
}

