/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal.shaded.org.jctools.util;

import io.netty.util.internal.shaded.org.jctools.util.UnsafeAccess;

public final class UnsafeLongArrayAccess {
    public static final long LONG_ARRAY_BASE;
    public static final int LONG_ELEMENT_SHIFT;

    public static void spLongElement(long[] buffer, long offset2, long e) {
        UnsafeAccess.UNSAFE.putLong(buffer, offset2, e);
    }

    public static void soLongElement(long[] buffer, long offset2, long e) {
        UnsafeAccess.UNSAFE.putOrderedLong(buffer, offset2, e);
    }

    public static long lpLongElement(long[] buffer, long offset2) {
        return UnsafeAccess.UNSAFE.getLong(buffer, offset2);
    }

    public static long lvLongElement(long[] buffer, long offset2) {
        return UnsafeAccess.UNSAFE.getLongVolatile(buffer, offset2);
    }

    public static long calcLongElementOffset(long index2) {
        return LONG_ARRAY_BASE + (index2 << LONG_ELEMENT_SHIFT);
    }

    public static long calcCircularLongElementOffset(long index2, long mask) {
        return LONG_ARRAY_BASE + ((index2 & mask) << LONG_ELEMENT_SHIFT);
    }

    public static long[] allocateLongArray(int capacity) {
        return new long[capacity];
    }

    static {
        int scale2 = UnsafeAccess.UNSAFE.arrayIndexScale(long[].class);
        if (8 != scale2) {
            throw new IllegalStateException("Unknown pointer size: " + scale2);
        }
        LONG_ELEMENT_SHIFT = 3;
        LONG_ARRAY_BASE = UnsafeAccess.UNSAFE.arrayBaseOffset(long[].class);
    }
}

