/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.buffer.ByteBuf;
import io.netty.util.CharsetUtil;
import io.netty.util.internal.ObjectUtil;

public class HttpVersion
implements Comparable<HttpVersion> {
    static final String HTTP_1_0_STRING = "HTTP/1.0";
    static final String HTTP_1_1_STRING = "HTTP/1.1";
    public static final HttpVersion HTTP_1_0 = new HttpVersion("HTTP", 1, 0, false, true);
    public static final HttpVersion HTTP_1_1 = new HttpVersion("HTTP", 1, 1, true, true);
    private final String protocolName;
    private final int majorVersion;
    private final int minorVersion;
    private final String text;
    private final boolean keepAliveDefault;
    private final byte[] bytes;

    public static HttpVersion valueOf(String text2) {
        return HttpVersion.valueOf(text2, false);
    }

    static HttpVersion valueOf(String text2, boolean strict) {
        ObjectUtil.checkNotNull(text2, "text");
        if (text2 == HTTP_1_1_STRING) {
            return HTTP_1_1;
        }
        if (text2 == HTTP_1_0_STRING) {
            return HTTP_1_0;
        }
        if ((text2 = text2.trim()).isEmpty()) {
            throw new IllegalArgumentException("text is empty (possibly HTTP/0.9)");
        }
        HttpVersion version = HttpVersion.version0(text2);
        if (version == null) {
            version = new HttpVersion(text2, strict, true);
        }
        return version;
    }

    private static HttpVersion version0(String text2) {
        if (HTTP_1_1_STRING.equals(text2)) {
            return HTTP_1_1;
        }
        if (HTTP_1_0_STRING.equals(text2)) {
            return HTTP_1_0;
        }
        return null;
    }

    public HttpVersion(String text2, boolean keepAliveDefault) {
        this(text2, false, keepAliveDefault);
    }

    HttpVersion(String text2, boolean strict, boolean keepAliveDefault) {
        text2 = ObjectUtil.checkNonEmptyAfterTrim(text2, "text").toUpperCase();
        if (strict) {
            if (text2.length() != 8 || !text2.startsWith("HTTP/") || text2.charAt(6) != '.') {
                throw new IllegalArgumentException("invalid version format: " + text2);
            }
            this.protocolName = "HTTP";
            this.majorVersion = HttpVersion.toDecimal(text2.charAt(5));
            this.minorVersion = HttpVersion.toDecimal(text2.charAt(7));
        } else {
            int slashIndex = text2.indexOf(47);
            int dotIndex = text2.indexOf(46, slashIndex + 1);
            if (slashIndex <= 0 || dotIndex <= slashIndex + 1 || dotIndex >= text2.length() - 1 || HttpVersion.hasWhitespace(text2, slashIndex)) {
                throw new IllegalArgumentException("invalid version format: " + text2);
            }
            this.protocolName = text2.substring(0, slashIndex);
            this.majorVersion = HttpVersion.parseInt(text2, slashIndex + 1, dotIndex);
            this.minorVersion = HttpVersion.parseInt(text2, dotIndex + 1, text2.length());
        }
        this.text = this.protocolName + '/' + this.majorVersion + '.' + this.minorVersion;
        this.keepAliveDefault = keepAliveDefault;
        this.bytes = null;
    }

    private static boolean hasWhitespace(String s, int end2) {
        for (int i = 0; i < end2; ++i) {
            if (!Character.isWhitespace(s.charAt(i))) continue;
            return true;
        }
        return false;
    }

    private static int parseInt(String text2, int start2, int end2) {
        int result2 = 0;
        for (int i = start2; i < end2; ++i) {
            char ch = text2.charAt(i);
            result2 = result2 * 10 + HttpVersion.toDecimal(ch);
        }
        return result2;
    }

    private static int toDecimal(int value) {
        if (value < 48 || value > 57) {
            throw new IllegalArgumentException("Invalid version number, only 0-9 (0x30-0x39) allowed, but received a '" + (char)value + "' (0x" + Integer.toHexString(value) + ")");
        }
        return value - 48;
    }

    public HttpVersion(String protocolName, int majorVersion, int minorVersion, boolean keepAliveDefault) {
        this(protocolName, majorVersion, minorVersion, keepAliveDefault, false);
    }

    private HttpVersion(String protocolName, int majorVersion, int minorVersion, boolean keepAliveDefault, boolean bytes) {
        protocolName = ObjectUtil.checkNonEmptyAfterTrim(protocolName, "protocolName").toUpperCase();
        for (int i = 0; i < protocolName.length(); ++i) {
            if (!Character.isISOControl(protocolName.charAt(i)) && !Character.isWhitespace(protocolName.charAt(i))) continue;
            throw new IllegalArgumentException("invalid character in protocolName");
        }
        ObjectUtil.checkPositiveOrZero(majorVersion, "majorVersion");
        ObjectUtil.checkPositiveOrZero(minorVersion, "minorVersion");
        this.protocolName = protocolName;
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        this.text = protocolName + '/' + majorVersion + '.' + minorVersion;
        this.keepAliveDefault = keepAliveDefault;
        this.bytes = (byte[])(bytes ? this.text.getBytes(CharsetUtil.US_ASCII) : null);
    }

    public String protocolName() {
        return this.protocolName;
    }

    public int majorVersion() {
        return this.majorVersion;
    }

    public int minorVersion() {
        return this.minorVersion;
    }

    public String text() {
        return this.text;
    }

    public boolean isKeepAliveDefault() {
        return this.keepAliveDefault;
    }

    public String toString() {
        return this.text();
    }

    public int hashCode() {
        return (this.protocolName().hashCode() * 31 + this.majorVersion()) * 31 + this.minorVersion();
    }

    public boolean equals(Object o) {
        if (!(o instanceof HttpVersion)) {
            return false;
        }
        HttpVersion that = (HttpVersion)o;
        return this.minorVersion() == that.minorVersion() && this.majorVersion() == that.majorVersion() && this.protocolName().equals(that.protocolName());
    }

    @Override
    public int compareTo(HttpVersion o) {
        int v = this.protocolName().compareTo(o.protocolName());
        if (v != 0) {
            return v;
        }
        v = this.majorVersion() - o.majorVersion();
        if (v != 0) {
            return v;
        }
        return this.minorVersion() - o.minorVersion();
    }

    void encode(ByteBuf buf) {
        if (this.bytes == null) {
            buf.writeCharSequence(this.text, CharsetUtil.US_ASCII);
        } else {
            buf.writeBytes(this.bytes);
        }
    }
}

