/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.util.AsciiString;
import io.netty.util.CharsetUtil;

final class HttpHeadersEncoder {
    private static final int COLON_AND_SPACE_SHORT = 14880;

    private HttpHeadersEncoder() {
    }

    static void encoderHeader(CharSequence name, CharSequence value, ByteBuf buf) {
        int nameLen = name.length();
        int valueLen = value.length();
        int entryLen = nameLen + valueLen + 4;
        buf.ensureWritable(entryLen);
        int offset2 = buf.writerIndex();
        HttpHeadersEncoder.writeAscii(buf, offset2, name);
        ByteBufUtil.setShortBE(buf, offset2 += nameLen, 14880);
        HttpHeadersEncoder.writeAscii(buf, offset2 += 2, value);
        ByteBufUtil.setShortBE(buf, offset2 += valueLen, 3338);
        buf.writerIndex(offset2 += 2);
    }

    private static void writeAscii(ByteBuf buf, int offset2, CharSequence value) {
        if (value instanceof AsciiString) {
            ByteBufUtil.copy((AsciiString)value, 0, buf, offset2, value.length());
        } else {
            buf.setCharSequence(offset2, value, CharsetUtil.US_ASCII);
        }
    }
}

