/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.dns;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.codec.dns.DefaultDnsQuery;
import io.netty.handler.codec.dns.DnsMessageUtil;
import io.netty.handler.codec.dns.DnsOpCode;
import io.netty.handler.codec.dns.DnsQuery;
import io.netty.handler.codec.dns.DnsRecordDecoder;
import io.netty.util.internal.ObjectUtil;

public final class TcpDnsQueryDecoder
extends LengthFieldBasedFrameDecoder {
    private final DnsRecordDecoder decoder;

    public TcpDnsQueryDecoder() {
        this(DnsRecordDecoder.DEFAULT, 65535);
    }

    public TcpDnsQueryDecoder(DnsRecordDecoder decoder, int maxFrameLength) {
        super(maxFrameLength, 0, 2, 0, 2);
        this.decoder = ObjectUtil.checkNotNull(decoder, "decoder");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object decode(ChannelHandlerContext ctx, ByteBuf in) throws Exception {
        ByteBuf frame2 = (ByteBuf)super.decode(ctx, in);
        if (frame2 == null) {
            return null;
        }
        try {
            DnsQuery dnsQuery = DnsMessageUtil.decodeDnsQuery(this.decoder, frame2.slice(), new DnsMessageUtil.DnsQueryFactory(){

                @Override
                public DnsQuery newQuery(int id, DnsOpCode dnsOpCode) {
                    return new DefaultDnsQuery(id, dnsOpCode);
                }
            });
            return dnsQuery;
        }
        finally {
            frame2.release();
        }
    }
}

