/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractByteBuf;
import io.netty.buffer.AbstractPooledDerivedByteBuf;
import io.netty.buffer.AbstractUnpooledSlicedByteBuf;
import io.netty.buffer.ByteBuf;
import io.netty.util.ByteProcessor;
import io.netty.util.Recycler;
import io.netty.util.internal.ObjectPool;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;

final class PooledSlicedByteBuf
extends AbstractPooledDerivedByteBuf {
    private static final Recycler<PooledSlicedByteBuf> RECYCLER = new Recycler<PooledSlicedByteBuf>(){

        @Override
        protected PooledSlicedByteBuf newObject(Recycler.Handle<PooledSlicedByteBuf> handle2) {
            return new PooledSlicedByteBuf(handle2);
        }
    };
    int adjustment;

    static PooledSlicedByteBuf newInstance(AbstractByteBuf unwrapped, ByteBuf wrapped, int index2, int length) {
        AbstractUnpooledSlicedByteBuf.checkSliceOutOfBounds(index2, length, unwrapped);
        return PooledSlicedByteBuf.newInstance0(unwrapped, wrapped, index2, length);
    }

    private static PooledSlicedByteBuf newInstance0(AbstractByteBuf unwrapped, ByteBuf wrapped, int adjustment, int length) {
        PooledSlicedByteBuf slice = RECYCLER.get();
        slice.init(unwrapped, wrapped, 0, length, length);
        slice.discardMarks();
        slice.adjustment = adjustment;
        return slice;
    }

    private PooledSlicedByteBuf(ObjectPool.Handle<PooledSlicedByteBuf> handle2) {
        super(handle2);
    }

    @Override
    public int capacity() {
        return this.maxCapacity();
    }

    @Override
    public ByteBuf capacity(int newCapacity) {
        throw new UnsupportedOperationException("sliced buffer");
    }

    @Override
    public int arrayOffset() {
        return this.idx(this.unwrap().arrayOffset());
    }

    @Override
    public long memoryAddress() {
        return this.unwrap().memoryAddress() + (long)this.adjustment;
    }

    @Override
    public ByteBuffer nioBuffer(int index2, int length) {
        this.checkIndex0(index2, length);
        return this.unwrap().nioBuffer(this.idx(index2), length);
    }

    @Override
    public ByteBuffer[] nioBuffers(int index2, int length) {
        this.checkIndex0(index2, length);
        return this.unwrap().nioBuffers(this.idx(index2), length);
    }

    @Override
    public ByteBuf copy(int index2, int length) {
        this.checkIndex0(index2, length);
        return this.unwrap().copy(this.idx(index2), length);
    }

    @Override
    public ByteBuf slice(int index2, int length) {
        this.checkIndex0(index2, length);
        return super.slice(this.idx(index2), length);
    }

    @Override
    public ByteBuf retainedSlice(int index2, int length) {
        this.checkIndex0(index2, length);
        return PooledSlicedByteBuf.newInstance0(this.unwrap(), this, this.idx(index2), length);
    }

    @Override
    public ByteBuf duplicate() {
        return this.slice(0, this.capacity()).setIndex(this.readerIndex(), this.writerIndex());
    }

    @Override
    public ByteBuf retainedDuplicate() {
        return this.retainedSlice(0, this.capacity()).setIndex(this.readerIndex(), this.writerIndex());
    }

    @Override
    public byte getByte(int index2) {
        this.checkIndex(index2, 1);
        return this._getByte(index2);
    }

    @Override
    protected byte _getByte(int index2) {
        return this.unwrap()._getByte(this.idx(index2));
    }

    @Override
    public short getShort(int index2) {
        this.checkIndex(index2, 2);
        return this._getShort(index2);
    }

    @Override
    protected short _getShort(int index2) {
        return this.unwrap()._getShort(this.idx(index2));
    }

    @Override
    public short getShortLE(int index2) {
        this.checkIndex(index2, 2);
        return this._getShortLE(index2);
    }

    @Override
    protected short _getShortLE(int index2) {
        return this.unwrap()._getShortLE(this.idx(index2));
    }

    @Override
    public int getUnsignedMedium(int index2) {
        this.checkIndex(index2, 3);
        return this._getUnsignedMedium(index2);
    }

    @Override
    protected int _getUnsignedMedium(int index2) {
        return this.unwrap()._getUnsignedMedium(this.idx(index2));
    }

    @Override
    public int getUnsignedMediumLE(int index2) {
        this.checkIndex(index2, 3);
        return this._getUnsignedMediumLE(index2);
    }

    @Override
    protected int _getUnsignedMediumLE(int index2) {
        return this.unwrap()._getUnsignedMediumLE(this.idx(index2));
    }

    @Override
    public int getInt(int index2) {
        this.checkIndex(index2, 4);
        return this._getInt(index2);
    }

    @Override
    protected int _getInt(int index2) {
        return this.unwrap()._getInt(this.idx(index2));
    }

    @Override
    public int getIntLE(int index2) {
        this.checkIndex(index2, 4);
        return this._getIntLE(index2);
    }

    @Override
    protected int _getIntLE(int index2) {
        return this.unwrap()._getIntLE(this.idx(index2));
    }

    @Override
    public long getLong(int index2) {
        this.checkIndex(index2, 8);
        return this._getLong(index2);
    }

    @Override
    protected long _getLong(int index2) {
        return this.unwrap()._getLong(this.idx(index2));
    }

    @Override
    public long getLongLE(int index2) {
        this.checkIndex(index2, 8);
        return this._getLongLE(index2);
    }

    @Override
    protected long _getLongLE(int index2) {
        return this.unwrap()._getLongLE(this.idx(index2));
    }

    @Override
    public ByteBuf getBytes(int index2, ByteBuf dst, int dstIndex, int length) {
        this.checkIndex0(index2, length);
        this.unwrap().getBytes(this.idx(index2), dst, dstIndex, length);
        return this;
    }

    @Override
    public ByteBuf getBytes(int index2, byte[] dst, int dstIndex, int length) {
        this.checkIndex0(index2, length);
        this.unwrap().getBytes(this.idx(index2), dst, dstIndex, length);
        return this;
    }

    @Override
    public ByteBuf getBytes(int index2, ByteBuffer dst) {
        this.checkIndex0(index2, dst.remaining());
        this.unwrap().getBytes(this.idx(index2), dst);
        return this;
    }

    @Override
    public ByteBuf setByte(int index2, int value) {
        this.checkIndex(index2, 1);
        this._setByte(index2, value);
        return this;
    }

    @Override
    protected void _setByte(int index2, int value) {
        this.unwrap()._setByte(this.idx(index2), value);
    }

    @Override
    public ByteBuf setShort(int index2, int value) {
        this.checkIndex(index2, 2);
        this._setShort(index2, value);
        return this;
    }

    @Override
    protected void _setShort(int index2, int value) {
        this.unwrap()._setShort(this.idx(index2), value);
    }

    @Override
    public ByteBuf setShortLE(int index2, int value) {
        this.checkIndex(index2, 2);
        this._setShortLE(index2, value);
        return this;
    }

    @Override
    protected void _setShortLE(int index2, int value) {
        this.unwrap()._setShortLE(this.idx(index2), value);
    }

    @Override
    public ByteBuf setMedium(int index2, int value) {
        this.checkIndex(index2, 3);
        this._setMedium(index2, value);
        return this;
    }

    @Override
    protected void _setMedium(int index2, int value) {
        this.unwrap()._setMedium(this.idx(index2), value);
    }

    @Override
    public ByteBuf setMediumLE(int index2, int value) {
        this.checkIndex(index2, 3);
        this._setMediumLE(index2, value);
        return this;
    }

    @Override
    protected void _setMediumLE(int index2, int value) {
        this.unwrap()._setMediumLE(this.idx(index2), value);
    }

    @Override
    public ByteBuf setInt(int index2, int value) {
        this.checkIndex(index2, 4);
        this._setInt(index2, value);
        return this;
    }

    @Override
    protected void _setInt(int index2, int value) {
        this.unwrap()._setInt(this.idx(index2), value);
    }

    @Override
    public ByteBuf setIntLE(int index2, int value) {
        this.checkIndex(index2, 4);
        this._setIntLE(index2, value);
        return this;
    }

    @Override
    protected void _setIntLE(int index2, int value) {
        this.unwrap()._setIntLE(this.idx(index2), value);
    }

    @Override
    public ByteBuf setLong(int index2, long value) {
        this.checkIndex(index2, 8);
        this._setLong(index2, value);
        return this;
    }

    @Override
    protected void _setLong(int index2, long value) {
        this.unwrap()._setLong(this.idx(index2), value);
    }

    @Override
    public ByteBuf setLongLE(int index2, long value) {
        this.checkIndex(index2, 8);
        this._setLongLE(index2, value);
        return this;
    }

    @Override
    protected void _setLongLE(int index2, long value) {
        this.unwrap()._setLongLE(this.idx(index2), value);
    }

    @Override
    public ByteBuf setBytes(int index2, byte[] src, int srcIndex, int length) {
        this.checkIndex0(index2, length);
        this.unwrap().setBytes(this.idx(index2), src, srcIndex, length);
        return this;
    }

    @Override
    public ByteBuf setBytes(int index2, ByteBuf src, int srcIndex, int length) {
        this.checkIndex0(index2, length);
        this.unwrap().setBytes(this.idx(index2), src, srcIndex, length);
        return this;
    }

    @Override
    public ByteBuf setBytes(int index2, ByteBuffer src) {
        this.checkIndex0(index2, src.remaining());
        this.unwrap().setBytes(this.idx(index2), src);
        return this;
    }

    @Override
    public ByteBuf getBytes(int index2, OutputStream out, int length) throws IOException {
        this.checkIndex0(index2, length);
        this.unwrap().getBytes(this.idx(index2), out, length);
        return this;
    }

    @Override
    public int getBytes(int index2, GatheringByteChannel out, int length) throws IOException {
        this.checkIndex0(index2, length);
        return this.unwrap().getBytes(this.idx(index2), out, length);
    }

    @Override
    public int getBytes(int index2, FileChannel out, long position, int length) throws IOException {
        this.checkIndex0(index2, length);
        return this.unwrap().getBytes(this.idx(index2), out, position, length);
    }

    @Override
    public int setBytes(int index2, InputStream in, int length) throws IOException {
        this.checkIndex0(index2, length);
        return this.unwrap().setBytes(this.idx(index2), in, length);
    }

    @Override
    public int setBytes(int index2, ScatteringByteChannel in, int length) throws IOException {
        this.checkIndex0(index2, length);
        return this.unwrap().setBytes(this.idx(index2), in, length);
    }

    @Override
    public int setBytes(int index2, FileChannel in, long position, int length) throws IOException {
        this.checkIndex0(index2, length);
        return this.unwrap().setBytes(this.idx(index2), in, position, length);
    }

    @Override
    public int forEachByte(int index2, int length, ByteProcessor processor) {
        this.checkIndex0(index2, length);
        int ret = this.unwrap().forEachByte(this.idx(index2), length, processor);
        if (ret < this.adjustment) {
            return -1;
        }
        return ret - this.adjustment;
    }

    @Override
    public int forEachByteDesc(int index2, int length, ByteProcessor processor) {
        this.checkIndex0(index2, length);
        int ret = this.unwrap().forEachByteDesc(this.idx(index2), length, processor);
        if (ret < this.adjustment) {
            return -1;
        }
        return ret - this.adjustment;
    }

    private int idx(int index2) {
        return index2 + this.adjustment;
    }
}

