/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.VarHandleByteBufferAccess;
import io.netty.util.internal.PlatformDependent;

final class HeapByteBufUtil {
    static byte getByte(byte[] memory, int index2) {
        return memory[index2];
    }

    static short getShort(byte[] memory, int index2) {
        if (PlatformDependent.hasVarHandle()) {
            return VarHandleByteBufferAccess.getShortBE(memory, index2);
        }
        return HeapByteBufUtil.getShort0(memory, index2);
    }

    private static short getShort0(byte[] memory, int index2) {
        return (short)(memory[index2] << 8 | memory[index2 + 1] & 0xFF);
    }

    static short getShortLE(byte[] memory, int index2) {
        if (PlatformDependent.hasVarHandle()) {
            return VarHandleByteBufferAccess.getShortLE(memory, index2);
        }
        return (short)(memory[index2] & 0xFF | memory[index2 + 1] << 8);
    }

    static int getUnsignedMedium(byte[] memory, int index2) {
        return (memory[index2] & 0xFF) << 16 | (memory[index2 + 1] & 0xFF) << 8 | memory[index2 + 2] & 0xFF;
    }

    static int getUnsignedMediumLE(byte[] memory, int index2) {
        return memory[index2] & 0xFF | (memory[index2 + 1] & 0xFF) << 8 | (memory[index2 + 2] & 0xFF) << 16;
    }

    static int getInt(byte[] memory, int index2) {
        if (PlatformDependent.hasVarHandle()) {
            return VarHandleByteBufferAccess.getIntBE(memory, index2);
        }
        return HeapByteBufUtil.getInt0(memory, index2);
    }

    private static int getInt0(byte[] memory, int index2) {
        return (memory[index2] & 0xFF) << 24 | (memory[index2 + 1] & 0xFF) << 16 | (memory[index2 + 2] & 0xFF) << 8 | memory[index2 + 3] & 0xFF;
    }

    static int getIntLE(byte[] memory, int index2) {
        if (PlatformDependent.hasVarHandle()) {
            return VarHandleByteBufferAccess.getIntLE(memory, index2);
        }
        return HeapByteBufUtil.getIntLE0(memory, index2);
    }

    private static int getIntLE0(byte[] memory, int index2) {
        return memory[index2] & 0xFF | (memory[index2 + 1] & 0xFF) << 8 | (memory[index2 + 2] & 0xFF) << 16 | (memory[index2 + 3] & 0xFF) << 24;
    }

    static long getLong(byte[] memory, int index2) {
        if (PlatformDependent.hasVarHandle()) {
            return VarHandleByteBufferAccess.getLongBE(memory, index2);
        }
        return HeapByteBufUtil.getLong0(memory, index2);
    }

    private static long getLong0(byte[] memory, int index2) {
        return ((long)memory[index2] & 0xFFL) << 56 | ((long)memory[index2 + 1] & 0xFFL) << 48 | ((long)memory[index2 + 2] & 0xFFL) << 40 | ((long)memory[index2 + 3] & 0xFFL) << 32 | ((long)memory[index2 + 4] & 0xFFL) << 24 | ((long)memory[index2 + 5] & 0xFFL) << 16 | ((long)memory[index2 + 6] & 0xFFL) << 8 | (long)memory[index2 + 7] & 0xFFL;
    }

    static long getLongLE(byte[] memory, int index2) {
        if (PlatformDependent.hasVarHandle()) {
            return VarHandleByteBufferAccess.getLongLE(memory, index2);
        }
        return HeapByteBufUtil.getLongLE0(memory, index2);
    }

    private static long getLongLE0(byte[] memory, int index2) {
        return (long)memory[index2] & 0xFFL | ((long)memory[index2 + 1] & 0xFFL) << 8 | ((long)memory[index2 + 2] & 0xFFL) << 16 | ((long)memory[index2 + 3] & 0xFFL) << 24 | ((long)memory[index2 + 4] & 0xFFL) << 32 | ((long)memory[index2 + 5] & 0xFFL) << 40 | ((long)memory[index2 + 6] & 0xFFL) << 48 | ((long)memory[index2 + 7] & 0xFFL) << 56;
    }

    static void setByte(byte[] memory, int index2, int value) {
        memory[index2] = (byte)(value & 0xFF);
    }

    static void setShort(byte[] memory, int index2, int value) {
        if (PlatformDependent.hasVarHandle()) {
            VarHandleByteBufferAccess.setShortBE(memory, index2, value);
            return;
        }
        memory[index2] = (byte)(value >>> 8);
        memory[index2 + 1] = (byte)value;
    }

    static void setShortLE(byte[] memory, int index2, int value) {
        if (PlatformDependent.hasVarHandle()) {
            VarHandleByteBufferAccess.setShortLE(memory, index2, value);
            return;
        }
        memory[index2] = (byte)value;
        memory[index2 + 1] = (byte)(value >>> 8);
    }

    static void setMedium(byte[] memory, int index2, int value) {
        memory[index2] = (byte)(value >>> 16);
        memory[index2 + 1] = (byte)(value >>> 8);
        memory[index2 + 2] = (byte)value;
    }

    static void setMediumLE(byte[] memory, int index2, int value) {
        memory[index2] = (byte)value;
        memory[index2 + 1] = (byte)(value >>> 8);
        memory[index2 + 2] = (byte)(value >>> 16);
    }

    static void setInt(byte[] memory, int index2, int value) {
        if (PlatformDependent.hasVarHandle()) {
            VarHandleByteBufferAccess.setIntBE(memory, index2, value);
            return;
        }
        HeapByteBufUtil.setInt0(memory, index2, value);
    }

    private static void setInt0(byte[] memory, int index2, int value) {
        memory[index2] = (byte)(value >>> 24);
        memory[index2 + 1] = (byte)(value >>> 16);
        memory[index2 + 2] = (byte)(value >>> 8);
        memory[index2 + 3] = (byte)value;
    }

    static void setIntLE(byte[] memory, int index2, int value) {
        if (PlatformDependent.hasVarHandle()) {
            VarHandleByteBufferAccess.setIntLE(memory, index2, value);
            return;
        }
        HeapByteBufUtil.setIntLE0(memory, index2, value);
    }

    private static void setIntLE0(byte[] memory, int index2, int value) {
        memory[index2] = (byte)value;
        memory[index2 + 1] = (byte)(value >>> 8);
        memory[index2 + 2] = (byte)(value >>> 16);
        memory[index2 + 3] = (byte)(value >>> 24);
    }

    static void setLong(byte[] memory, int index2, long value) {
        if (PlatformDependent.hasVarHandle()) {
            VarHandleByteBufferAccess.setLongBE(memory, index2, value);
            return;
        }
        HeapByteBufUtil.setLong0(memory, index2, value);
    }

    private static void setLong0(byte[] memory, int index2, long value) {
        memory[index2] = (byte)(value >>> 56);
        memory[index2 + 1] = (byte)(value >>> 48);
        memory[index2 + 2] = (byte)(value >>> 40);
        memory[index2 + 3] = (byte)(value >>> 32);
        memory[index2 + 4] = (byte)(value >>> 24);
        memory[index2 + 5] = (byte)(value >>> 16);
        memory[index2 + 6] = (byte)(value >>> 8);
        memory[index2 + 7] = (byte)value;
    }

    static void setLongLE(byte[] memory, int index2, long value) {
        if (PlatformDependent.hasVarHandle()) {
            VarHandleByteBufferAccess.setLongLE(memory, index2, value);
            return;
        }
        HeapByteBufUtil.setLongLE0(memory, index2, value);
    }

    private static void setLongLE0(byte[] memory, int index2, long value) {
        memory[index2] = (byte)value;
        memory[index2 + 1] = (byte)(value >>> 8);
        memory[index2 + 2] = (byte)(value >>> 16);
        memory[index2 + 3] = (byte)(value >>> 24);
        memory[index2 + 4] = (byte)(value >>> 32);
        memory[index2 + 5] = (byte)(value >>> 40);
        memory[index2 + 6] = (byte)(value >>> 48);
        memory[index2 + 7] = (byte)(value >>> 56);
    }

    private HeapByteBufUtil() {
    }
}

