/*
 * Decompiled with CFR 0.152.
 */
package export;

import androidx.compose.runtime.internal.StabilityInferred;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0012\n\u0002\b\b\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0086@\u00a2\u0006\u0002\u0010\u000eJ$\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\r0\u00122\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015J\u0012\u0010\u0016\u001a\u00020\u0017*\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0005J.\u0010\u0019\u001a\u00020\u00102\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00170\u00122\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J(\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00152\u0006\u0010 \u001a\u00020\u00152\u0006\u0010!\u001a\u00020\u0007H\u0002J0\u0010\"\u001a\u00020\u00102\u0006\u0010#\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00152\u0006\u0010 \u001a\u00020\u00152\u0006\u0010!\u001a\u00020\u0007H\u0002J\u0018\u0010$\u001a\u00020\u00152\u0006\u0010#\u001a\u00020\u00152\u0006\u0010%\u001a\u00020\u0015H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lexport/AudioMixer;", "", "<init>", "()V", "COMMON_AUDIO_FORMAT", "Ljavax/sound/sampled/AudioFormat;", "mergeAudioToWavFile", "", "soundMetaData", "LSoundMetaData;", "startTimeMs", "", "outputWavFile", "Ljava/io/File;", "(LSoundMetaData;JLjava/io/File;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "mixAndSave", "", "inputFiles", "", "outputFile", "maxDurationMs", "", "convertToFormat", "Ljavax/sound/sampled/AudioInputStream;", "targetFormat", "mixConvertedStreams", "streams", "format", "bytesToSample", "buffer", "", "offset", "sampleSize", "isBigEndian", "sampleToBytes", "sample", "normalizeSample", "sampleSizeInBytes", "app.red-mycelium.com"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nAudioMixer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AudioMixer.kt\nexport/AudioMixer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,356:1\n1557#2:357\n1628#2,3:358\n1557#2:361\n1628#2,3:362\n*S KotlinDebug\n*F\n+ 1 AudioMixer.kt\nexport/AudioMixer\n*L\n123#1:357\n123#1:358,3\n133#1:361\n133#1:362,3\n*E\n"})
public final class AudioMixer {
    @NotNull
    public static final AudioMixer INSTANCE = new AudioMixer();
    @NotNull
    private static final AudioFormat COMMON_AUDIO_FORMAT = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 44100.0f, 16, 2, 4, 44100.0f, false);
    public static final int $stable = 8;

    private AudioMixer() {
    }

    @Nullable
    public final Object mergeAudioToWavFile(@NotNull SoundMetaData soundMetaData, long startTimeMs, @NotNull File outputWavFile, @NotNull Continuation<? super Boolean> $completion) {
        return BuildersKt.withContext(Dispatchers.getIO(), (Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(soundMetaData, startTimeMs, outputWavFile, null){
            int label;
            final /* synthetic */ SoundMetaData $soundMetaData;
            final /* synthetic */ long $startTimeMs;
            final /* synthetic */ File $outputWavFile;
            {
                this.$soundMetaData = $soundMetaData;
                this.$startTimeMs = $startTimeMs;
                this.$outputWavFile = $outputWavFile;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        boolean bl;
                        ResultKt.throwOnFailure(object);
                        try {
                            Object silence;
                            float sampleRate;
                            void $this$mapTo$iv$iv;
                            Iterable $this$sortedBy$iv = MapsKt.toList(this.$soundMetaData.getTimeToFileName());
                            boolean $i$f$sortedBy22 = false;
                            Iterable $this$map$iv = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

                                public final int compare(T a, T b) {
                                    Pair it = (Pair)a;
                                    boolean bl = false;
                                    Comparable comparable = (Long)it.getFirst();
                                    it = (Pair)b;
                                    Comparable comparable2 = comparable;
                                    bl = false;
                                    return ComparisonsKt.compareValues(comparable2, (Comparable)((Long)it.getFirst()));
                                }
                            });
                            SoundMetaData $i$f$sortedBy22 = this.$soundMetaData;
                            boolean $i$f$map = false;
                            Iterable iterable = $this$map$iv;
                            Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                            boolean $i$f$mapTo = false;
                            for (T item$iv$iv : $this$mapTo$iv$iv) {
                                void it;
                                Pair pair = (Pair)item$iv$iv;
                                Collection collection = destination$iv$iv;
                                boolean bl2 = false;
                                collection.add(new File($i$f$sortedBy22.getFolderPath() + "/" + it.getSecond()));
                            }
                            List sortedFiles = (List)destination$iv$iv;
                            if (sortedFiles.isEmpty()) {
                                System.out.println((Object)("no sound files for " + this.$soundMetaData.getFolderPath()));
                                return Boxing.boxBoolean(false);
                            }
                            AudioFormat audioFormat = this.$soundMetaData.getFormat();
                            int frameSize = audioFormat.getFrameSize();
                            float framesPerSecond = sampleRate = audioFormat.getSampleRate();
                            long silenceFrames = (long)((float)this.$startTimeMs * framesPerSecond / (float)1000);
                            int silenceBytes = (int)(silenceFrames * (long)frameSize);
                            ByteArrayOutputStream mergedData = new ByteArrayOutputStream();
                            if (silenceBytes > 0) {
                                silence = new byte[silenceBytes];
                                mergedData.write((byte[])silence);
                            }
                            silence = sortedFiles.iterator();
                            while (silence.hasNext()) {
                                File audioFile = (File)silence.next();
                                byte[] fileData = FilesKt.readBytes(audioFile);
                                if (fileData.length % frameSize != 0) {
                                    String string = "Warning: Audio file " + audioFile.getName() + " size (" + fileData.length + " bytes) is not multiple of frame size (" + frameSize + " bytes)";
                                    System.out.println((Object)string);
                                    int validSize = fileData.length / frameSize * frameSize;
                                    mergedData.write(fileData, 0, validSize);
                                    continue;
                                }
                                mergedData.write(fileData);
                            }
                            int totalBytes = mergedData.size();
                            int totalFrames = totalBytes / frameSize;
                            if (totalBytes % frameSize != 0) {
                                System.out.println((Object)("Warning: Total size (" + totalBytes + " bytes) is not multiple of frame size (" + frameSize + " bytes)"));
                                int validBytes = totalBytes / frameSize * frameSize;
                                byte[] byArray = mergedData.toByteArray();
                                Intrinsics.checkNotNullExpressionValue(byArray, "toByteArray(...)");
                                byte[] byArray2 = Arrays.copyOf(byArray, validBytes);
                                Intrinsics.checkNotNullExpressionValue(byArray2, "copyOf(...)");
                                byte[] validData = byArray2;
                                mergedData.reset();
                                mergedData.write(validData);
                            }
                            AudioInputStream audioInputStream = new AudioInputStream(new ByteArrayInputStream(mergedData.toByteArray()), audioFormat, totalFrames);
                            AudioSystem.write(audioInputStream, AudioFileFormat.Type.WAVE, this.$outputWavFile);
                            audioInputStream.close();
                            mergedData.close();
                            System.out.println((Object)("Successfully merged " + sortedFiles.size() + " audio fragments to " + this.$outputWavFile.getAbsolutePath() + " with " + this.$startTimeMs + "ms silence at start (" + silenceFrames + " frames, " + silenceBytes + " bytes)"));
                            bl = true;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            bl = false;
                        }
                        return Boxing.boxBoolean(bl);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Boolean> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
    }

    /*
     * WARNING - void declaration
     */
    public final void mixAndSave(@NotNull List<? extends File> inputFiles, @NotNull File outputFile, int maxDurationMs) throws IOException, UnsupportedAudioFileException {
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter(inputFiles, "inputFiles");
        Intrinsics.checkNotNullParameter(outputFile, "outputFile");
        AudioFormat targetFormat = COMMON_AUDIO_FORMAT;
        Iterable $this$map$iv = inputFiles;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            File file = (File)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(AudioSystem.getAudioInputStream((File)it));
        }
        List streams = (List)destination$iv$iv;
        if (streams.isEmpty()) {
            System.out.println((Object)"\u041d\u0435\u0442 \u0430\u0443\u0434\u0438\u043e\u043f\u043e\u0442\u043e\u043a\u043e\u0432 \u0434\u043b\u044f \u0441\u043c\u0435\u0448\u0438\u0432\u0430\u043d\u0438\u044f");
            return;
        }
        Iterable $this$map$iv2 = streams;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void stream;
            AudioInputStream bl = (AudioInputStream)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(stream.getFormat().matches(targetFormat) ? stream : INSTANCE.convertToFormat((AudioInputStream)stream, targetFormat));
        }
        List convertedStreams = (List)destination$iv$iv2;
        this.mixConvertedStreams(convertedStreams, outputFile, targetFormat, maxDurationMs);
    }

    @NotNull
    public final AudioInputStream convertToFormat(@NotNull AudioInputStream $this$convertToFormat, @NotNull AudioFormat targetFormat) {
        AudioInputStream audioInputStream;
        Intrinsics.checkNotNullParameter($this$convertToFormat, "<this>");
        Intrinsics.checkNotNullParameter(targetFormat, "targetFormat");
        if ($this$convertToFormat.getFormat().getChannels() == targetFormat.getChannels()) {
            AudioInputStream audioInputStream2 = AudioSystem.getAudioInputStream(targetFormat, $this$convertToFormat);
            Intrinsics.checkNotNull(audioInputStream2);
            audioInputStream = audioInputStream2;
        } else {
            AudioFormat intermediateFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, $this$convertToFormat.getFormat().getSampleRate(), 16, $this$convertToFormat.getFormat().getChannels(), targetFormat.getChannels(), $this$convertToFormat.getFormat().getSampleRate(), false);
            AudioInputStream intermediateStream = AudioSystem.getAudioInputStream(intermediateFormat, $this$convertToFormat);
            AudioInputStream audioInputStream3 = AudioSystem.getAudioInputStream(targetFormat, intermediateStream);
            Intrinsics.checkNotNull(audioInputStream3);
            audioInputStream = audioInputStream3;
        }
        return audioInputStream;
    }

    private final void mixConvertedStreams(List<? extends AudioInputStream> streams, File outputFile, AudioFormat format, int maxDurationMs) throws IOException {
        long framesProcessed;
        int framesToRead;
        for (AudioInputStream audioInputStream : streams) {
            if (audioInputStream.getFormat().matches(format)) continue;
            boolean $i$a$-require-AudioMixer$mixConvertedStreams$232 = false;
            String $i$a$-require-AudioMixer$mixConvertedStreams$232 = "\u0424\u043e\u0440\u043c\u0430\u0442\u044b \u0430\u0443\u0434\u0438\u043e \u043d\u0435 \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u044e\u0442 \u043f\u043e\u0441\u043b\u0435 \u043a\u043e\u043d\u0432\u0435\u0440\u0442\u0430\u0446\u0438\u0438. " + audioInputStream.getFormat() + " " + format;
            throw new IllegalArgumentException($i$a$-require-AudioMixer$mixConvertedStreams$232.toString());
        }
        long totalFrames = (long)(format.getSampleRate() / (float)1000 * (float)maxDurationMs);
        ByteArrayOutputStream mixedBAOS = new ByteArrayOutputStream();
        int frameSize = format.getFrameSize();
        int sampleSizeInBytes = format.getSampleSizeInBits() / 8;
        int channels = format.getChannels();
        boolean isBigEndian = format.isBigEndian();
        int bufferSize = 4096 * frameSize;
        byte[] buffer = new byte[bufferSize];
        int n = 0;
        int n2 = streams.size();
        byte[][] byArrayArray = new byte[n2][];
        while (n < n2) {
            int n3 = n++;
            byArrayArray[n3] = new byte[bufferSize];
        }
        byte[][] streamBuffers = byArrayArray;
        int[] streamBytesRead = new int[streams.size()];
        for (framesProcessed = 0L; framesProcessed < totalFrames; framesProcessed += (long)framesToRead) {
            framesToRead = (int)Math.min(4096L, totalFrames - framesProcessed);
            Iterator iterator2 = ((Iterable)streams).iterator();
            int n4 = 0;
            while (iterator2.hasNext()) {
                int index2 = n4++;
                AudioInputStream audioInputStream = (AudioInputStream)iterator2.next();
                int bytesToRead = framesToRead * frameSize;
                streamBytesRead[index2] = audioInputStream.read(streamBuffers[index2], 0, bytesToRead);
            }
            for (int frame2 = 0; frame2 < framesToRead; ++frame2) {
                for (int channel = 0; channel < channels; ++channel) {
                    int mixedSample = 0;
                    Iterator iterator3 = ((Iterable)streams).iterator();
                    int n3 = 0;
                    while (iterator3.hasNext()) {
                        int sampleOffset;
                        int index3 = n3++;
                        iterator3.next();
                        if (streamBytesRead[index3] <= 0 || (sampleOffset = frame2 * frameSize + channel * sampleSizeInBytes) + sampleSizeInBytes > streamBytesRead[index3]) continue;
                        int sample2 = this.bytesToSample(streamBuffers[index3], sampleOffset, sampleSizeInBytes, isBigEndian);
                        mixedSample += sample2;
                    }
                    mixedSample = this.normalizeSample(mixedSample, sampleSizeInBytes);
                    this.sampleToBytes(mixedSample, buffer, frame2 * frameSize + channel * sampleSizeInBytes, sampleSizeInBytes, isBigEndian);
                }
            }
            int bytesToWrite = framesToRead * frameSize;
            mixedBAOS.write(buffer, 0, bytesToWrite);
        }
        byte[] mixedData = mixedBAOS.toByteArray();
        ByteArrayInputStream mixedBAIS = new ByteArrayInputStream(mixedData);
        AudioInputStream mixedStream = new AudioInputStream(mixedBAIS, format, framesProcessed);
        AudioSystem.write(mixedStream, AudioFileFormat.Type.WAVE, outputFile);
        for (AudioInputStream audioInputStream : streams) {
            audioInputStream.close();
        }
        mixedBAOS.close();
        mixedStream.close();
    }

    private final int bytesToSample(byte[] buffer, int offset2, int sampleSize, boolean isBigEndian) {
        int sample2 = 0;
        if (isBigEndian) {
            for (int i = 0; i < sampleSize; ++i) {
                sample2 = sample2 << 8 | buffer[offset2 + i] & 0xFF;
            }
        } else {
            for (int i = sampleSize - 1; -1 < i; --i) {
                sample2 = sample2 << 8 | buffer[offset2 + i] & 0xFF;
            }
        }
        return switch (sampleSize) {
            case 1 -> sample2 - 128;
            case 2 -> {
                if (sample2 > Short.MAX_VALUE) {
                    yield sample2 - 65536;
                }
                yield sample2;
            }
            default -> sample2;
        };
    }

    private final void sampleToBytes(int sample2, byte[] buffer, int offset2, int sampleSize, boolean isBigEndian) {
        int sampleValue;
        switch (sampleSize) {
            case 1: {
                int n = sample2 + 128;
                break;
            }
            case 2: {
                int n;
                if (sample2 < 0) {
                    n = sample2 + 65536;
                    break;
                }
                n = sample2;
                break;
            }
            default: {
                int n = sampleValue = sample2;
            }
        }
        if (isBigEndian) {
            for (int i = sampleSize - 1; -1 < i; --i) {
                buffer[offset2 + i] = (byte)(sampleValue & 0xFF);
                sampleValue >>= 8;
            }
        } else {
            for (int i = 0; i < sampleSize; ++i) {
                buffer[offset2 + i] = (byte)(sampleValue & 0xFF);
                sampleValue >>= 8;
            }
        }
    }

    private final int normalizeSample(int sample2, int sampleSizeInBytes) {
        int maxValue = switch (sampleSizeInBytes) {
            case 1 -> 127;
            case 2 -> Short.MAX_VALUE;
            case 3 -> 0x7FFFFF;
            default -> Integer.MAX_VALUE;
        };
        int minValue = -maxValue - 1;
        return sample2 > maxValue ? maxValue : (sample2 < minValue ? minValue : sample2);
    }
}

