/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.xml.util;

import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.type.ClassKey;
import com.fasterxml.jackson.databind.util.LRUMap;
import com.fasterxml.jackson.dataformat.xml.util.StaxUtil;
import java.io.Serializable;
import javax.xml.namespace.QName;

public class XmlRootNameLookup
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final QName ROOT_NAME_FOR_NULL = new QName("null");
    protected final transient LRUMap<ClassKey, QName> _rootNames = new LRUMap(40, 200);

    protected Object readResolve() {
        if (this._rootNames == null) {
            return new XmlRootNameLookup();
        }
        return this;
    }

    public QName findRootName(JavaType rootType, MapperConfig<?> config2) {
        return this.findRootName(rootType.getRawClass(), config2);
    }

    public QName findRootName(Class<?> rootType, MapperConfig<?> config2) {
        ClassKey key = new ClassKey(rootType);
        QName name = this._rootNames.get(key);
        if (name != null) {
            return name;
        }
        name = this._findRootName(config2, rootType);
        this._rootNames.put(key, name);
        return name;
    }

    protected QName _findRootName(MapperConfig<?> config2, Class<?> rootType) {
        BeanDescription beanDesc = config2.introspectClassAnnotations(rootType);
        AnnotationIntrospector intr = config2.getAnnotationIntrospector();
        AnnotatedClass ac = beanDesc.getClassInfo();
        String localName = null;
        String ns = null;
        PropertyName root = intr.findRootName(ac);
        if (root != null) {
            localName = root.getSimpleName();
            ns = root.getNamespace();
        }
        if (localName == null || localName.length() == 0) {
            localName = StaxUtil.sanitizeXmlTypeName(rootType.getSimpleName());
            return this._qname(ns, localName);
        }
        if (ns == null || ns.isEmpty()) {
            ns = this._findNamespace(config2, intr, ac);
        }
        return this._qname(ns, localName);
    }

    private QName _qname(String ns, String localName) {
        if (ns == null) {
            ns = "";
        }
        return new QName(ns, localName);
    }

    private String _findNamespace(MapperConfig<?> config2, AnnotationIntrospector ai, AnnotatedClass ann) {
        for (AnnotationIntrospector intr : ai.allIntrospectors()) {
            String ns;
            if (!(intr instanceof AnnotationIntrospector.XmlExtensions) || (ns = ((AnnotationIntrospector.XmlExtensions)((Object)intr)).findNamespace(config2, ann)) == null) continue;
            return ns;
        }
        return null;
    }
}

