/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.xml;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.fasterxml.jackson.databind.jsontype.impl.StdTypeResolverBuilder;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.dataformat.xml.XmlAnnotationIntrospector;
import com.fasterxml.jackson.dataformat.xml.XmlTypeResolverBuilder;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlCData;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlText;
import java.lang.annotation.Annotation;
import java.util.List;

public class JacksonXmlAnnotationIntrospector
extends JacksonAnnotationIntrospector
implements XmlAnnotationIntrospector {
    private static final long serialVersionUID = 1L;
    private static final Class<? extends Annotation>[] ANNOTATIONS_TO_INFER_XML_PROP = new Class[]{JacksonXmlText.class, JacksonXmlElementWrapper.class};
    public static final boolean DEFAULT_USE_WRAPPER = true;
    protected boolean _cfgDefaultUseWrapper;

    public JacksonXmlAnnotationIntrospector() {
        this(true);
    }

    public JacksonXmlAnnotationIntrospector(boolean defaultUseWrapper) {
        this._cfgDefaultUseWrapper = defaultUseWrapper;
    }

    public void setDefaultUseWrapper(boolean b) {
        this._cfgDefaultUseWrapper = b;
    }

    @Override
    public PropertyName findWrapperName(Annotated ann) {
        JacksonXmlElementWrapper w = this._findAnnotation(ann, JacksonXmlElementWrapper.class);
        if (w != null) {
            if (!w.useWrapping()) {
                return PropertyName.NO_NAME;
            }
            String localName = w.localName();
            if (localName == null || localName.length() == 0) {
                return PropertyName.USE_DEFAULT;
            }
            return PropertyName.construct(w.localName(), w.namespace());
        }
        if (this._cfgDefaultUseWrapper) {
            return PropertyName.USE_DEFAULT;
        }
        return null;
    }

    @Override
    public PropertyName findRootName(AnnotatedClass ac) {
        JacksonXmlRootElement root = this._findAnnotation(ac, JacksonXmlRootElement.class);
        if (root != null) {
            String local = root.localName();
            String ns = root.namespace();
            if (local.length() == 0 && ns.length() == 0) {
                return PropertyName.USE_DEFAULT;
            }
            return new PropertyName(local, ns);
        }
        return super.findRootName(ac);
    }

    @Override
    public String findNamespace(MapperConfig<?> config2, Annotated ann) {
        String ns1 = null;
        JacksonXmlProperty xmlProp = this._findAnnotation(ann, JacksonXmlProperty.class);
        if (xmlProp != null) {
            ns1 = xmlProp.namespace();
        }
        JsonProperty jprop = this._findAnnotation(ann, JsonProperty.class);
        String ns2 = null;
        if (jprop != null) {
            ns2 = jprop.namespace();
        }
        if (ns1 == null) {
            return ns2;
        }
        if (ns2 == null) {
            return ns1;
        }
        if (ns1.isEmpty()) {
            return ns2;
        }
        return ns1;
    }

    @Override
    public void findAndAddVirtualProperties(MapperConfig<?> config2, AnnotatedClass ac, List<BeanPropertyWriter> properties2) {
    }

    @Override
    public Boolean isOutputAsAttribute(MapperConfig<?> config2, Annotated ann) {
        JacksonXmlProperty prop = this._findAnnotation(ann, JacksonXmlProperty.class);
        if (prop != null) {
            return prop.isAttribute() ? Boolean.TRUE : Boolean.FALSE;
        }
        return null;
    }

    @Override
    public Boolean isOutputAsText(MapperConfig<?> config2, Annotated ann) {
        JacksonXmlText prop = this._findAnnotation(ann, JacksonXmlText.class);
        if (prop != null) {
            return prop.value() ? Boolean.TRUE : Boolean.FALSE;
        }
        return null;
    }

    @Override
    public Boolean isOutputAsCData(MapperConfig<?> config2, Annotated ann) {
        JacksonXmlCData prop = ann.getAnnotation(JacksonXmlCData.class);
        if (prop != null) {
            return prop.value() ? Boolean.TRUE : Boolean.FALSE;
        }
        return null;
    }

    @Override
    public PropertyName findNameForSerialization(Annotated a) {
        PropertyName pn = PropertyName.merge(this._findXmlName(a), super.findNameForSerialization(a));
        if (pn == null && this._hasOneOf(a, ANNOTATIONS_TO_INFER_XML_PROP)) {
            return PropertyName.USE_DEFAULT;
        }
        return pn;
    }

    @Override
    public PropertyName findNameForDeserialization(Annotated a) {
        PropertyName pn = PropertyName.merge(this._findXmlName(a), super.findNameForDeserialization(a));
        if (pn == null && this._hasOneOf(a, ANNOTATIONS_TO_INFER_XML_PROP)) {
            return PropertyName.USE_DEFAULT;
        }
        return pn;
    }

    @Override
    protected StdTypeResolverBuilder _constructStdTypeResolverBuilder() {
        return new XmlTypeResolverBuilder();
    }

    @Override
    protected TypeResolverBuilder<?> _constructStdTypeResolverBuilder(MapperConfig<?> config2, JsonTypeInfo.Value typeInfo, JavaType baseType) {
        return new XmlTypeResolverBuilder(typeInfo);
    }

    protected PropertyName _findXmlName(Annotated a) {
        JacksonXmlProperty pann = this._findAnnotation(a, JacksonXmlProperty.class);
        if (pann != null) {
            return PropertyName.construct(pann.localName(), pann.namespace());
        }
        return null;
    }
}

