/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.util;

import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Objects;
import java.util.TimeZone;

@Deprecated
public class ISO8601Utils {
    protected static final int DEF_8601_LEN = "yyyy-MM-ddThh:mm:ss.SSS+00:00".length();
    private static final TimeZone TIMEZONE_Z = TimeZone.getTimeZone("UTC");

    public static String format(Date date) {
        return ISO8601Utils.format(date, false, TIMEZONE_Z);
    }

    public static String format(Date date, boolean millis) {
        return ISO8601Utils.format(date, millis, TIMEZONE_Z);
    }

    @Deprecated
    public static String format(Date date, boolean millis, TimeZone tz) {
        return ISO8601Utils.format(date, millis, tz, Locale.US);
    }

    public static String format(Date date, boolean millis, TimeZone tz, Locale loc) {
        int offset2;
        GregorianCalendar calendar = new GregorianCalendar(tz, loc);
        calendar.setTime(date);
        StringBuilder sb = new StringBuilder(30);
        sb.append(String.format("%04d-%02d-%02dT%02d:%02d:%02d", calendar.get(1), calendar.get(2) + 1, calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13)));
        if (millis) {
            sb.append(String.format(".%03d", calendar.get(14)));
        }
        if ((offset2 = tz.getOffset(calendar.getTimeInMillis())) != 0) {
            int hours = Math.abs(offset2 / 60000 / 60);
            int minutes = Math.abs(offset2 / 60000 % 60);
            sb.append(String.format("%c%02d:%02d", Character.valueOf(offset2 < 0 ? (char)'-' : '+'), hours, minutes));
        } else {
            sb.append('Z');
        }
        return sb.toString();
    }

    public static Date parse(String date, ParsePosition pos) throws ParseException {
        Objects.requireNonNull(date);
        Exception fail = null;
        try {
            int offset2 = pos.getIndex();
            int year = ISO8601Utils.parseInt(date, offset2, offset2 += 4);
            if (ISO8601Utils.checkOffset(date, offset2, '-')) {
                // empty if block
            }
            int month = ISO8601Utils.parseInt(date, ++offset2, offset2 += 2);
            if (ISO8601Utils.checkOffset(date, offset2, '-')) {
                // empty if block
            }
            int day = ISO8601Utils.parseInt(date, ++offset2, offset2 += 2);
            int hour = 0;
            int minutes = 0;
            int seconds = 0;
            int milliseconds = 0;
            boolean hasT = ISO8601Utils.checkOffset(date, offset2, 'T');
            if (!hasT && date.length() <= offset2) {
                GregorianCalendar calendar = new GregorianCalendar(year, month - 1, day);
                pos.setIndex(offset2);
                return calendar.getTime();
            }
            if (hasT) {
                char c;
                hour = ISO8601Utils.parseInt(date, ++offset2, offset2 += 2);
                if (ISO8601Utils.checkOffset(date, offset2, ':')) {
                    // empty if block
                }
                minutes = ISO8601Utils.parseInt(date, ++offset2, offset2 += 2);
                if (ISO8601Utils.checkOffset(date, offset2, ':')) {
                    ++offset2;
                }
                if (date.length() > offset2 && (c = date.charAt(offset2)) != 'Z' && c != '+' && c != '-') {
                    if ((seconds = ISO8601Utils.parseInt(date, offset2, offset2 += 2)) > 59 && seconds < 63) {
                        seconds = 59;
                    }
                    if (ISO8601Utils.checkOffset(date, offset2, '.')) {
                        int endOffset = ISO8601Utils.indexOfNonDigit(date, ++offset2 + 1);
                        int parseEndOffset = Math.min(endOffset, offset2 + 3);
                        int fraction = ISO8601Utils.parseInt(date, offset2, parseEndOffset);
                        switch (parseEndOffset - offset2) {
                            case 2: {
                                milliseconds = fraction * 10;
                                break;
                            }
                            case 1: {
                                milliseconds = fraction * 100;
                                break;
                            }
                            default: {
                                milliseconds = fraction;
                            }
                        }
                        offset2 = endOffset;
                    }
                }
            }
            if (date.length() <= offset2) {
                throw new IllegalArgumentException("No time zone indicator");
            }
            TimeZone timezone = null;
            char timezoneIndicator = date.charAt(offset2);
            if (timezoneIndicator == 'Z') {
                timezone = TIMEZONE_Z;
                ++offset2;
            } else if (timezoneIndicator == '+' || timezoneIndicator == '-') {
                String timezoneOffset = date.substring(offset2);
                offset2 += timezoneOffset.length();
                if ("+0000".equals(timezoneOffset) || "+00:00".equals(timezoneOffset)) {
                    timezone = TIMEZONE_Z;
                } else {
                    String cleaned;
                    String timezoneId = "GMT" + timezoneOffset;
                    timezone = TimeZone.getTimeZone(timezoneId);
                    String act = timezone.getID();
                    if (!act.equals(timezoneId) && !(cleaned = act.replace(":", "")).equals(timezoneId)) {
                        throw new IndexOutOfBoundsException("Mismatching time zone indicator: " + timezoneId + " given, resolves to " + timezone.getID());
                    }
                }
            } else {
                throw new IndexOutOfBoundsException("Invalid time zone indicator '" + timezoneIndicator + "'");
            }
            GregorianCalendar calendar = new GregorianCalendar(timezone);
            calendar.setLenient(false);
            calendar.set(1, year);
            calendar.set(2, month - 1);
            calendar.set(5, day);
            calendar.set(11, hour);
            calendar.set(12, minutes);
            calendar.set(13, seconds);
            calendar.set(14, milliseconds);
            pos.setIndex(offset2);
            return calendar.getTime();
        }
        catch (Exception e) {
            fail = e;
            String input = date == null ? null : '\"' + date + '\"';
            String msg = fail.getMessage();
            if (msg == null || msg.isEmpty()) {
                msg = "(" + fail.getClass().getName() + ")";
            }
            ParseException ex = new ParseException("Failed to parse date " + input + ": " + msg, pos.getIndex());
            ex.initCause(fail);
            throw ex;
        }
    }

    private static boolean checkOffset(String value, int offset2, char expected) {
        return offset2 < value.length() && value.charAt(offset2) == expected;
    }

    private static int parseInt(String value, int beginIndex, int endIndex) throws NumberFormatException {
        int digit;
        if (beginIndex < 0 || endIndex > value.length() || beginIndex > endIndex) {
            throw new NumberFormatException(value);
        }
        int i = beginIndex;
        int result2 = 0;
        if (i < endIndex) {
            if ((digit = Character.digit(value.charAt(i++), 10)) < 0) {
                throw new NumberFormatException("Invalid number: " + value.substring(beginIndex, endIndex));
            }
            result2 = -digit;
        }
        while (i < endIndex) {
            if ((digit = Character.digit(value.charAt(i++), 10)) < 0) {
                throw new NumberFormatException("Invalid number: " + value.substring(beginIndex, endIndex));
            }
            result2 *= 10;
            result2 -= digit;
        }
        return -result2;
    }

    private static int indexOfNonDigit(String string, int offset2) {
        for (int i = offset2; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c >= '0' && c <= '9') continue;
            return i;
        }
        return string.length();
    }
}

