/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.internal.shaded.fdp.v2_18_2;

import com.fasterxml.jackson.core.internal.shaded.fdp.v2_18_2.AbstractFloatValueParser;
import com.fasterxml.jackson.core.internal.shaded.fdp.v2_18_2.FastDoubleSwar;

abstract class AbstractJavaFloatingPointBitsFromByteArray
extends AbstractFloatValueParser {
    AbstractJavaFloatingPointBitsFromByteArray() {
    }

    private static int skipWhitespace(byte[] str, int index2, int endIndex) {
        while (index2 < endIndex && (str[index2] & 0xFF) <= 32) {
            ++index2;
        }
        return index2;
    }

    abstract long nan();

    abstract long negativeInfinity();

    private long parseDecFloatLiteral(byte[] str, int index2, int startIndex, int endIndex, boolean isNegative, boolean hasLeadingZero) {
        int exponentOfTruncatedSignificand;
        boolean isSignificandTruncated;
        int exponent;
        int digitCount;
        long significand = 0L;
        int significandStartIndex = index2;
        int virtualIndexOfPoint = -1;
        boolean illegal = false;
        byte ch = 0;
        while (index2 < endIndex) {
            ch = str[index2];
            char digit = (char)(ch - 48);
            if (digit < '\n') {
                significand = 10L * significand + (long)digit;
            } else {
                int digits;
                if (ch != 46) break;
                illegal |= virtualIndexOfPoint >= 0;
                virtualIndexOfPoint = index2;
                while (index2 < endIndex - 4 && (digits = FastDoubleSwar.tryToParseFourDigits(str, index2 + 1)) >= 0) {
                    significand = 10000L * significand + (long)digits;
                    index2 += 4;
                }
            }
            ++index2;
        }
        int significandEndIndex = index2;
        if (virtualIndexOfPoint < 0) {
            digitCount = index2 - significandStartIndex;
            virtualIndexOfPoint = index2;
            exponent = 0;
        } else {
            digitCount = index2 - significandStartIndex - 1;
            exponent = virtualIndexOfPoint - index2 + 1;
        }
        int expNumber = 0;
        if ((ch | 0x20) == 101) {
            char digit;
            boolean isExponentNegative;
            boolean bl = isExponentNegative = (ch = AbstractJavaFloatingPointBitsFromByteArray.charAt(str, ++index2, endIndex)) == 45;
            if (isExponentNegative || ch == 43) {
                ch = AbstractJavaFloatingPointBitsFromByteArray.charAt(str, ++index2, endIndex);
            }
            illegal |= (digit = (char)(ch - 48)) >= '\n';
            do {
                if (expNumber >= 1024) continue;
                expNumber = 10 * expNumber + digit;
            } while ((digit = (char)((ch = AbstractJavaFloatingPointBitsFromByteArray.charAt(str, ++index2, endIndex)) - 48)) < '\n');
            if (isExponentNegative) {
                expNumber = -expNumber;
            }
            exponent += expNumber;
        }
        if ((ch | 0x22) == 102) {
            ++index2;
        }
        index2 = AbstractJavaFloatingPointBitsFromByteArray.skipWhitespace(str, index2, endIndex);
        if (illegal || index2 < endIndex || !hasLeadingZero && digitCount == 0) {
            throw new NumberFormatException("illegal syntax");
        }
        int skipCountInTruncatedDigits = 0;
        if (digitCount > 19) {
            significand = 0L;
            for (index2 = significandStartIndex; index2 < significandEndIndex; ++index2) {
                ch = str[index2];
                if (ch == 46) {
                    ++skipCountInTruncatedDigits;
                    continue;
                }
                if (Long.compareUnsigned(significand, 1000000000000000000L) >= 0) break;
                significand = 10L * significand + (long)ch - 48L;
            }
            isSignificandTruncated = index2 < significandEndIndex;
            exponentOfTruncatedSignificand = virtualIndexOfPoint - index2 + skipCountInTruncatedDigits + expNumber;
        } else {
            isSignificandTruncated = false;
            exponentOfTruncatedSignificand = 0;
        }
        return this.valueOfFloatLiteral(str, startIndex, endIndex, isNegative, significand, exponent, isSignificandTruncated, exponentOfTruncatedSignificand);
    }

    public long parseFloatingPointLiteral(byte[] str, int offset2, int length) {
        boolean hasLeadingZero;
        boolean isNegative;
        int endIndex = AbstractJavaFloatingPointBitsFromByteArray.checkBounds(str.length, offset2, length);
        int index2 = AbstractJavaFloatingPointBitsFromByteArray.skipWhitespace(str, offset2, endIndex);
        if (index2 == endIndex) {
            throw new NumberFormatException("illegal syntax");
        }
        byte ch = str[index2];
        boolean bl = isNegative = ch == 45;
        if ((isNegative || ch == 43) && (ch = AbstractJavaFloatingPointBitsFromByteArray.charAt(str, ++index2, endIndex)) == 0) {
            throw new NumberFormatException("illegal syntax");
        }
        if (ch >= 73) {
            return this.parseNaNOrInfinity(str, index2, endIndex, isNegative);
        }
        boolean bl2 = hasLeadingZero = ch == 48;
        if (hasLeadingZero && ((ch = AbstractJavaFloatingPointBitsFromByteArray.charAt(str, ++index2, endIndex)) | 0x20) == 120) {
            return this.parseHexFloatingPointLiteral(str, index2 + 1, offset2, endIndex, isNegative);
        }
        return this.parseDecFloatLiteral(str, index2, offset2, endIndex, isNegative, hasLeadingZero);
    }

    private long parseHexFloatingPointLiteral(byte[] str, int index2, int startIndex, int endIndex, boolean isNegative) {
        boolean isSignificandTruncated;
        boolean hasExponent;
        int digitCount;
        long significand = 0L;
        int exponent = 0;
        int significandStartIndex = index2;
        int virtualIndexOfPoint = -1;
        boolean illegal = false;
        byte ch = 0;
        while (index2 < endIndex) {
            ch = str[index2];
            int hexValue = AbstractJavaFloatingPointBitsFromByteArray.lookupHex(ch);
            if (hexValue >= 0) {
                significand = significand << 4 | (long)hexValue;
            } else {
                if (hexValue != -4) break;
                illegal |= virtualIndexOfPoint >= 0;
                virtualIndexOfPoint = index2;
            }
            ++index2;
        }
        int significandEndIndex = index2;
        if (virtualIndexOfPoint < 0) {
            digitCount = significandEndIndex - significandStartIndex;
            virtualIndexOfPoint = significandEndIndex;
        } else {
            digitCount = significandEndIndex - significandStartIndex - 1;
            exponent = Math.min(virtualIndexOfPoint - index2 + 1, 1024) * 4;
        }
        int expNumber = 0;
        boolean bl = hasExponent = (ch | 0x20) == 112;
        if (hasExponent) {
            char digit;
            boolean isExponentNegative;
            boolean bl2 = isExponentNegative = (ch = AbstractJavaFloatingPointBitsFromByteArray.charAt(str, ++index2, endIndex)) == 45;
            if (isExponentNegative || ch == 43) {
                ch = AbstractJavaFloatingPointBitsFromByteArray.charAt(str, ++index2, endIndex);
            }
            illegal |= (digit = (char)(ch - 48)) >= '\n';
            do {
                if (expNumber >= 1024) continue;
                expNumber = 10 * expNumber + digit;
            } while ((digit = (char)((ch = AbstractJavaFloatingPointBitsFromByteArray.charAt(str, ++index2, endIndex)) - 48)) < '\n');
            if (isExponentNegative) {
                expNumber = -expNumber;
            }
            exponent += expNumber;
        }
        if ((ch | 0x22) == 102) {
            ++index2;
        }
        index2 = AbstractJavaFloatingPointBitsFromByteArray.skipWhitespace(str, index2, endIndex);
        if (illegal || index2 < endIndex || digitCount == 0 || !hasExponent) {
            throw new NumberFormatException("illegal syntax");
        }
        int skipCountInTruncatedDigits = 0;
        if (digitCount > 16) {
            significand = 0L;
            for (index2 = significandStartIndex; index2 < significandEndIndex; ++index2) {
                ch = str[index2];
                int hexValue = AbstractJavaFloatingPointBitsFromByteArray.lookupHex(ch);
                if (hexValue >= 0) {
                    if (Long.compareUnsigned(significand, 1000000000000000000L) >= 0) break;
                    significand = significand << 4 | (long)hexValue;
                    continue;
                }
                ++skipCountInTruncatedDigits;
            }
            isSignificandTruncated = index2 < significandEndIndex;
        } else {
            isSignificandTruncated = false;
        }
        return this.valueOfHexLiteral(str, startIndex, endIndex, isNegative, significand, exponent, isSignificandTruncated, (virtualIndexOfPoint - index2 + skipCountInTruncatedDigits) * 4 + expNumber);
    }

    private long parseNaNOrInfinity(byte[] str, int index2, int endIndex, boolean isNegative) {
        if (str[index2] == 78) {
            if (index2 + 2 < endIndex && str[index2 + 1] == 97 && str[index2 + 2] == 78 && (index2 = AbstractJavaFloatingPointBitsFromByteArray.skipWhitespace(str, index2 + 3, endIndex)) == endIndex) {
                return this.nan();
            }
        } else if (index2 + 7 < endIndex && FastDoubleSwar.readLongLE(str, index2) == 8751735898823355977L && (index2 = AbstractJavaFloatingPointBitsFromByteArray.skipWhitespace(str, index2 + 8, endIndex)) == endIndex) {
            return isNegative ? this.negativeInfinity() : this.positiveInfinity();
        }
        throw new NumberFormatException("illegal syntax");
    }

    abstract long positiveInfinity();

    abstract long valueOfFloatLiteral(byte[] var1, int var2, int var3, boolean var4, long var5, int var7, boolean var8, int var9);

    abstract long valueOfHexLiteral(byte[] var1, int var2, int var3, boolean var4, long var5, int var7, boolean var8, int var9);
}

