/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.shaded.msv_core.reader.relax;

import com.ctc.wstx.shaded.msv_core.grammar.Expression;
import com.ctc.wstx.shaded.msv_core.grammar.ExpressionPool;
import com.ctc.wstx.shaded.msv_core.reader.ChoiceState;
import com.ctc.wstx.shaded.msv_core.reader.GrammarReader;
import com.ctc.wstx.shaded.msv_core.reader.GrammarReaderController;
import com.ctc.wstx.shaded.msv_core.reader.SequenceState;
import com.ctc.wstx.shaded.msv_core.reader.State;
import com.ctc.wstx.shaded.msv_core.reader.TerminalState;
import com.ctc.wstx.shaded.msv_core.reader.datatype.xsd.FacetState;
import com.ctc.wstx.shaded.msv_core.reader.relax.ElementRefState;
import com.ctc.wstx.shaded.msv_core.reader.relax.HedgeRefState;
import com.ctc.wstx.shaded.msv_core.reader.relax.core.InlineElementState;
import com.ctc.wstx.shaded.msv_core.util.StartTagInfo;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.xml.parsers.SAXParserFactory;

public abstract class RELAXReader
extends GrammarReader {
    public static final String RELAXCoreNamespace = "http://www.xml.gr.jp/xmlns/relaxCore";
    public final StateFactory sfactory;
    public static final String ERR_ILLEGAL_OCCURS = "RELAXReader.IllegalOccurs";
    public static final String ERR_MISPLACED_OCCURS = "RELAXReader.MisplacedOccurs";

    public RELAXReader(GrammarReaderController controller, SAXParserFactory parserFactory, StateFactory stateFactory, ExpressionPool pool, State initialState) {
        super(controller, parserFactory, pool, initialState);
        this.sfactory = stateFactory;
    }

    @Override
    public State createExpressionChildState(State parent2, StartTagInfo tag) {
        if (tag.localName.equals("ref")) {
            return this.sfactory.refLabel(parent2, tag);
        }
        if (tag.localName.equals("hedgeRef")) {
            return this.sfactory.hedgeRef(parent2, tag);
        }
        if (tag.localName.equals("choice")) {
            return this.sfactory.choice(parent2, tag);
        }
        if (tag.localName.equals("none")) {
            return this.sfactory.none(parent2, tag);
        }
        if (tag.localName.equals("empty")) {
            return this.sfactory.empty(parent2, tag);
        }
        if (tag.localName.equals("sequence")) {
            return this.sfactory.sequence(parent2, tag);
        }
        return null;
    }

    public FacetState createFacetState(State parent2, StartTagInfo tag) {
        if (!RELAXCoreNamespace.equals(tag.namespaceURI)) {
            return null;
        }
        if (FacetState.facetNames.contains(tag.localName)) {
            return this.sfactory.facets(parent2, tag);
        }
        return null;
    }

    protected boolean canHaveOccurs(State state2) {
        return state2 instanceof SequenceState || state2 instanceof ElementRefState || state2 instanceof HedgeRefState || state2 instanceof ChoiceState || state2 instanceof InlineElementState;
    }

    @Override
    protected Expression interceptExpression(State state2, Expression exp) {
        String occurs = state2.getStartTag().getAttribute("occurs");
        if (this.canHaveOccurs(state2)) {
            if (occurs != null) {
                if (occurs.equals("?")) {
                    exp = this.pool.createOptional(exp);
                } else if (occurs.equals("+")) {
                    exp = this.pool.createOneOrMore(exp);
                } else if (occurs.equals("*")) {
                    exp = this.pool.createZeroOrMore(exp);
                } else {
                    this.reportError(ERR_ILLEGAL_OCCURS, (Object)occurs);
                }
            }
        } else if (occurs != null) {
            this.reportError(ERR_MISPLACED_OCCURS, (Object)state2.getStartTag().localName);
        }
        return exp;
    }

    protected abstract Expression resolveElementRef(String var1, String var2);

    protected abstract Expression resolveHedgeRef(String var1, String var2);

    @Override
    protected String localizeMessage(String propertyName, Object[] args2) {
        String format;
        try {
            format = ResourceBundle.getBundle("com.ctc.wstx.shaded.msv_core.reader.relax.Messages").getString(propertyName);
        }
        catch (Exception e) {
            format = ResourceBundle.getBundle("com.ctc.wstx.shaded.msv_core.reader.Messages").getString(propertyName);
        }
        return MessageFormat.format(format, args2);
    }

    protected ExpressionPool getPool() {
        return this.pool;
    }

    public static class StateFactory {
        protected State refLabel(State parent2, StartTagInfo tag) {
            return new ElementRefState();
        }

        protected State hedgeRef(State parent2, StartTagInfo tag) {
            return new HedgeRefState();
        }

        protected State choice(State parent2, StartTagInfo tag) {
            return new ChoiceState();
        }

        protected State none(State parent2, StartTagInfo tag) {
            return new TerminalState(Expression.nullSet);
        }

        protected State empty(State parent2, StartTagInfo tag) {
            return new TerminalState(Expression.epsilon);
        }

        protected State sequence(State parent2, StartTagInfo tag) {
            return new SequenceState();
        }

        protected FacetState facets(State parent2, StartTagInfo tag) {
            return new FacetState();
        }
    }
}

