/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.io;

import com.ctc.wstx.api.ReaderConfig;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

abstract class BaseReader
extends Reader {
    protected static final char NULL_CHAR = '\u0000';
    protected static final char NULL_BYTE = '\u0000';
    protected static final char CONVERT_NEL_TO = '\n';
    protected static final char CONVERT_LSEP_TO = '\n';
    static final char CHAR_DEL = '\u007f';
    protected final ReaderConfig mConfig;
    private InputStream mIn;
    protected byte[] mByteBuffer;
    protected int mBytePtr;
    protected int mByteBufferEnd;
    private final boolean mRecycleBuffer;
    protected char[] mTmpBuf = null;

    protected BaseReader(ReaderConfig cfg, InputStream in, byte[] buf, int ptr, int len, boolean recycleBuffer) {
        this.mConfig = cfg;
        this.mIn = in;
        this.mByteBuffer = buf;
        this.mBytePtr = ptr;
        this.mByteBufferEnd = len;
        this.mRecycleBuffer = recycleBuffer;
    }

    public abstract void setXmlCompliancy(int var1);

    protected final boolean canModifyBuffer() {
        return this.mRecycleBuffer;
    }

    @Override
    public void close() throws IOException {
        InputStream in = this.mIn;
        if (in != null) {
            this.mIn = null;
            this.freeBuffers();
            in.close();
        }
    }

    @Override
    public int read() throws IOException {
        if (this.mTmpBuf == null) {
            this.mTmpBuf = new char[1];
        }
        if (this.read(this.mTmpBuf, 0, 1) < 1) {
            return -1;
        }
        return this.mTmpBuf[0];
    }

    protected final InputStream getStream() {
        return this.mIn;
    }

    protected final int readBytes() throws IOException {
        this.mBytePtr = 0;
        this.mByteBufferEnd = 0;
        if (this.mIn != null) {
            int count2 = this.mIn.read(this.mByteBuffer, 0, this.mByteBuffer.length);
            if (count2 > 0) {
                this.mByteBufferEnd = count2;
            }
            return count2;
        }
        return -1;
    }

    protected final int readBytesAt(int offset2) throws IOException {
        if (this.mIn != null) {
            int count2 = this.mIn.read(this.mByteBuffer, offset2, this.mByteBuffer.length - offset2);
            if (count2 > 0) {
                this.mByteBufferEnd += count2;
            }
            return count2;
        }
        return -1;
    }

    public final void freeBuffers() {
        byte[] buf;
        if (this.mRecycleBuffer && (buf = this.mByteBuffer) != null) {
            this.mByteBuffer = null;
            if (this.mConfig != null) {
                this.mConfig.freeFullBBuffer(buf);
            }
        }
    }

    protected void reportBounds(char[] cbuf, int start2, int len) throws IOException {
        throw new ArrayIndexOutOfBoundsException("read(buf," + start2 + "," + len + "), cbuf[" + cbuf.length + "]");
    }

    protected void reportStrangeStream() throws IOException {
        throw new IOException("Strange I/O stream, returned 0 bytes on read");
    }

    protected void reportInvalidXml11(int value, int bytePos, int charPos) throws IOException {
        throw new CharConversionException("Invalid character 0x" + Integer.toHexString(value) + ", can only be included in xml 1.1 using character entities (at char #" + charPos + ", byte #" + bytePos + ")");
    }
}

