/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text;

import androidx.compose.runtime.Immutable;
import androidx.compose.runtime.Stable;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.text.AnnotatedStringKt;
import androidx.compose.ui.text.ExperimentalTextApi;
import androidx.compose.ui.text.ParagraphStyle;
import androidx.compose.ui.text.SpanStyle;
import androidx.compose.ui.text.TextRange;
import androidx.compose.ui.text.TtsAnnotation;
import androidx.compose.ui.text.UrlAnnotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u00002\u00020\u0001:\u000256B;\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005\u0012\u0014\b\u0002\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u00060\u0005\u00a2\u0006\u0002\u0010\nBY\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0016\b\u0002\u0010\u000b\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006\u0018\u00010\u0005\u0012\u0016\b\u0002\u0010\f\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u0006\u0018\u00010\u0005\u0012\u0018\b\u0002\u0010\r\u001a\u0012\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\u0006\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u000fJ\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u000eH\u0096\u0002J\u0011\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0013H\u0096\u0002J\"\u0010\"\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00060\u00052\u0006\u0010#\u001a\u00020\u00132\u0006\u0010$\u001a\u00020\u0013J*\u0010\"\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00060\u00052\u0006\u0010%\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u00132\u0006\u0010$\u001a\u00020\u0013J\"\u0010&\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020'0\u00060\u00052\u0006\u0010#\u001a\u00020\u00132\u0006\u0010$\u001a\u00020\u0013J$\u0010(\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020)0\u00060\u00052\u0006\u0010#\u001a\u00020\u00132\u0006\u0010$\u001a\u00020\u0013H\u0007J\u001e\u0010*\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u00132\u0006\u0010$\u001a\u00020\u0013J\b\u0010+\u001a\u00020\u0013H\u0016J\u0011\u0010,\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u0000H\u0087\u0002J\u0018\u0010-\u001a\u00020\u00002\u0006\u0010.\u001a\u00020/\u00f8\u0001\u0000\u00a2\u0006\u0004\b0\u00101J\u0018\u0010-\u001a\u00020\u00002\u0006\u00102\u001a\u00020\u00132\u0006\u00103\u001a\u00020\u0013H\u0016J\b\u00104\u001a\u00020\u0003H\u0016R$\u0010\r\u001a\u0012\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\u0006\u0018\u00010\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u001d\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u00060\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0011R\"\u0010\f\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u0006\u0018\u00010\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0011R\u001d\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0011R\"\u0010\u000b\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006\u0018\u00010\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u00067"}, d2={"Landroidx/compose/ui/text/AnnotatedString;", "", "text", "", "spanStyles", "", "Landroidx/compose/ui/text/AnnotatedString$Range;", "Landroidx/compose/ui/text/SpanStyle;", "paragraphStyles", "Landroidx/compose/ui/text/ParagraphStyle;", "(Ljava/lang/String;Ljava/util/List;Ljava/util/List;)V", "spanStylesOrNull", "paragraphStylesOrNull", "annotations", "", "(Ljava/lang/String;Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "getAnnotations$ui_text", "()Ljava/util/List;", "length", "", "getLength", "()I", "getParagraphStyles", "getParagraphStylesOrNull$ui_text", "getSpanStyles", "getSpanStylesOrNull$ui_text", "getText", "()Ljava/lang/String;", "equals", "", "other", "get", "", "index", "getStringAnnotations", "start", "end", "tag", "getTtsAnnotations", "Landroidx/compose/ui/text/TtsAnnotation;", "getUrlAnnotations", "Landroidx/compose/ui/text/UrlAnnotation;", "hasStringAnnotations", "hashCode", "plus", "subSequence", "range", "Landroidx/compose/ui/text/TextRange;", "subSequence-5zc-tL8", "(J)Landroidx/compose/ui/text/AnnotatedString;", "startIndex", "endIndex", "toString", "Builder", "Range", "ui-text"})
@Immutable
@SourceDebugExtension(value={"SMAP\nAnnotatedString.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnnotatedString.kt\nandroidx/compose/ui/text/AnnotatedString\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1129:1\n1045#2:1130\n33#3,6:1131\n235#3,3:1138\n33#3,4:1141\n238#3,2:1145\n38#3:1147\n240#3:1148\n101#3,2:1149\n33#3,6:1151\n103#3:1157\n235#3,3:1158\n33#3,4:1161\n238#3,2:1165\n38#3:1167\n240#3:1168\n235#3,3:1169\n33#3,4:1172\n238#3,2:1176\n38#3:1178\n240#3:1179\n235#3,3:1180\n33#3,4:1183\n238#3,2:1187\n38#3:1189\n240#3:1190\n1#4:1137\n*S KotlinDebug\n*F\n+ 1 AnnotatedString.kt\nandroidx/compose/ui/text/AnnotatedString\n*L\n88#1:1130\n88#1:1131,6\n161#1:1138,3\n161#1:1141,4\n161#1:1145,2\n161#1:1147\n161#1:1148\n169#1:1149,2\n169#1:1151,6\n169#1:1157\n184#1:1158,3\n184#1:1161,4\n184#1:1165,2\n184#1:1167\n184#1:1168\n199#1:1169,3\n199#1:1172,4\n199#1:1176,2\n199#1:1178\n199#1:1179\n215#1:1180,3\n215#1:1183,4\n215#1:1187,2\n215#1:1189\n215#1:1190\n*E\n"})
public final class AnnotatedString
implements CharSequence {
    @NotNull
    private final String text;
    @Nullable
    private final List<Range<SpanStyle>> spanStylesOrNull;
    @Nullable
    private final List<Range<ParagraphStyle>> paragraphStylesOrNull;
    @Nullable
    private final List<Range<? extends Object>> annotations;
    public static final int $stable;

    public AnnotatedString(@NotNull String text2, @Nullable List<Range<SpanStyle>> spanStylesOrNull, @Nullable List<Range<ParagraphStyle>> paragraphStylesOrNull, @Nullable List<? extends Range<? extends Object>> annotations2) {
        block4: {
            Intrinsics.checkNotNullParameter(text2, "text");
            this.text = text2;
            this.spanStylesOrNull = spanStylesOrNull;
            this.paragraphStylesOrNull = paragraphStylesOrNull;
            this.annotations = annotations2;
            int lastStyleEnd = 0;
            lastStyleEnd = -1;
            List<Range<ParagraphStyle>> list2 = this.paragraphStylesOrNull;
            if (list2 == null) break block4;
            Iterable $this$sortedBy$iv = list2;
            boolean $i$f$sortedBy = false;
            list2 = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

                public final int compare(T a, T b) {
                    Range it = (Range)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getStart());
                    it = (Range)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues(comparable2, it.getStart());
                }
            });
            if (list2 != null) {
                List<Range<ParagraphStyle>> $this$fastForEach$iv = list2;
                boolean $i$f$fastForEach = false;
                int n = $this$fastForEach$iv.size();
                for (int index$iv = 0; index$iv < n; ++index$iv) {
                    Range<ParagraphStyle> item$iv;
                    Range<ParagraphStyle> paragraphStyle = item$iv = $this$fastForEach$iv.get(index$iv);
                    boolean bl = false;
                    if (!(paragraphStyle.getStart() >= lastStyleEnd)) {
                        boolean $i$a$-require-AnnotatedString$4$32 = false;
                        String $i$a$-require-AnnotatedString$4$32 = "ParagraphStyle should not overlap";
                        throw new IllegalArgumentException($i$a$-require-AnnotatedString$4$32.toString());
                    }
                    if (!(paragraphStyle.getEnd() <= this.text.length())) {
                        boolean bl2 = false;
                        String string = "ParagraphStyle range [" + paragraphStyle.getStart() + ", " + paragraphStyle.getEnd() + ") is out of boundary";
                        throw new IllegalArgumentException(string.toString());
                    }
                    lastStyleEnd = paragraphStyle.getEnd();
                }
            }
        }
    }

    public /* synthetic */ AnnotatedString(String string, List list2, List list3, List list4, int n, DefaultConstructorMarker defaultConstructorMarker2) {
        if ((n & 2) != 0) {
            list2 = null;
        }
        if ((n & 4) != 0) {
            list3 = null;
        }
        if ((n & 8) != 0) {
            list4 = null;
        }
        this(string, list2, list3, list4);
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    @Nullable
    public final List<Range<SpanStyle>> getSpanStylesOrNull$ui_text() {
        return this.spanStylesOrNull;
    }

    @Nullable
    public final List<Range<ParagraphStyle>> getParagraphStylesOrNull$ui_text() {
        return this.paragraphStylesOrNull;
    }

    @Nullable
    public final List<Range<? extends Object>> getAnnotations$ui_text() {
        return this.annotations;
    }

    @NotNull
    public final List<Range<SpanStyle>> getSpanStyles() {
        List<Range<SpanStyle>> list2 = this.spanStylesOrNull;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    @NotNull
    public final List<Range<ParagraphStyle>> getParagraphStyles() {
        List<Range<ParagraphStyle>> list2 = this.paragraphStylesOrNull;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    public AnnotatedString(@NotNull String text2, @NotNull List<Range<SpanStyle>> spanStyles, @NotNull List<Range<ParagraphStyle>> paragraphStyles) {
        Collection collection;
        Collection collection2;
        List list2;
        AnnotatedString annotatedString;
        String string;
        Intrinsics.checkNotNullParameter(text2, "text");
        Intrinsics.checkNotNullParameter(spanStyles, "spanStyles");
        Intrinsics.checkNotNullParameter(paragraphStyles, "paragraphStyles");
        AnnotatedString annotatedString2 = this;
        String string2 = text2;
        Collection collection3 = spanStyles;
        if (collection3.isEmpty()) {
            string = string2;
            annotatedString = annotatedString2;
            boolean bl = false;
            list2 = null;
            annotatedString2 = annotatedString;
            string2 = string;
            collection2 = list2;
        } else {
            collection2 = collection3;
        }
        List list3 = (List)collection2;
        collection3 = paragraphStyles;
        if (collection3.isEmpty()) {
            list2 = list3;
            string = string2;
            annotatedString = annotatedString2;
            boolean bl = false;
            Object var9_9 = null;
            annotatedString2 = annotatedString;
            string2 = string;
            list3 = list2;
            collection = var9_9;
        } else {
            collection = collection3;
        }
        annotatedString2(string2, list3, (List)collection, null);
    }

    public /* synthetic */ AnnotatedString(String string, List list2, List list3, int n, DefaultConstructorMarker defaultConstructorMarker2) {
        if ((n & 2) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n & 4) != 0) {
            list3 = CollectionsKt.emptyList();
        }
        this(string, list2, list3);
    }

    public int getLength() {
        return this.text.length();
    }

    public char get(int index2) {
        return this.text.charAt(index2);
    }

    @Override
    @NotNull
    public AnnotatedString subSequence(int startIndex, int endIndex) {
        if (!(startIndex <= endIndex)) {
            boolean bl = false;
            String string = "start (" + startIndex + ") should be less or equal to end (" + endIndex + ')';
            throw new IllegalArgumentException(string.toString());
        }
        if (startIndex == 0 && endIndex == this.text.length()) {
            return this;
        }
        String string = this.text.substring(startIndex, endIndex);
        Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
        String text2 = string;
        return new AnnotatedString(text2, AnnotatedStringKt.access$filterRanges(this.spanStylesOrNull, startIndex, endIndex), AnnotatedStringKt.access$filterRanges(this.paragraphStylesOrNull, startIndex, endIndex), AnnotatedStringKt.access$filterRanges(this.annotations, startIndex, endIndex));
    }

    @NotNull
    public final AnnotatedString subSequence-5zc-tL8(long range) {
        return this.subSequence(TextRange.getMin-impl(range), TextRange.getMax-impl(range));
    }

    @Stable
    @NotNull
    public final AnnotatedString plus(@NotNull AnnotatedString other) {
        Intrinsics.checkNotNullParameter(other, "other");
        Builder $this$plus_u24lambda_u247 = new Builder(this);
        boolean bl = false;
        $this$plus_u24lambda_u247.append(other);
        return $this$plus_u24lambda_u247.toAnnotatedString();
    }

    @NotNull
    public final List<Range<String>> getStringAnnotations(@NotNull String tag, int start2, int end2) {
        List list2;
        Intrinsics.checkNotNullParameter(tag, "tag");
        List<Range<? extends Object>> list3 = this.annotations;
        if (list3 != null) {
            List<Range<? extends Object>> $this$fastFilter$iv = list3;
            boolean $i$f$fastFilter = false;
            ArrayList target$iv = new ArrayList($this$fastFilter$iv.size());
            List<Range<? extends Object>> $this$fastForEach$iv$iv = $this$fastFilter$iv;
            boolean $i$f$fastForEach = false;
            int n = $this$fastForEach$iv$iv.size();
            for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                Range<? extends Object> item$iv$iv;
                Range<? extends Object> it$iv = item$iv$iv = $this$fastForEach$iv$iv.get(index$iv$iv);
                boolean bl = false;
                Range<? extends Object> it = it$iv;
                boolean bl2 = false;
                if (!(it.getItem() instanceof String && Intrinsics.areEqual(tag, it.getTag()) && AnnotatedStringKt.intersect(start2, end2, it.getStart(), it.getEnd()))) continue;
                ((Collection)target$iv).add(it$iv);
            }
            list2 = target$iv;
        } else {
            list2 = CollectionsKt.emptyList();
        }
        Intrinsics.checkNotNull(list2, "null cannot be cast to non-null type kotlin.collections.List<androidx.compose.ui.text.AnnotatedString.Range<kotlin.String>>");
        return list2;
    }

    public final boolean hasStringAnnotations(@NotNull String tag, int start2, int end2) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(tag, "tag");
            List<Range<? extends Object>> list2 = this.annotations;
            if (list2 != null) {
                List<Range<? extends Object>> $this$fastAny$iv = list2;
                boolean $i$f$fastAny = false;
                List<Range<? extends Object>> $this$fastForEach$iv$iv = $this$fastAny$iv;
                boolean $i$f$fastForEach = false;
                int n = $this$fastForEach$iv$iv.size();
                for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                    Range<? extends Object> item$iv$iv;
                    Range<? extends Object> it$iv = item$iv$iv = $this$fastForEach$iv$iv.get(index$iv$iv);
                    boolean bl2 = false;
                    Range<? extends Object> it = it$iv;
                    boolean bl3 = false;
                    if (!(it.getItem() instanceof String && Intrinsics.areEqual(tag, it.getTag()) && AnnotatedStringKt.intersect(start2, end2, it.getStart(), it.getEnd()))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            } else {
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public final List<Range<String>> getStringAnnotations(int start2, int end2) {
        List list2;
        List<Range<? extends Object>> list3 = this.annotations;
        if (list3 != null) {
            List<Range<? extends Object>> $this$fastFilter$iv = list3;
            boolean $i$f$fastFilter = false;
            ArrayList target$iv = new ArrayList($this$fastFilter$iv.size());
            List<Range<? extends Object>> $this$fastForEach$iv$iv = $this$fastFilter$iv;
            boolean $i$f$fastForEach = false;
            int n = $this$fastForEach$iv$iv.size();
            for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                Range<? extends Object> item$iv$iv;
                Range<? extends Object> it$iv = item$iv$iv = $this$fastForEach$iv$iv.get(index$iv$iv);
                boolean bl = false;
                Range<? extends Object> it = it$iv;
                boolean bl2 = false;
                if (!(it.getItem() instanceof String && AnnotatedStringKt.intersect(start2, end2, it.getStart(), it.getEnd()))) continue;
                ((Collection)target$iv).add(it$iv);
            }
            list2 = target$iv;
        } else {
            list2 = CollectionsKt.emptyList();
        }
        Intrinsics.checkNotNull(list2, "null cannot be cast to non-null type kotlin.collections.List<androidx.compose.ui.text.AnnotatedString.Range<kotlin.String>>");
        return list2;
    }

    @NotNull
    public final List<Range<TtsAnnotation>> getTtsAnnotations(int start2, int end2) {
        List list2;
        List<Range<? extends Object>> list3 = this.annotations;
        if (list3 != null) {
            List<Range<? extends Object>> $this$fastFilter$iv = list3;
            boolean $i$f$fastFilter = false;
            ArrayList target$iv = new ArrayList($this$fastFilter$iv.size());
            List<Range<? extends Object>> $this$fastForEach$iv$iv = $this$fastFilter$iv;
            boolean $i$f$fastForEach = false;
            int n = $this$fastForEach$iv$iv.size();
            for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                Range<? extends Object> item$iv$iv;
                Range<? extends Object> it$iv = item$iv$iv = $this$fastForEach$iv$iv.get(index$iv$iv);
                boolean bl = false;
                Range<? extends Object> it = it$iv;
                boolean bl2 = false;
                if (!(it.getItem() instanceof TtsAnnotation && AnnotatedStringKt.intersect(start2, end2, it.getStart(), it.getEnd()))) continue;
                ((Collection)target$iv).add(it$iv);
            }
            list2 = target$iv;
        } else {
            list2 = CollectionsKt.emptyList();
        }
        Intrinsics.checkNotNull(list2, "null cannot be cast to non-null type kotlin.collections.List<androidx.compose.ui.text.AnnotatedString.Range<androidx.compose.ui.text.TtsAnnotation>>");
        return list2;
    }

    @ExperimentalTextApi
    @NotNull
    public final List<Range<UrlAnnotation>> getUrlAnnotations(int start2, int end2) {
        List list2;
        List<Range<? extends Object>> list3 = this.annotations;
        if (list3 != null) {
            List<Range<? extends Object>> $this$fastFilter$iv = list3;
            boolean $i$f$fastFilter = false;
            ArrayList target$iv = new ArrayList($this$fastFilter$iv.size());
            List<Range<? extends Object>> $this$fastForEach$iv$iv = $this$fastFilter$iv;
            boolean $i$f$fastForEach = false;
            int n = $this$fastForEach$iv$iv.size();
            for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                Range<? extends Object> item$iv$iv;
                Range<? extends Object> it$iv = item$iv$iv = $this$fastForEach$iv$iv.get(index$iv$iv);
                boolean bl = false;
                Range<? extends Object> it = it$iv;
                boolean bl2 = false;
                if (!(it.getItem() instanceof UrlAnnotation && AnnotatedStringKt.intersect(start2, end2, it.getStart(), it.getEnd()))) continue;
                ((Collection)target$iv).add(it$iv);
            }
            list2 = target$iv;
        } else {
            list2 = CollectionsKt.emptyList();
        }
        Intrinsics.checkNotNull(list2, "null cannot be cast to non-null type kotlin.collections.List<androidx.compose.ui.text.AnnotatedString.Range<androidx.compose.ui.text.UrlAnnotation>>");
        return list2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AnnotatedString)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.text, ((AnnotatedString)other).text)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.spanStylesOrNull, ((AnnotatedString)other).spanStylesOrNull)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.paragraphStylesOrNull, ((AnnotatedString)other).paragraphStylesOrNull)) {
            return false;
        }
        return Intrinsics.areEqual(this.annotations, ((AnnotatedString)other).annotations);
    }

    public int hashCode() {
        int result2 = this.text.hashCode();
        List<Range<SpanStyle>> list2 = this.spanStylesOrNull;
        result2 = 31 * result2 + (list2 != null ? ((Object)list2).hashCode() : 0);
        List<Range<ParagraphStyle>> list3 = this.paragraphStylesOrNull;
        result2 = 31 * result2 + (list3 != null ? ((Object)list3).hashCode() : 0);
        List<Range<? extends Object>> list4 = this.annotations;
        result2 = 31 * result2 + (list4 != null ? ((Object)list4).hashCode() : 0);
        return result2;
    }

    @Override
    @NotNull
    public String toString() {
        return this.text;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\u0010\r\n\u0002\b\n\b\u0007\u0018\u00002\u00060\u0001j\u0002`\u0002:\u00013B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u000f\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ&\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\tJ\u001e\u0010\u001f\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\tJ\u001e\u0010\u001f\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\tJ \u0010!\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\tH\u0007J \u0010$\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020&2\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\tH\u0007J\u000e\u0010'\u001a\u00020\u001a2\u0006\u0010\u0003\u001a\u00020\u0006J\u001e\u0010'\u001a\u00020\u001a2\u0006\u0010\u0003\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\tJ\u0010\u0010'\u001a\u00020\u00002\u0006\u0010(\u001a\u00020)H\u0016J\u0012\u0010'\u001a\u00020\u00002\b\u0010\u0003\u001a\u0004\u0018\u00010*H\u0016J\"\u0010'\u001a\u00020\u00002\b\u0010\u0003\u001a\u0004\u0018\u00010*2\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\tH\u0016J\u000e\u0010'\u001a\u00020\u001a2\u0006\u0010\u0003\u001a\u00020\u0004J\u0015\u0010+\u001a\u00020\u001a2\u0006\u0010(\u001a\u00020)H\u0007\u00a2\u0006\u0002\b'J\u0006\u0010,\u001a\u00020\u001aJ\u000e\u0010,\u001a\u00020\u001a2\u0006\u0010-\u001a\u00020\tJ\u0016\u0010.\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u0004J\u000e\u0010/\u001a\u00020\t2\u0006\u0010 \u001a\u00020\u0013J\u000e\u0010/\u001a\u00020\t2\u0006\u0010 \u001a\u00020\u0015J\u000e\u00100\u001a\u00020\t2\u0006\u0010\"\u001a\u00020#J\u0010\u00101\u001a\u00020\t2\u0006\u0010%\u001a\u00020&H\u0007J\u0006\u00102\u001a\u00020\u0006R\u001c\u0010\u000b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0016\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0003\u001a\u00060\u0017j\u0002`\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Landroidx/compose/ui/text/AnnotatedString$Builder;", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "text", "", "(Ljava/lang/String;)V", "Landroidx/compose/ui/text/AnnotatedString;", "(Landroidx/compose/ui/text/AnnotatedString;)V", "capacity", "", "(I)V", "annotations", "", "Landroidx/compose/ui/text/AnnotatedString$Builder$MutableRange;", "", "length", "getLength", "()I", "paragraphStyles", "Landroidx/compose/ui/text/ParagraphStyle;", "spanStyles", "Landroidx/compose/ui/text/SpanStyle;", "styleStack", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "addStringAnnotation", "", "tag", "annotation", "start", "end", "addStyle", "style", "addTtsAnnotation", "ttsAnnotation", "Landroidx/compose/ui/text/TtsAnnotation;", "addUrlAnnotation", "urlAnnotation", "Landroidx/compose/ui/text/UrlAnnotation;", "append", "char", "", "", "deprecated_append_returning_void", "pop", "index", "pushStringAnnotation", "pushStyle", "pushTtsAnnotation", "pushUrlAnnotation", "toAnnotatedString", "MutableRange", "ui-text"})
    @StabilityInferred(parameters=0)
    @SourceDebugExtension(value={"SMAP\nAnnotatedString.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnnotatedString.kt\nandroidx/compose/ui/text/AnnotatedString$Builder\n+ 2 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1129:1\n33#2,6:1130\n33#2,6:1136\n33#2,6:1142\n33#2,6:1148\n33#2,6:1154\n33#2,6:1160\n151#2,3:1167\n33#2,4:1170\n154#2,2:1174\n38#2:1176\n156#2:1177\n151#2,3:1178\n33#2,4:1181\n154#2,2:1185\n38#2:1187\n156#2:1188\n151#2,3:1189\n33#2,4:1192\n154#2,2:1196\n38#2:1198\n156#2:1199\n1#3:1166\n*S KotlinDebug\n*F\n+ 1 AnnotatedString.kt\nandroidx/compose/ui/text/AnnotatedString$Builder\n*L\n398#1:1130,6\n401#1:1136,6\n405#1:1142,6\n425#1:1148,6\n428#1:1154,6\n432#1:1160,6\n642#1:1167,3\n642#1:1170,4\n642#1:1174,2\n642#1:1176\n642#1:1177\n645#1:1178,3\n645#1:1181,4\n645#1:1185,2\n645#1:1187\n645#1:1188\n648#1:1189,3\n648#1:1192,4\n648#1:1196,2\n648#1:1198\n648#1:1199\n*E\n"})
    public static final class Builder
    implements Appendable {
        @NotNull
        private final StringBuilder text;
        @NotNull
        private final List<MutableRange<SpanStyle>> spanStyles;
        @NotNull
        private final List<MutableRange<ParagraphStyle>> paragraphStyles;
        @NotNull
        private final List<MutableRange<? extends Object>> annotations;
        @NotNull
        private final List<MutableRange<? extends Object>> styleStack;
        public static final int $stable = 8;

        public Builder(int capacity) {
            this.text = new StringBuilder(capacity);
            this.spanStyles = new ArrayList();
            this.paragraphStyles = new ArrayList();
            this.annotations = new ArrayList();
            this.styleStack = new ArrayList();
        }

        public /* synthetic */ Builder(int n, int n2, DefaultConstructorMarker defaultConstructorMarker2) {
            if ((n2 & 1) != 0) {
                n = 16;
            }
            this(n);
        }

        public Builder(@NotNull String text2) {
            Intrinsics.checkNotNullParameter(text2, "text");
            this(0, 1, null);
            this.append(text2);
        }

        public Builder(@NotNull AnnotatedString text2) {
            Intrinsics.checkNotNullParameter(text2, "text");
            this(0, 1, null);
            this.append(text2);
        }

        public final int getLength() {
            return this.text.length();
        }

        public final void append(@NotNull String text2) {
            Intrinsics.checkNotNullParameter(text2, "text");
            this.text.append(text2);
        }

        @Deprecated(message="Replaced by the append(Char) method that returns an Appendable. This method must be kept around for binary compatibility.", level=DeprecationLevel.HIDDEN)
        @JvmName(name="append")
        public final /* synthetic */ void append(char c) {
            this.append(c);
        }

        @Override
        @NotNull
        public Builder append(@Nullable CharSequence text2) {
            if (text2 instanceof AnnotatedString) {
                this.append((AnnotatedString)text2);
            } else {
                this.text.append(text2);
            }
            return this;
        }

        @Override
        @NotNull
        public Builder append(@Nullable CharSequence text2, int start2, int end2) {
            if (text2 instanceof AnnotatedString) {
                this.append((AnnotatedString)text2, start2, end2);
            } else {
                this.text.append(text2, start2, end2);
            }
            return this;
        }

        @Override
        @NotNull
        public Builder append(char c) {
            this.text.append(c);
            return this;
        }

        public final void append(@NotNull AnnotatedString text2) {
            block5: {
                Range<Object> it;
                Range<Object> item$iv;
                int index$iv;
                int n;
                boolean $i$f$fastForEach;
                List<Range<Object>> $this$fastForEach$iv;
                Intrinsics.checkNotNullParameter(text2, "text");
                int start2 = this.text.length();
                this.text.append(text2.getText());
                List<Range<SpanStyle>> list2 = text2.getSpanStylesOrNull$ui_text();
                if (list2 != null) {
                    $this$fastForEach$iv = list2;
                    $i$f$fastForEach = false;
                    n = $this$fastForEach$iv.size();
                    for (index$iv = 0; index$iv < n; ++index$iv) {
                        it = item$iv = $this$fastForEach$iv.get(index$iv);
                        boolean bl = false;
                        this.addStyle((SpanStyle)it.getItem(), start2 + it.getStart(), start2 + it.getEnd());
                    }
                }
                List<Range<ParagraphStyle>> list3 = text2.getParagraphStylesOrNull$ui_text();
                if (list3 != null) {
                    $this$fastForEach$iv = list3;
                    $i$f$fastForEach = false;
                    n = $this$fastForEach$iv.size();
                    for (index$iv = 0; index$iv < n; ++index$iv) {
                        it = item$iv = $this$fastForEach$iv.get(index$iv);
                        boolean bl = false;
                        this.addStyle((ParagraphStyle)it.getItem(), start2 + it.getStart(), start2 + it.getEnd());
                    }
                }
                List<Range<? extends Object>> list4 = text2.getAnnotations$ui_text();
                if (list4 == null) break block5;
                $this$fastForEach$iv = list4;
                $i$f$fastForEach = false;
                n = $this$fastForEach$iv.size();
                for (index$iv = 0; index$iv < n; ++index$iv) {
                    it = item$iv = $this$fastForEach$iv.get(index$iv);
                    boolean bl = false;
                    this.annotations.add(new MutableRange<Object>(it.getItem(), start2 + it.getStart(), start2 + it.getEnd(), it.getTag()));
                }
            }
        }

        public final void append(@NotNull AnnotatedString text2, int start2, int end2) {
            block5: {
                Range it;
                Object item$iv;
                int index$iv;
                int n;
                boolean $i$f$fastForEach;
                List $this$fastForEach$iv;
                Intrinsics.checkNotNullParameter(text2, "text");
                int insertionStart = this.text.length();
                this.text.append(text2.getText(), start2, end2);
                List list2 = AnnotatedStringKt.access$getLocalSpanStyles(text2, start2, end2);
                if (list2 != null) {
                    $this$fastForEach$iv = list2;
                    $i$f$fastForEach = false;
                    n = $this$fastForEach$iv.size();
                    for (index$iv = 0; index$iv < n; ++index$iv) {
                        item$iv = $this$fastForEach$iv.get(index$iv);
                        it = (Range)item$iv;
                        boolean bl = false;
                        this.addStyle((SpanStyle)it.getItem(), insertionStart + it.getStart(), insertionStart + it.getEnd());
                    }
                }
                List list3 = AnnotatedStringKt.access$getLocalParagraphStyles(text2, start2, end2);
                if (list3 != null) {
                    $this$fastForEach$iv = list3;
                    $i$f$fastForEach = false;
                    n = $this$fastForEach$iv.size();
                    for (index$iv = 0; index$iv < n; ++index$iv) {
                        item$iv = $this$fastForEach$iv.get(index$iv);
                        it = (Range)item$iv;
                        boolean bl = false;
                        this.addStyle((ParagraphStyle)it.getItem(), insertionStart + it.getStart(), insertionStart + it.getEnd());
                    }
                }
                List list4 = AnnotatedStringKt.access$getLocalAnnotations(text2, start2, end2);
                if (list4 == null) break block5;
                $this$fastForEach$iv = list4;
                $i$f$fastForEach = false;
                n = $this$fastForEach$iv.size();
                for (index$iv = 0; index$iv < n; ++index$iv) {
                    item$iv = $this$fastForEach$iv.get(index$iv);
                    it = (Range)item$iv;
                    boolean bl = false;
                    this.annotations.add(new MutableRange(it.getItem(), insertionStart + it.getStart(), insertionStart + it.getEnd(), it.getTag()));
                }
            }
        }

        public final void addStyle(@NotNull SpanStyle style, int start2, int end2) {
            Intrinsics.checkNotNullParameter(style, "style");
            this.spanStyles.add(new MutableRange(style, start2, end2, null, 8, null));
        }

        public final void addStyle(@NotNull ParagraphStyle style, int start2, int end2) {
            Intrinsics.checkNotNullParameter(style, "style");
            this.paragraphStyles.add(new MutableRange(style, start2, end2, null, 8, null));
        }

        public final void addStringAnnotation(@NotNull String tag, @NotNull String annotation, int start2, int end2) {
            Intrinsics.checkNotNullParameter(tag, "tag");
            Intrinsics.checkNotNullParameter(annotation, "annotation");
            this.annotations.add(new MutableRange<String>(annotation, start2, end2, tag));
        }

        @ExperimentalTextApi
        public final void addTtsAnnotation(@NotNull TtsAnnotation ttsAnnotation, int start2, int end2) {
            Intrinsics.checkNotNullParameter(ttsAnnotation, "ttsAnnotation");
            this.annotations.add(new MutableRange(ttsAnnotation, start2, end2, null, 8, null));
        }

        @ExperimentalTextApi
        public final void addUrlAnnotation(@NotNull UrlAnnotation urlAnnotation, int start2, int end2) {
            Intrinsics.checkNotNullParameter(urlAnnotation, "urlAnnotation");
            this.annotations.add(new MutableRange(urlAnnotation, start2, end2, null, 8, null));
        }

        public final int pushStyle(@NotNull SpanStyle style) {
            MutableRange mutableRange;
            Intrinsics.checkNotNullParameter(style, "style");
            MutableRange it = mutableRange = new MutableRange(style, this.text.length(), 0, null, 12, null);
            boolean bl = false;
            this.styleStack.add(it);
            this.spanStyles.add(it);
            return this.styleStack.size() - 1;
        }

        public final int pushStyle(@NotNull ParagraphStyle style) {
            MutableRange mutableRange;
            Intrinsics.checkNotNullParameter(style, "style");
            MutableRange it = mutableRange = new MutableRange(style, this.text.length(), 0, null, 12, null);
            boolean bl = false;
            this.styleStack.add(it);
            this.paragraphStyles.add(it);
            return this.styleStack.size() - 1;
        }

        public final int pushStringAnnotation(@NotNull String tag, @NotNull String annotation) {
            MutableRange mutableRange;
            Intrinsics.checkNotNullParameter(tag, "tag");
            Intrinsics.checkNotNullParameter(annotation, "annotation");
            MutableRange it = mutableRange = new MutableRange(annotation, this.text.length(), 0, tag, 4, null);
            boolean bl = false;
            this.styleStack.add(it);
            this.annotations.add(it);
            return this.styleStack.size() - 1;
        }

        public final int pushTtsAnnotation(@NotNull TtsAnnotation ttsAnnotation) {
            MutableRange mutableRange;
            Intrinsics.checkNotNullParameter(ttsAnnotation, "ttsAnnotation");
            MutableRange it = mutableRange = new MutableRange(ttsAnnotation, this.text.length(), 0, null, 12, null);
            boolean bl = false;
            this.styleStack.add(it);
            this.annotations.add(it);
            return this.styleStack.size() - 1;
        }

        @ExperimentalTextApi
        public final int pushUrlAnnotation(@NotNull UrlAnnotation urlAnnotation) {
            MutableRange mutableRange;
            Intrinsics.checkNotNullParameter(urlAnnotation, "urlAnnotation");
            MutableRange it = mutableRange = new MutableRange(urlAnnotation, this.text.length(), 0, null, 12, null);
            boolean bl = false;
            this.styleStack.add(it);
            this.annotations.add(it);
            return this.styleStack.size() - 1;
        }

        public final void pop() {
            if (!(!((Collection)this.styleStack).isEmpty())) {
                boolean bl = false;
                String string = "Nothing to pop.";
                throw new IllegalStateException(string.toString());
            }
            MutableRange<? extends Object> item2 = this.styleStack.remove(this.styleStack.size() - 1);
            item2.setEnd(this.text.length());
        }

        public final void pop(int index2) {
            if (!(index2 < this.styleStack.size())) {
                boolean bl = false;
                String string = index2 + " should be less than " + this.styleStack.size();
                throw new IllegalStateException(string.toString());
            }
            while (this.styleStack.size() - 1 >= index2) {
                this.pop();
            }
        }

        @NotNull
        public final AnnotatedString toAnnotatedString() {
            Collection<MutableRange<SpanStyle>> collection;
            Collection collection2;
            Collection collection3;
            Collection collection4;
            List<MutableRange<ParagraphStyle>> list2;
            MutableRange it;
            Collection collection5;
            boolean bl;
            Object it$iv;
            Object item$iv$iv;
            int index$iv$iv;
            Collection<MutableRange<ParagraphStyle>> $this$fastMap$iv;
            String string = this.text.toString();
            Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
            Collection<MutableRange<SpanStyle>> collection6 = this.spanStyles;
            String string2 = string;
            boolean $i$f$fastMap = false;
            ArrayList target$iv = new ArrayList($this$fastMap$iv.size());
            Collection<MutableRange<ParagraphStyle>> $this$fastForEach$iv$iv = $this$fastMap$iv;
            boolean $i$f$fastForEach = false;
            int n = $this$fastForEach$iv$iv.size();
            for (index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                it$iv = item$iv$iv = $this$fastForEach$iv$iv.get(index$iv$iv);
                bl = false;
                MutableRange mutableRange = (MutableRange)it$iv;
                collection5 = target$iv;
                boolean bl2 = false;
                collection5.add(it.toRange(this.text.length()));
            }
            String string3 = string2;
            $this$fastMap$iv = target$iv;
            if ($this$fastMap$iv.isEmpty()) {
                string2 = string3;
                boolean bl3 = false;
                list2 = null;
                string3 = string2;
            } else {
                list2 = $this$fastMap$iv;
            }
            $this$fastMap$iv = this.paragraphStyles;
            collection5 = list2;
            string2 = string3;
            $i$f$fastMap = false;
            target$iv = new ArrayList($this$fastMap$iv.size());
            $this$fastForEach$iv$iv = $this$fastMap$iv;
            $i$f$fastForEach = false;
            n = $this$fastForEach$iv$iv.size();
            for (index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                it$iv = item$iv$iv = $this$fastForEach$iv$iv.get(index$iv$iv);
                bl = false;
                it = (MutableRange)it$iv;
                collection4 = target$iv;
                boolean bl4 = false;
                collection4.add(it.toRange(this.text.length()));
            }
            collection4 = target$iv;
            String string4 = string2;
            Collection collection7 = collection5;
            $this$fastMap$iv = collection4;
            if ($this$fastMap$iv.isEmpty()) {
                collection5 = collection7;
                string2 = string4;
                boolean bl5 = false;
                collection4 = null;
                string4 = string2;
                collection7 = collection5;
                collection3 = collection4;
            } else {
                collection3 = $this$fastMap$iv;
            }
            $this$fastMap$iv = this.annotations;
            collection4 = (List)collection3;
            collection5 = collection7;
            string2 = string4;
            $i$f$fastMap = false;
            target$iv = new ArrayList($this$fastMap$iv.size());
            $this$fastForEach$iv$iv = $this$fastMap$iv;
            $i$f$fastForEach = false;
            n = $this$fastForEach$iv$iv.size();
            for (index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                it$iv = item$iv$iv = $this$fastForEach$iv$iv.get(index$iv$iv);
                bl = false;
                it = (MutableRange)it$iv;
                collection2 = target$iv;
                boolean bl6 = false;
                collection2.add(it.toRange(this.text.length()));
            }
            collection2 = target$iv;
            String string5 = string2;
            Collection collection8 = collection5;
            Collection collection9 = collection4;
            collection6 = collection2;
            if (collection6.isEmpty()) {
                collection4 = collection9;
                collection5 = collection8;
                string2 = string5;
                boolean bl7 = false;
                collection2 = null;
                string5 = string2;
                collection8 = collection5;
                collection9 = collection4;
                collection = collection2;
            } else {
                collection = collection6;
            }
            List list3 = (List)collection;
            Collection collection10 = collection9;
            Collection collection11 = collection8;
            String string6 = string5;
            return new AnnotatedString(string6, (List<Range<SpanStyle>>)collection11, (List<Range<ParagraphStyle>>)collection10, list3);
        }

        public Builder() {
            this(0, 1, null);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\b\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B)\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u0014\u001a\u00028\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\u000fJ\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\bH\u00c6\u0003J<\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0003\u001a\u00028\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001\u00a2\u0006\u0002\u0010\u0019J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u0005H\u00d6\u0001J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00000\u001f2\b\b\u0002\u0010 \u001a\u00020\u0005J\t\u0010!\u001a\u00020\bH\u00d6\u0001R\u001a\u0010\u0006\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0013\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\""}, d2={"Landroidx/compose/ui/text/AnnotatedString$Builder$MutableRange;", "T", "", "item", "start", "", "end", "tag", "", "(Ljava/lang/Object;IILjava/lang/String;)V", "getEnd", "()I", "setEnd", "(I)V", "getItem", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getStart", "getTag", "()Ljava/lang/String;", "component1", "component2", "component3", "component4", "copy", "(Ljava/lang/Object;IILjava/lang/String;)Landroidx/compose/ui/text/AnnotatedString$Builder$MutableRange;", "equals", "", "other", "hashCode", "toRange", "Landroidx/compose/ui/text/AnnotatedString$Range;", "defaultEnd", "toString", "ui-text"})
        @SourceDebugExtension(value={"SMAP\nAnnotatedString.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnnotatedString.kt\nandroidx/compose/ui/text/AnnotatedString$Builder$MutableRange\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1129:1\n1#2:1130\n*E\n"})
        private static final class MutableRange<T> {
            private final T item;
            private final int start;
            private int end;
            @NotNull
            private final String tag;

            public MutableRange(T item2, int start2, int end2, @NotNull String tag) {
                Intrinsics.checkNotNullParameter(tag, "tag");
                this.item = item2;
                this.start = start2;
                this.end = end2;
                this.tag = tag;
            }

            public /* synthetic */ MutableRange(Object object, int n, int n2, String string, int n3, DefaultConstructorMarker defaultConstructorMarker2) {
                if ((n3 & 4) != 0) {
                    n2 = Integer.MIN_VALUE;
                }
                if ((n3 & 8) != 0) {
                    string = "";
                }
                this(object, n, n2, string);
            }

            public final T getItem() {
                return this.item;
            }

            public final int getStart() {
                return this.start;
            }

            public final int getEnd() {
                return this.end;
            }

            public final void setEnd(int n) {
                this.end = n;
            }

            @NotNull
            public final String getTag() {
                return this.tag;
            }

            @NotNull
            public final Range<T> toRange(int defaultEnd) {
                int end2 = this.end == Integer.MIN_VALUE ? defaultEnd : this.end;
                if (!(end2 != Integer.MIN_VALUE)) {
                    boolean bl = false;
                    String string = "Item.end should be set first";
                    throw new IllegalStateException(string.toString());
                }
                return new Range<T>(this.item, this.start, end2, this.tag);
            }

            public static /* synthetic */ Range toRange$default(MutableRange mutableRange, int n, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    n = Integer.MIN_VALUE;
                }
                return mutableRange.toRange(n);
            }

            public final T component1() {
                return this.item;
            }

            public final int component2() {
                return this.start;
            }

            public final int component3() {
                return this.end;
            }

            @NotNull
            public final String component4() {
                return this.tag;
            }

            @NotNull
            public final MutableRange<T> copy(T item2, int start2, int end2, @NotNull String tag) {
                Intrinsics.checkNotNullParameter(tag, "tag");
                return new MutableRange<T>(item2, start2, end2, tag);
            }

            public static /* synthetic */ MutableRange copy$default(MutableRange mutableRange, Object object, int n, int n2, String string, int n3, Object object2) {
                if ((n3 & 1) != 0) {
                    object = mutableRange.item;
                }
                if ((n3 & 2) != 0) {
                    n = mutableRange.start;
                }
                if ((n3 & 4) != 0) {
                    n2 = mutableRange.end;
                }
                if ((n3 & 8) != 0) {
                    string = mutableRange.tag;
                }
                return mutableRange.copy(object, n, n2, string);
            }

            @NotNull
            public String toString() {
                return "MutableRange(item=" + this.item + ", start=" + this.start + ", end=" + this.end + ", tag=" + this.tag + ')';
            }

            public int hashCode() {
                int result2 = this.item == null ? 0 : this.item.hashCode();
                result2 = result2 * 31 + Integer.hashCode(this.start);
                result2 = result2 * 31 + Integer.hashCode(this.end);
                result2 = result2 * 31 + this.tag.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof MutableRange)) {
                    return false;
                }
                MutableRange mutableRange = (MutableRange)other;
                if (!Intrinsics.areEqual(this.item, mutableRange.item)) {
                    return false;
                }
                if (this.start != mutableRange.start) {
                    return false;
                }
                if (this.end != mutableRange.end) {
                    return false;
                }
                return Intrinsics.areEqual(this.tag, mutableRange.tag);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0087\b\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u001f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007B%\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u0013\u001a\u00028\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\u000eJ\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\tH\u00c6\u0003J<\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0003\u001a\u00028\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001\u00a2\u0006\u0002\u0010\u0018J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u001d\u001a\u00020\tH\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001e"}, d2={"Landroidx/compose/ui/text/AnnotatedString$Range;", "T", "", "item", "start", "", "end", "(Ljava/lang/Object;II)V", "tag", "", "(Ljava/lang/Object;IILjava/lang/String;)V", "getEnd", "()I", "getItem", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getStart", "getTag", "()Ljava/lang/String;", "component1", "component2", "component3", "component4", "copy", "(Ljava/lang/Object;IILjava/lang/String;)Landroidx/compose/ui/text/AnnotatedString$Range;", "equals", "", "other", "hashCode", "toString", "ui-text"})
    @Immutable
    @SourceDebugExtension(value={"SMAP\nAnnotatedString.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnnotatedString.kt\nandroidx/compose/ui/text/AnnotatedString$Range\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1129:1\n1#2:1130\n*E\n"})
    public static final class Range<T> {
        private final T item;
        private final int start;
        private final int end;
        @NotNull
        private final String tag;
        public static final int $stable;

        public Range(T item2, int start2, int end2, @NotNull String tag) {
            Intrinsics.checkNotNullParameter(tag, "tag");
            this.item = item2;
            this.start = start2;
            this.end = end2;
            this.tag = tag;
            if (!(this.start <= this.end)) {
                boolean bl = false;
                String string = "Reversed range is not supported";
                throw new IllegalArgumentException(string.toString());
            }
        }

        public final T getItem() {
            return this.item;
        }

        public final int getStart() {
            return this.start;
        }

        public final int getEnd() {
            return this.end;
        }

        @NotNull
        public final String getTag() {
            return this.tag;
        }

        public Range(T item2, int start2, int end2) {
            this(item2, start2, end2, "");
        }

        public final T component1() {
            return this.item;
        }

        public final int component2() {
            return this.start;
        }

        public final int component3() {
            return this.end;
        }

        @NotNull
        public final String component4() {
            return this.tag;
        }

        @NotNull
        public final Range<T> copy(T item2, int start2, int end2, @NotNull String tag) {
            Intrinsics.checkNotNullParameter(tag, "tag");
            return new Range<T>(item2, start2, end2, tag);
        }

        public static /* synthetic */ Range copy$default(Range range, Object object, int n, int n2, String string, int n3, Object object2) {
            if ((n3 & 1) != 0) {
                object = range.item;
            }
            if ((n3 & 2) != 0) {
                n = range.start;
            }
            if ((n3 & 4) != 0) {
                n2 = range.end;
            }
            if ((n3 & 8) != 0) {
                string = range.tag;
            }
            return range.copy(object, n, n2, string);
        }

        @NotNull
        public String toString() {
            return "Range(item=" + this.item + ", start=" + this.start + ", end=" + this.end + ", tag=" + this.tag + ')';
        }

        public int hashCode() {
            int result2 = this.item == null ? 0 : this.item.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.start);
            result2 = result2 * 31 + Integer.hashCode(this.end);
            result2 = result2 * 31 + this.tag.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Range)) {
                return false;
            }
            Range range = (Range)other;
            if (!Intrinsics.areEqual(this.item, range.item)) {
                return false;
            }
            if (this.start != range.start) {
                return false;
            }
            if (this.end != range.end) {
                return false;
            }
            return Intrinsics.areEqual(this.tag, range.tag);
        }
    }
}

