/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.input.pointer.util;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.input.pointer.util.DataPointAtTime;
import androidx.compose.ui.input.pointer.util.VelocityTrackerKt;
import androidx.compose.ui.input.pointer.util.VelocityTracker_notMobileKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0014\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0007\n\u0002\b\t\b\u0007\u0018\u00002\u00020\u0001:\u0001!B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u001b\b\u0000\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J \u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\tH\u0002J\u0006\u0010\u001e\u001a\u00020\u0019J\u000e\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u0019J\u0006\u0010 \u001a\u00020\u0015R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\nR\u000e\u0010\u000b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u0011X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0013R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Landroidx/compose/ui/input/pointer/util/VelocityTracker1D;", "", "isDataDifferential", "", "(Z)V", "strategy", "Landroidx/compose/ui/input/pointer/util/VelocityTracker1D$Strategy;", "(ZLandroidx/compose/ui/input/pointer/util/VelocityTracker1D$Strategy;)V", "index", "", "()Z", "minSampleSize", "reusableDataPointsArray", "", "reusableTimeArray", "reusableVelocityCoefficients", "samples", "", "Landroidx/compose/ui/input/pointer/util/DataPointAtTime;", "[Landroidx/compose/ui/input/pointer/util/DataPointAtTime;", "addDataPoint", "", "timeMillis", "", "dataPoint", "", "calculateLeastSquaresVelocity", "dataPoints", "time", "sampleCount", "calculateVelocity", "maximumVelocity", "resetTracking", "Strategy", "ui"})
@StabilityInferred(parameters=0)
public final class VelocityTracker1D {
    private final boolean isDataDifferential;
    @NotNull
    private final Strategy strategy;
    private final int minSampleSize;
    @NotNull
    private final DataPointAtTime[] samples;
    private int index;
    @NotNull
    private final float[] reusableDataPointsArray;
    @NotNull
    private final float[] reusableTimeArray;
    @NotNull
    private final float[] reusableVelocityCoefficients;
    public static final int $stable = 8;

    public VelocityTracker1D(boolean isDataDifferential, @NotNull Strategy strategy) {
        int n;
        Intrinsics.checkNotNullParameter((Object)strategy, "strategy");
        this.isDataDifferential = isDataDifferential;
        this.strategy = strategy;
        if (this.isDataDifferential && this.strategy.equals((Object)Strategy.Lsq2)) {
            throw new IllegalStateException("Lsq2 not (yet) supported for differential axes");
        }
        switch (WhenMappings.$EnumSwitchMapping$0[this.strategy.ordinal()]) {
            case 1: {
                n = 2;
                break;
            }
            case 2: {
                n = 3;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        this.minSampleSize = n;
        this.samples = new DataPointAtTime[20];
        this.reusableDataPointsArray = new float[20];
        this.reusableTimeArray = new float[20];
        this.reusableVelocityCoefficients = new float[3];
    }

    public /* synthetic */ VelocityTracker1D(boolean bl, Strategy strategy, int n, DefaultConstructorMarker defaultConstructorMarker2) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            strategy = Strategy.Lsq2;
        }
        this(bl, strategy);
    }

    public final boolean isDataDifferential() {
        return this.isDataDifferential;
    }

    public VelocityTracker1D(boolean isDataDifferential) {
        this(isDataDifferential, Strategy.Impulse);
    }

    public final void addDataPoint(long timeMillis, float dataPoint) {
        this.index = (this.index + 1) % 20;
        VelocityTrackerKt.access$set(this.samples, this.index, timeMillis, dataPoint);
    }

    public final float calculateVelocity() {
        DataPointAtTime newestSample;
        float[] dataPoints = this.reusableDataPointsArray;
        float[] time = this.reusableTimeArray;
        int sampleCount = 0;
        int index2 = this.index;
        DataPointAtTime dataPointAtTime = this.samples[index2];
        if (dataPointAtTime == null) {
            return 0.0f;
        }
        DataPointAtTime previousSample = newestSample = dataPointAtTime;
        Object previousDirection = null;
        while (this.samples[index2] != null) {
            DataPointAtTime sample2;
            float age = newestSample.getTime() - sample2.getTime();
            float delta = Math.abs(sample2.getTime() - previousSample.getTime());
            previousSample = sample2;
            if (age > 100.0f || delta > 40.0f) break;
            dataPoints[sampleCount] = sample2.getDataPoint();
            time[sampleCount] = -age;
            index2 = (index2 == 0 ? 20 : index2) - 1;
            if (++sampleCount < 20) continue;
        }
        if (sampleCount >= this.minSampleSize && VelocityTracker_notMobileKt.shouldUseDataPoints(this, dataPoints, time, sampleCount)) {
            float f;
            switch (WhenMappings.$EnumSwitchMapping$0[this.strategy.ordinal()]) {
                case 1: {
                    f = VelocityTrackerKt.access$calculateImpulseVelocity(dataPoints, time, sampleCount, this.isDataDifferential);
                    break;
                }
                case 2: {
                    f = this.calculateLeastSquaresVelocity(dataPoints, time, sampleCount);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return f * (float)1000;
        }
        return 0.0f;
    }

    public final float calculateVelocity(float maximumVelocity) {
        if (!(maximumVelocity > 0.0f)) {
            boolean bl = false;
            String string = "maximumVelocity should be a positive value. You specified=" + maximumVelocity;
            throw new IllegalStateException(string.toString());
        }
        float velocity = this.calculateVelocity();
        return velocity == 0.0f ? 0.0f : (velocity > 0.0f ? RangesKt.coerceAtMost(velocity, maximumVelocity) : RangesKt.coerceAtLeast(velocity, -maximumVelocity));
    }

    public final void resetTracking() {
        ArraysKt.fill$default(this.samples, null, 0, 0, 6, null);
        this.index = 0;
    }

    private final float calculateLeastSquaresVelocity(float[] dataPoints, float[] time, int sampleCount) {
        float f;
        try {
            f = VelocityTrackerKt.polyFitLeastSquares(time, dataPoints, sampleCount, 2, this.reusableVelocityCoefficients)[1];
        }
        catch (IllegalArgumentException exception) {
            f = 0.0f;
        }
        return f;
    }

    public VelocityTracker1D() {
        this(false, null, 3, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0080\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Landroidx/compose/ui/input/pointer/util/VelocityTracker1D$Strategy;", "", "(Ljava/lang/String;I)V", "Lsq2", "Impulse", "ui"})
    public static final class Strategy
    extends Enum<Strategy> {
        public static final /* enum */ Strategy Lsq2 = new Strategy();
        public static final /* enum */ Strategy Impulse = new Strategy();
        private static final /* synthetic */ Strategy[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Strategy[] values() {
            return (Strategy[])$VALUES.clone();
        }

        public static Strategy valueOf(String value) {
            return Enum.valueOf(Strategy.class, value);
        }

        @NotNull
        public static EnumEntries<Strategy> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = strategyArray = new Strategy[]{Strategy.Lsq2, Strategy.Impulse};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Strategy.values().length];
            try {
                nArray[Strategy.Impulse.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Strategy.Lsq2.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

