/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.input.pointer;

import androidx.collection.LongSparseArray;
import androidx.compose.ui.input.pointer.InternalPointerEvent;
import androidx.compose.ui.input.pointer.PointerInputChange;
import androidx.compose.ui.input.pointer.PointerInputEvent;
import androidx.compose.ui.input.pointer.PointerInputEventData;
import androidx.compose.ui.input.pointer.PositionCalculator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Landroidx/compose/ui/input/pointer/PointerInputChangeEventProducer;", "", "()V", "previousPointerInputData", "Landroidx/collection/LongSparseArray;", "Landroidx/compose/ui/input/pointer/PointerInputChangeEventProducer$PointerInputData;", "clear", "", "produce", "Landroidx/compose/ui/input/pointer/InternalPointerEvent;", "pointerInputEvent", "Landroidx/compose/ui/input/pointer/PointerInputEvent;", "positionCalculator", "Landroidx/compose/ui/input/pointer/PositionCalculator;", "PointerInputData", "ui"})
@SourceDebugExtension(value={"SMAP\nPointerInputEventProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PointerInputEventProcessor.kt\nandroidx/compose/ui/input/pointer/PointerInputChangeEventProducer\n+ 2 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n*L\n1#1,262:1\n33#2,6:263\n*S KotlinDebug\n*F\n+ 1 PointerInputEventProcessor.kt\nandroidx/compose/ui/input/pointer/PointerInputChangeEventProducer\n*L\n170#1:263,6\n*E\n"})
final class PointerInputChangeEventProducer {
    @NotNull
    private final LongSparseArray<PointerInputData> previousPointerInputData = new LongSparseArray(0, 1, null);

    @NotNull
    public final InternalPointerEvent produce(@NotNull PointerInputEvent pointerInputEvent, @NotNull PositionCalculator positionCalculator) {
        Intrinsics.checkNotNullParameter(pointerInputEvent, "pointerInputEvent");
        Intrinsics.checkNotNullParameter(positionCalculator, "positionCalculator");
        LongSparseArray<PointerInputChange> changes = new LongSparseArray<PointerInputChange>(pointerInputEvent.getPointers().size());
        List<PointerInputEventData> $this$fastForEach$iv = pointerInputEvent.getPointers();
        boolean $i$f$fastForEach = false;
        int n = $this$fastForEach$iv.size();
        for (int index$iv = 0; index$iv < n; ++index$iv) {
            PointerInputEventData item$iv;
            PointerInputEventData it = item$iv = $this$fastForEach$iv.get(index$iv);
            boolean bl = false;
            long previousTime = 0L;
            long previousPosition = 0L;
            boolean previousDown = false;
            PointerInputData previousData = this.previousPointerInputData.get(it.getId-J3iCeTQ());
            if (previousData == null) {
                previousTime = it.getUptime();
                previousPosition = it.getPosition-F1C5BW0();
                previousDown = false;
            } else {
                previousTime = previousData.getUptime();
                previousDown = previousData.getDown();
                previousPosition = positionCalculator.screenToLocal-MK-Hz9U(previousData.getPositionOnScreen-F1C5BW0());
            }
            changes.put(it.getId-J3iCeTQ(), new PointerInputChange(it.getId-J3iCeTQ(), it.getUptime(), it.getPosition-F1C5BW0(), it.getDown(), it.getPressure(), previousTime, previousPosition, previousDown, false, it.getType-T8wyACA(), it.getHistorical(), it.getScrollDelta-F1C5BW0(), it.getOriginalEventPosition-F1C5BW0(), null));
            if (it.getDown()) {
                this.previousPointerInputData.put(it.getId-J3iCeTQ(), new PointerInputData(it.getUptime(), it.getPositionOnScreen-F1C5BW0(), it.getDown(), it.getType-T8wyACA(), null));
                continue;
            }
            this.previousPointerInputData.remove(it.getId-J3iCeTQ());
        }
        return new InternalPointerEvent(changes, pointerInputEvent);
    }

    public final void clear() {
        this.previousPointerInputData.clear();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0019\u0010\u0004\u001a\u00020\u0005\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000eR\u0019\u0010\b\u001a\u00020\t\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\n\n\u0002\u0010\u0012\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000e\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u0014"}, d2={"Landroidx/compose/ui/input/pointer/PointerInputChangeEventProducer$PointerInputData;", "", "uptime", "", "positionOnScreen", "Landroidx/compose/ui/geometry/Offset;", "down", "", "type", "Landroidx/compose/ui/input/pointer/PointerType;", "(JJZILkotlin/jvm/internal/DefaultConstructorMarker;)V", "getDown", "()Z", "getPositionOnScreen-F1C5BW0", "()J", "J", "getType-T8wyACA", "()I", "I", "getUptime", "ui"})
    private static final class PointerInputData {
        private final long uptime;
        private final long positionOnScreen;
        private final boolean down;
        private final int type;

        private PointerInputData(long uptime, long positionOnScreen, boolean down, int type2) {
            this.uptime = uptime;
            this.positionOnScreen = positionOnScreen;
            this.down = down;
            this.type = type2;
        }

        public final long getUptime() {
            return this.uptime;
        }

        public final long getPositionOnScreen-F1C5BW0() {
            return this.positionOnScreen;
        }

        public final boolean getDown() {
            return this.down;
        }

        public final int getType-T8wyACA() {
            return this.type;
        }

        public /* synthetic */ PointerInputData(long uptime, long positionOnScreen, boolean down, int type2, DefaultConstructorMarker $constructor_marker) {
            this(uptime, positionOnScreen, down, type2);
        }
    }
}

