/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime.snapshots;

import androidx.compose.runtime.ActualJvm_jvmKt;
import androidx.compose.runtime.WeakReference;
import androidx.compose.runtime.internal.StabilityInferred;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0013\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001bJ\u001d\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00028\u00002\u0006\u0010\u001d\u001a\u00020\u000bH\u0002\u00a2\u0006\u0002\u0010\u001eJ%\u0010\u001f\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00028\u00002\u0006\u0010!\u001a\u00020\u000bH\u0002\u00a2\u0006\u0002\u0010\"J\r\u0010#\u001a\u00020\u0019H\u0001\u00a2\u0006\u0002\b$J \u0010%\u001a\u00020&2\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00190(H\u0086\b\u00f8\u0001\u0000R\u001a\u0010\u0004\u001a\u00020\u0005X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR*\u0010\u0010\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00120\u0011X\u0080\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0017\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006)"}, d2={"Landroidx/compose/runtime/snapshots/SnapshotWeakSet;", "T", "", "()V", "hashes", "", "getHashes$runtime", "()[I", "setHashes$runtime", "([I)V", "size", "", "getSize$runtime", "()I", "setSize$runtime", "(I)V", "values", "", "Landroidx/compose/runtime/WeakReference;", "getValues$runtime", "()[Landroidx/compose/runtime/WeakReference;", "setValues$runtime", "([Landroidx/compose/runtime/WeakReference;)V", "[Landroidx/compose/runtime/WeakReference;", "add", "", "value", "(Ljava/lang/Object;)Z", "find", "hash", "(Ljava/lang/Object;I)I", "findExactIndex", "midIndex", "valueHash", "(ILjava/lang/Object;I)I", "isValid", "isValid$runtime", "removeIf", "", "block", "Lkotlin/Function1;", "runtime"})
@StabilityInferred(parameters=0)
public final class SnapshotWeakSet<T> {
    private int size;
    @NotNull
    private int[] hashes = new int[16];
    @NotNull
    private WeakReference<T>[] values = new WeakReference[16];
    public static final int $stable = 8;

    public final int getSize$runtime() {
        return this.size;
    }

    public final void setSize$runtime(int n) {
        this.size = n;
    }

    @NotNull
    public final int[] getHashes$runtime() {
        return this.hashes;
    }

    public final void setHashes$runtime(@NotNull int[] nArray) {
        Intrinsics.checkNotNullParameter(nArray, "<set-?>");
        this.hashes = nArray;
    }

    @NotNull
    public final WeakReference<T>[] getValues$runtime() {
        return this.values;
    }

    public final void setValues$runtime(@NotNull WeakReference<T>[] weakReferenceArray) {
        Intrinsics.checkNotNullParameter(weakReferenceArray, "<set-?>");
        this.values = weakReferenceArray;
    }

    public final boolean add(@NotNull T value) {
        Intrinsics.checkNotNullParameter(value, "value");
        int index2 = 0;
        int size2 = this.size;
        int hash = ActualJvm_jvmKt.identityHashCode(value);
        if (size2 > 0) {
            index2 = this.find(value, hash);
            if (index2 >= 0) {
                return false;
            }
        } else {
            index2 = -1;
        }
        int insertIndex = -(index2 + 1);
        int capacity = this.values.length;
        if (size2 == capacity) {
            int newCapacity = capacity * 2;
            Object[] newValues = new WeakReference[newCapacity];
            int[] newHashes = new int[newCapacity];
            ArraysKt.copyInto(this.values, newValues, insertIndex + 1, insertIndex, size2);
            ArraysKt.copyInto$default(this.values, newValues, 0, 0, insertIndex, 6, null);
            ArraysKt.copyInto(this.hashes, newHashes, insertIndex + 1, insertIndex, size2);
            ArraysKt.copyInto$default(this.hashes, newHashes, 0, 0, insertIndex, 6, null);
            this.values = newValues;
            this.hashes = newHashes;
        } else {
            ArraysKt.copyInto(this.values, this.values, insertIndex + 1, insertIndex, size2);
            ArraysKt.copyInto(this.hashes, this.hashes, insertIndex + 1, insertIndex, size2);
        }
        this.values[insertIndex] = new WeakReference<T>(value);
        this.hashes[insertIndex] = hash;
        int n = this.size;
        this.size = n + 1;
        return true;
    }

    public final void removeIf(@NotNull Function1<? super T, Boolean> block2) {
        int i;
        Intrinsics.checkNotNullParameter(block2, "block");
        boolean $i$f$removeIf = false;
        int size2 = this.getSize$runtime();
        int currentUsed = 0;
        for (i = 0; i < size2; ++i) {
            Object value;
            WeakReference<T> entry;
            WeakReference<T> weakReference = entry = this.getValues$runtime()[i];
            Object object = value = weakReference != null ? weakReference.get() : null;
            if (value == null || block2.invoke(value).booleanValue()) continue;
            if (currentUsed != i) {
                this.getValues$runtime()[currentUsed] = entry;
                this.getHashes$runtime()[currentUsed] = this.getHashes$runtime()[i];
            }
            ++currentUsed;
        }
        for (i = currentUsed; i < size2; ++i) {
            this.getValues$runtime()[i] = null;
            this.getHashes$runtime()[i] = 0;
        }
        if (currentUsed != size2) {
            this.setSize$runtime(currentUsed);
        }
    }

    private final int find(T value, int hash) {
        int low = 0;
        int high = this.size - 1;
        while (low <= high) {
            Object midVal;
            int mid = low + high >>> 1;
            int midHash = this.hashes[mid];
            if (midHash < hash) {
                low = mid + 1;
                continue;
            }
            if (midHash > hash) {
                high = mid - 1;
                continue;
            }
            WeakReference<T> weakReference = this.values[mid];
            Object object = midVal = weakReference != null ? weakReference.get() : null;
            if (value == midVal) {
                return mid;
            }
            return this.findExactIndex(mid, value, hash);
        }
        return -(low + 1);
    }

    private final int findExactIndex(int midIndex, T value, int valueHash) {
        int i;
        for (i = midIndex - 1; -1 < i && this.hashes[i] == valueHash; --i) {
            Object v;
            WeakReference<T> weakReference = this.values[i];
            Object object = v = weakReference != null ? weakReference.get() : null;
            if (v != value) continue;
            return i;
        }
        int n = this.size;
        for (i = midIndex + 1; i < n; ++i) {
            Object v;
            if (this.hashes[i] != valueHash) {
                return -(i + 1);
            }
            WeakReference<T> weakReference = this.values[i];
            Object object = v = weakReference != null ? weakReference.get() : null;
            if (v != value) continue;
            return i;
        }
        return -(this.size + 1);
    }

    @TestOnly
    public final boolean isValid$runtime() {
        int i;
        int size2 = this.size;
        WeakReference<T>[] values2 = this.values;
        int[] hashes = this.hashes;
        int capacity = values2.length;
        if (size2 > capacity) {
            return false;
        }
        int previous = Integer.MIN_VALUE;
        for (i = 0; i < size2; ++i) {
            WeakReference<T> entry;
            int hash = hashes[i];
            if (hash < previous) {
                return false;
            }
            if (values2[i] == null) {
                return false;
            }
            Object value = entry.get();
            if (value != null && hash != ActualJvm_jvmKt.identityHashCode(value)) {
                return false;
            }
            previous = hash;
        }
        for (i = size2; i < capacity; ++i) {
            if (hashes[i] != 0) {
                return false;
            }
            if (values2[i] == null) continue;
            return false;
        }
        return true;
    }
}

