/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.material3;

import androidx.compose.material3.CalendarDate;
import androidx.compose.material3.CalendarModel;
import androidx.compose.material3.CalendarMonth;
import androidx.compose.material3.DateInputFormat;
import androidx.compose.material3.KotlinxDatetimeCalendarModelKt;
import androidx.compose.material3.PlatformDateFormat;
import androidx.compose.runtime.internal.StabilityInferred;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.datetime.Clock;
import kotlinx.datetime.DatePeriod;
import kotlinx.datetime.DayOfWeekKt;
import kotlinx.datetime.Instant;
import kotlinx.datetime.LocalDate;
import kotlinx.datetime.LocalDateJvmKt;
import kotlinx.datetime.LocalDateKt;
import kotlinx.datetime.LocalDateTime;
import kotlinx.datetime.TimeZone;
import kotlinx.datetime.TimeZoneKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0002\u0010\u0005J$\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00172\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004H\u0016J\u0010\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020\u001cH\u0016J\u0014\u0010 \u001a\u00020!2\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004H\u0016J\u0010\u0010\"\u001a\u00020\u00072\u0006\u0010#\u001a\u00020\u0011H\u0016J\u0010\u0010$\u001a\u00020%2\u0006\u0010#\u001a\u00020\u0011H\u0016J\u0018\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00072\u0006\u0010'\u001a\u00020\u0007H\u0016J\u0010\u0010$\u001a\u00020%2\u0006\u0010\u001f\u001a\u00020\u001cH\u0016J\u0018\u0010(\u001a\u00020%2\u0006\u0010)\u001a\u00020%2\u0006\u0010*\u001a\u00020\u0007H\u0016J\u001a\u0010+\u001a\u0004\u0018\u00010\u00112\u0006\u0010#\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u0017H\u0016J\u0018\u0010,\u001a\u00020%2\u0006\u0010)\u001a\u00020%2\u0006\u0010-\u001a\u00020\u0007H\u0016J\f\u0010.\u001a\u00020\u0007*\u00020/H\u0002J\u0014\u00100\u001a\u00020%*\u0002012\u0006\u00102\u001a\u00020\rH\u0002R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R&\u0010\u0014\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00170\u00160\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u00063"}, d2={"Landroidx/compose/material3/KotlinxDatetimeCalendarModel;", "Landroidx/compose/material3/CalendarModel;", "locale", "Ljava/util/Locale;", "Landroidx/compose/material3/CalendarLocale;", "(Ljava/util/Locale;)V", "firstDayOfWeek", "", "getFirstDayOfWeek", "()I", "platformDateFormat", "Landroidx/compose/material3/PlatformDateFormat;", "systemTZ", "Lkotlinx/datetime/TimeZone;", "getSystemTZ", "()Lkotlinx/datetime/TimeZone;", "today", "Landroidx/compose/material3/CalendarDate;", "getToday", "()Landroidx/compose/material3/CalendarDate;", "weekdayNames", "", "Lkotlin/Pair;", "", "getWeekdayNames", "()Ljava/util/List;", "formatWithPattern", "utcTimeMillis", "", "pattern", "getCanonicalDate", "timeInMillis", "getDateInputFormat", "Landroidx/compose/material3/DateInputFormat;", "getDayOfWeek", "date", "getMonth", "Landroidx/compose/material3/CalendarMonth;", "year", "month", "minusMonths", "from", "subtractedMonthsCount", "parse", "plusMonths", "addedMonthsCount", "daysFromStartOfWeekToFirstOfMonth", "Lkotlinx/datetime/LocalDate;", "toCalendarMonth", "Lkotlinx/datetime/Instant;", "timeZone", "material3"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nKotlinxDatetimeCalendarModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinxDatetimeCalendarModel.kt\nandroidx/compose/material3/KotlinxDatetimeCalendarModel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,191:1\n1#2:192\n*E\n"})
public final class KotlinxDatetimeCalendarModel
extends CalendarModel {
    @NotNull
    private final PlatformDateFormat platformDateFormat;
    public static final int $stable = 8;

    public KotlinxDatetimeCalendarModel(@NotNull Locale locale) {
        Intrinsics.checkNotNullParameter(locale, "locale");
        super(locale);
        this.platformDateFormat = new PlatformDateFormat(locale);
    }

    @Override
    @NotNull
    public CalendarDate getToday() {
        LocalDateTime localDate = TimeZoneKt.toLocalDateTime(Clock.System.INSTANCE.now(), this.getSystemTZ());
        return new CalendarDate(localDate.getYear(), localDate.getMonthNumber(), localDate.getDayOfMonth(), TimeZoneKt.toInstant(LocalDateKt.atTime(localDate.getDate(), KotlinxDatetimeCalendarModelKt.getMidnight()), TimeZone.Companion.getUTC()).toEpochMilliseconds());
    }

    @Override
    public int getFirstDayOfWeek() {
        return this.platformDateFormat.getFirstDayOfWeek();
    }

    @Override
    @NotNull
    public List<Pair<String, String>> getWeekdayNames() {
        return this.platformDateFormat.getWeekdayNames();
    }

    private final TimeZone getSystemTZ() {
        return TimeZone.Companion.currentSystemDefault();
    }

    @Override
    @NotNull
    public DateInputFormat getDateInputFormat(@NotNull Locale locale) {
        Intrinsics.checkNotNullParameter(locale, "locale");
        return this.platformDateFormat.getDateInputFormat();
    }

    @Override
    @NotNull
    public CalendarDate getCanonicalDate(long timeInMillis) {
        return KotlinxDatetimeCalendarModelKt.toCalendarDate(TimeZoneKt.atStartOfDayIn(TimeZoneKt.toLocalDateTime(Instant.Companion.fromEpochMilliseconds(timeInMillis), TimeZone.Companion.getUTC()).getDate(), TimeZone.Companion.getUTC()), TimeZone.Companion.getUTC());
    }

    @Override
    @NotNull
    public CalendarMonth getMonth(long timeInMillis) {
        return this.toCalendarMonth(Instant.Companion.fromEpochMilliseconds(timeInMillis), TimeZone.Companion.getUTC());
    }

    @Override
    @NotNull
    public CalendarMonth getMonth(@NotNull CalendarDate date) {
        Intrinsics.checkNotNullParameter(date, "date");
        return this.getMonth(date.getUtcTimeMillis());
    }

    @Override
    @NotNull
    public CalendarMonth getMonth(int year, int month) {
        Instant instant = TimeZoneKt.toInstant(LocalDateKt.atTime(new LocalDate(year, month, 1), KotlinxDatetimeCalendarModelKt.getMidnight()), TimeZone.Companion.getUTC());
        return this.getMonth(instant.toEpochMilliseconds());
    }

    @Override
    public int getDayOfWeek(@NotNull CalendarDate date) {
        Intrinsics.checkNotNullParameter(date, "date");
        return DayOfWeekKt.getIsoDayNumber(new LocalDate(date.getYear(), date.getMonth(), date.getDayOfMonth()).getDayOfWeek());
    }

    @Override
    @NotNull
    public CalendarMonth plusMonths(@NotNull CalendarMonth from, int addedMonthsCount) {
        Intrinsics.checkNotNullParameter(from, "from");
        return this.toCalendarMonth(TimeZoneKt.toInstant(LocalDateKt.atTime(LocalDateJvmKt.plus(TimeZoneKt.toLocalDateTime(Instant.Companion.fromEpochMilliseconds(from.getStartUtcTimeMillis()), TimeZone.Companion.getUTC()).getDate(), new DatePeriod(0, addedMonthsCount, 0, 5, null)), KotlinxDatetimeCalendarModelKt.getMidnight()), TimeZone.Companion.getUTC()), TimeZone.Companion.getUTC());
    }

    @Override
    @NotNull
    public CalendarMonth minusMonths(@NotNull CalendarMonth from, int subtractedMonthsCount) {
        Intrinsics.checkNotNullParameter(from, "from");
        return this.plusMonths(from, -subtractedMonthsCount);
    }

    @Override
    @NotNull
    public String formatWithPattern(long utcTimeMillis, @NotNull String pattern, @NotNull Locale locale) {
        Intrinsics.checkNotNullParameter(pattern, "pattern");
        Intrinsics.checkNotNullParameter(locale, "locale");
        return this.platformDateFormat.formatWithPattern(utcTimeMillis, pattern);
    }

    @Override
    @Nullable
    public CalendarDate parse(@NotNull String date, @NotNull String pattern) {
        Intrinsics.checkNotNullParameter(date, "date");
        Intrinsics.checkNotNullParameter(pattern, "pattern");
        return this.platformDateFormat.parse(date, pattern);
    }

    private final CalendarMonth toCalendarMonth(Instant $this$toCalendarMonth, TimeZone timeZone) {
        LocalDateTime dateTime = TimeZoneKt.toLocalDateTime($this$toCalendarMonth, timeZone);
        LocalDate monthStart = new LocalDate(dateTime.getYear(), dateTime.getMonth(), 1);
        return new CalendarMonth(dateTime.getYear(), dateTime.getMonthNumber(), KotlinxDatetimeCalendarModelKt.access$numberOfDays(dateTime.getMonth(), KotlinxDatetimeCalendarModelKt.access$isLeapYear(dateTime.getYear())), this.daysFromStartOfWeekToFirstOfMonth(monthStart), TimeZoneKt.toInstant(LocalDateKt.atTime(monthStart, KotlinxDatetimeCalendarModelKt.getMidnight()), TimeZone.Companion.getUTC()).toEpochMilliseconds());
    }

    private final int daysFromStartOfWeekToFirstOfMonth(LocalDate $this$daysFromStartOfWeekToFirstOfMonth) {
        int it = DayOfWeekKt.getIsoDayNumber($this$daysFromStartOfWeekToFirstOfMonth.getDayOfWeek()) - this.getFirstDayOfWeek();
        boolean bl = false;
        return it >= 0 ? it : 7 + it;
    }
}

