/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text.selection;

import androidx.compose.foundation.text.TextLayoutResultProxy;
import androidx.compose.foundation.text.selection.BaseTextPreparedSelection;
import androidx.compose.foundation.text.selection.TextPreparedSelectionState;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.geometry.OffsetKt;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.geometry.Size;
import androidx.compose.ui.layout.LayoutCoordinates;
import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.TextLayoutResult;
import androidx.compose.ui.text.TextRange;
import androidx.compose.ui.text.input.CommitTextCommand;
import androidx.compose.ui.text.input.EditCommand;
import androidx.compose.ui.text.input.OffsetMapping;
import androidx.compose.ui.text.input.SetSelectionCommand;
import androidx.compose.ui.text.input.TextFieldValue;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ)\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00122\u0019\u0010\u0014\u001a\u0015\u0012\u0004\u0012\u00020\u0000\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u0015\u00a2\u0006\u0002\b\u0016J\u0006\u0010\u0017\u001a\u00020\u0000J\u0006\u0010\u0018\u001a\u00020\u0000J\u0014\u0010\u0019\u001a\u00020\u001a*\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u001aH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\f\u00a8\u0006\u001c"}, d2={"Landroidx/compose/foundation/text/selection/TextFieldPreparedSelection;", "Landroidx/compose/foundation/text/selection/BaseTextPreparedSelection;", "currentValue", "Landroidx/compose/ui/text/input/TextFieldValue;", "offsetMapping", "Landroidx/compose/ui/text/input/OffsetMapping;", "layoutResultProxy", "Landroidx/compose/foundation/text/TextLayoutResultProxy;", "state", "Landroidx/compose/foundation/text/selection/TextPreparedSelectionState;", "(Landroidx/compose/ui/text/input/TextFieldValue;Landroidx/compose/ui/text/input/OffsetMapping;Landroidx/compose/foundation/text/TextLayoutResultProxy;Landroidx/compose/foundation/text/selection/TextPreparedSelectionState;)V", "getCurrentValue", "()Landroidx/compose/ui/text/input/TextFieldValue;", "getLayoutResultProxy", "()Landroidx/compose/foundation/text/TextLayoutResultProxy;", "value", "getValue", "deleteIfSelectedOr", "", "Landroidx/compose/ui/text/input/EditCommand;", "or", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "moveCursorDownByPage", "moveCursorUpByPage", "jumpByPagesOffset", "", "pagesAmount", "foundation"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nTextPreparedSelection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextPreparedSelection.kt\nandroidx/compose/foundation/text/selection/TextFieldPreparedSelection\n+ 2 TextPreparedSelection.kt\nandroidx/compose/foundation/text/selection/BaseTextPreparedSelection\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,438:1\n74#2,5:439\n80#2:445\n74#2,7:446\n1#3:444\n*S KotlinDebug\n*F\n+ 1 TextPreparedSelection.kt\nandroidx/compose/foundation/text/selection/TextFieldPreparedSelection\n*L\n413#1:439,5\n413#1:445\n417#1:446,7\n*E\n"})
public final class TextFieldPreparedSelection
extends BaseTextPreparedSelection<TextFieldPreparedSelection> {
    @NotNull
    private final TextFieldValue currentValue;
    @Nullable
    private final TextLayoutResultProxy layoutResultProxy;
    public static final int $stable = 8;

    public TextFieldPreparedSelection(@NotNull TextFieldValue currentValue, @NotNull OffsetMapping offsetMapping, @Nullable TextLayoutResultProxy layoutResultProxy, @NotNull TextPreparedSelectionState state2) {
        Intrinsics.checkNotNullParameter(currentValue, "currentValue");
        Intrinsics.checkNotNullParameter(offsetMapping, "offsetMapping");
        Intrinsics.checkNotNullParameter(state2, "state");
        AnnotatedString annotatedString = currentValue.getAnnotatedString();
        long l = currentValue.getSelection-d9O1mEE();
        TextLayoutResultProxy textLayoutResultProxy = layoutResultProxy;
        TextLayoutResult textLayoutResult = textLayoutResultProxy != null ? textLayoutResultProxy.getValue() : null;
        super(annotatedString, l, textLayoutResult, offsetMapping, state2, null);
        this.currentValue = currentValue;
        this.layoutResultProxy = layoutResultProxy;
    }

    public /* synthetic */ TextFieldPreparedSelection(TextFieldValue textFieldValue, OffsetMapping offsetMapping, TextLayoutResultProxy textLayoutResultProxy, TextPreparedSelectionState textPreparedSelectionState, int n, DefaultConstructorMarker defaultConstructorMarker2) {
        if ((n & 2) != 0) {
            offsetMapping = OffsetMapping.Companion.getIdentity();
        }
        if ((n & 8) != 0) {
            textPreparedSelectionState = new TextPreparedSelectionState();
        }
        this(textFieldValue, offsetMapping, textLayoutResultProxy, textPreparedSelectionState);
    }

    @NotNull
    public final TextFieldValue getCurrentValue() {
        return this.currentValue;
    }

    @Nullable
    public final TextLayoutResultProxy getLayoutResultProxy() {
        return this.layoutResultProxy;
    }

    @NotNull
    public final TextFieldValue getValue() {
        return TextFieldValue.copy-3r_uNRQ$default(this.currentValue, this.getAnnotatedString(), this.getSelection-d9O1mEE(), null, 4, null);
    }

    @Nullable
    public final List<EditCommand> deleteIfSelectedOr(@NotNull Function1<? super TextFieldPreparedSelection, ? extends EditCommand> or) {
        List<EditCommand> list2;
        Intrinsics.checkNotNullParameter(or, "or");
        if (TextRange.getCollapsed-impl(this.getSelection-d9O1mEE())) {
            EditCommand editCommand = or.invoke(this);
            if (editCommand != null) {
                EditCommand it = editCommand;
                boolean bl = false;
                list2 = CollectionsKt.listOf(it);
            } else {
                list2 = null;
            }
        } else {
            EditCommand[] editCommandArray = new EditCommand[]{new CommitTextCommand("", 0), new SetSelectionCommand(TextRange.getMin-impl(this.getSelection-d9O1mEE()), TextRange.getMin-impl(this.getSelection-d9O1mEE()))};
            list2 = CollectionsKt.listOf(editCommandArray);
        }
        return list2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final TextFieldPreparedSelection moveCursorUpByPage() {
        void $this$apply$iv;
        void this_$iv;
        BaseTextPreparedSelection baseTextPreparedSelection = this;
        TextFieldPreparedSelection textFieldPreparedSelection = this;
        boolean resetCachedX$iv = false;
        boolean $i$f$apply = false;
        if (((CharSequence)this_$iv.getText$foundation()).length() > 0) {
            TextFieldPreparedSelection $this$moveCursorUpByPage_u24lambda_u242 = (TextFieldPreparedSelection)$this$apply$iv;
            boolean bl = false;
            TextLayoutResultProxy textLayoutResultProxy = $this$moveCursorUpByPage_u24lambda_u242.layoutResultProxy;
            if (textLayoutResultProxy != null) {
                int it = $this$moveCursorUpByPage_u24lambda_u242.jumpByPagesOffset(textLayoutResultProxy, -1);
                boolean bl2 = false;
                $this$moveCursorUpByPage_u24lambda_u242.setCursor(it);
            }
        }
        Intrinsics.checkNotNull($this$apply$iv, "null cannot be cast to non-null type T of androidx.compose.foundation.text.selection.BaseTextPreparedSelection");
        return (TextFieldPreparedSelection)((BaseTextPreparedSelection)$this$apply$iv);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final TextFieldPreparedSelection moveCursorDownByPage() {
        void $this$apply$iv;
        void this_$iv;
        BaseTextPreparedSelection baseTextPreparedSelection = this;
        TextFieldPreparedSelection textFieldPreparedSelection = this;
        boolean resetCachedX$iv = false;
        boolean $i$f$apply = false;
        if (((CharSequence)this_$iv.getText$foundation()).length() > 0) {
            TextFieldPreparedSelection $this$moveCursorDownByPage_u24lambda_u244 = (TextFieldPreparedSelection)$this$apply$iv;
            boolean bl = false;
            TextLayoutResultProxy textLayoutResultProxy = $this$moveCursorDownByPage_u24lambda_u244.layoutResultProxy;
            if (textLayoutResultProxy != null) {
                int it = $this$moveCursorDownByPage_u24lambda_u244.jumpByPagesOffset(textLayoutResultProxy, 1);
                boolean bl2 = false;
                $this$moveCursorDownByPage_u24lambda_u244.setCursor(it);
            }
        }
        Intrinsics.checkNotNull($this$apply$iv, "null cannot be cast to non-null type T of androidx.compose.foundation.text.selection.BaseTextPreparedSelection");
        return (TextFieldPreparedSelection)((BaseTextPreparedSelection)$this$apply$iv);
    }

    private final int jumpByPagesOffset(TextLayoutResultProxy $this$jumpByPagesOffset, int pagesAmount) {
        Object object;
        block4: {
            block3: {
                object = $this$jumpByPagesOffset.getInnerTextFieldCoordinates();
                if (object == null) break block3;
                LayoutCoordinates inner = object;
                boolean bl = false;
                LayoutCoordinates layoutCoordinates = $this$jumpByPagesOffset.getDecorationBoxCoordinates();
                Rect rect2 = layoutCoordinates != null ? LayoutCoordinates.localBoundingBoxOf$default(layoutCoordinates, inner, false, 2, null) : null;
                object = rect2;
                if (rect2 != null) break block4;
            }
            object = Rect.Companion.getZero();
        }
        Object visibleInnerTextFieldRect = object;
        int currentOffset = this.getOffsetMapping().originalToTransformed(TextRange.getEnd-impl(this.currentValue.getSelection-d9O1mEE()));
        Rect currentPos = $this$jumpByPagesOffset.getValue().getCursorRect(currentOffset);
        float x2 = currentPos.getLeft();
        float y2 = currentPos.getTop() + Size.getHeight-impl(((Rect)visibleInnerTextFieldRect).getSize-NH-jbRc()) * (float)pagesAmount;
        return this.getOffsetMapping().transformedToOriginal($this$jumpByPagesOffset.getValue().getOffsetForPosition-k-4lQ0M(OffsetKt.Offset(x2, y2)));
    }
}

