/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text.selection;

import androidx.annotation.VisibleForTesting;
import androidx.compose.foundation.text.Handle;
import androidx.compose.foundation.text.selection.Selectable;
import androidx.compose.foundation.text.selection.Selection;
import androidx.compose.foundation.text.selection.SelectionManager;
import androidx.compose.foundation.text.selection.SelectionManagerKt;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.OffsetKt;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.geometry.RectKt;
import androidx.compose.ui.input.pointer.AwaitPointerEventScope;
import androidx.compose.ui.input.pointer.PointerEvent;
import androidx.compose.ui.input.pointer.PointerEventPass;
import androidx.compose.ui.input.pointer.PointerInputChange;
import androidx.compose.ui.layout.LayoutCoordinates;
import androidx.compose.ui.layout.LayoutCoordinatesKt;
import androidx.compose.ui.text.TextRange;
import androidx.compose.ui.unit.IntSize;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\\\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\t\u001a\"\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00f8\u0001\u0000\u00a2\u0006\u0004\b\b\u0010\t\u001a*\u0010\n\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\b\r\u0010\u000e\u001a*\u0010\u000f\u001a\u00020\u00012\u0018\u0010\u0010\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u00120\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0001\u001a2\u0010\u0017\u001a\u0004\u0018\u00010\u0018*\u00020\u00192\b\b\u0002\u0010\u001a\u001a\u00020\u001b2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001f0\u001dH\u0082@\u00a2\u0006\u0002\u0010 \u001a\u001e\u0010!\u001a\u00020\u001f*\u00020\u00012\u0006\u0010\"\u001a\u00020\u0003H\u0000\u00f8\u0001\u0000\u00a2\u0006\u0004\b#\u0010$\u001a\u001e\u0010%\u001a\b\u0012\u0004\u0012\u0002H&0\u0011\"\u0004\b\u0000\u0010&*\b\u0012\u0004\u0012\u0002H&0\u0011H\u0002\u001a\f\u0010'\u001a\u00020\u0001*\u00020\u0016H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006("}, d2={"invertedInfiniteRect", "Landroidx/compose/ui/geometry/Rect;", "calculateSelectionMagnifierCenterAndroid", "Landroidx/compose/ui/geometry/Offset;", "manager", "Landroidx/compose/foundation/text/selection/SelectionManager;", "magnifierSize", "Landroidx/compose/ui/unit/IntSize;", "calculateSelectionMagnifierCenterAndroid-O0kMr_c", "(Landroidx/compose/foundation/text/selection/SelectionManager;J)J", "getMagnifierCenter", "anchor", "Landroidx/compose/foundation/text/selection/Selection$AnchorInfo;", "getMagnifierCenter-JVtK1S4", "(Landroidx/compose/foundation/text/selection/SelectionManager;JLandroidx/compose/foundation/text/selection/Selection$AnchorInfo;)J", "getSelectedRegionRect", "selectableSubSelectionPairs", "", "Lkotlin/Pair;", "Landroidx/compose/foundation/text/selection/Selectable;", "Landroidx/compose/foundation/text/selection/Selection;", "containerCoordinates", "Landroidx/compose/ui/layout/LayoutCoordinates;", "awaitPointerEventWhereAllChanges", "Landroidx/compose/ui/input/pointer/PointerEvent;", "Landroidx/compose/ui/input/pointer/AwaitPointerEventScope;", "pass", "Landroidx/compose/ui/input/pointer/PointerEventPass;", "predicate", "Lkotlin/Function1;", "Landroidx/compose/ui/input/pointer/PointerInputChange;", "", "(Landroidx/compose/ui/input/pointer/AwaitPointerEventScope;Landroidx/compose/ui/input/pointer/PointerEventPass;Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "containsInclusive", "offset", "containsInclusive-Uv8p0NA", "(Landroidx/compose/ui/geometry/Rect;J)Z", "firstAndLast", "T", "visibleBounds", "foundation"})
@SourceDebugExtension(value={"SMAP\nSelectionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SelectionManager.kt\nandroidx/compose/foundation/text/selection/SelectionManagerKt\n+ 2 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1046:1\n33#2,6:1047\n86#2,2:1054\n33#2,6:1056\n88#2:1062\n1#3:1053\n*S KotlinDebug\n*F\n+ 1 SelectionManager.kt\nandroidx/compose/foundation/text/selection/SelectionManagerKt\n*L\n913#1:1047,6\n1042#1:1054,2\n1042#1:1056,6\n1042#1:1062\n*E\n"})
public final class SelectionManagerKt {
    @NotNull
    private static final Rect invertedInfiniteRect = new Rect(Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY);

    private static final <T> List<T> firstAndLast(List<? extends T> $this$firstAndLast) {
        List<Object> list2;
        switch ($this$firstAndLast.size()) {
            case 0: 
            case 1: {
                list2 = $this$firstAndLast;
                break;
            }
            default: {
                Object[] objectArray = new Object[]{CollectionsKt.first($this$firstAndLast), CollectionsKt.last($this$firstAndLast)};
                list2 = CollectionsKt.listOf(objectArray);
            }
        }
        return list2;
    }

    @VisibleForTesting
    @NotNull
    public static final Rect getSelectedRegionRect(@NotNull List<? extends Pair<? extends Selectable, Selection>> selectableSubSelectionPairs, @NotNull LayoutCoordinates containerCoordinates) {
        Intrinsics.checkNotNullParameter(selectableSubSelectionPairs, "selectableSubSelectionPairs");
        Intrinsics.checkNotNullParameter(containerCoordinates, "containerCoordinates");
        if (selectableSubSelectionPairs.isEmpty()) {
            return invertedInfiniteRect;
        }
        Rect rect2 = invertedInfiniteRect;
        float containerLeft = 0.0f;
        containerLeft = rect2.component1();
        float containerTop = 0.0f;
        containerTop = rect2.component2();
        float containerRight = 0.0f;
        containerRight = rect2.component3();
        float containerBottom = 0.0f;
        containerBottom = rect2.component4();
        List<? extends Pair<? extends Selectable, Selection>> $this$fastForEach$iv = selectableSubSelectionPairs;
        boolean $i$f$fastForEach = false;
        int n = $this$fastForEach$iv.size();
        for (int index$iv = 0; index$iv < n; ++index$iv) {
            LayoutCoordinates localCoordinates;
            Object object;
            Object object2;
            int maxOffset;
            int endOffset;
            Pair<? extends Selectable, Selection> item$iv;
            Pair<? extends Selectable, Selection> pair = item$iv = $this$fastForEach$iv.get(index$iv);
            boolean bl = false;
            Selectable selectable2 = pair.component1();
            Selection subSelection = pair.component2();
            int startOffset = subSelection.getStart().getOffset();
            if (startOffset == (endOffset = subSelection.getEnd().getOffset()) || selectable2.getLayoutCoordinates() == null) continue;
            int minOffset = Math.min(startOffset, endOffset);
            if (minOffset == (maxOffset = Math.max(startOffset, endOffset)) - 1) {
                object2 = new int[]{minOffset};
                object = object2;
            } else {
                object2 = new int[]{minOffset, maxOffset - 1};
                object = object2;
            }
            int[] offsets = object;
            object2 = invertedInfiniteRect;
            float left = object2.component1();
            float top = object2.component2();
            float right = object2.component3();
            float bottom = object2.component4();
            for (int i : offsets) {
                Rect rect3 = selectable2.getBoundingBox(i);
                left = Math.min(left, rect3.getLeft());
                top = Math.min(top, rect3.getTop());
                right = Math.max(right, rect3.getRight());
                bottom = Math.max(bottom, rect3.getBottom());
            }
            long localTopLeft = OffsetKt.Offset(left, top);
            long localBottomRight = OffsetKt.Offset(right, bottom);
            long containerTopLeft = containerCoordinates.localPositionOf-R5De75A(localCoordinates, localTopLeft);
            long containerBottomRight = containerCoordinates.localPositionOf-R5De75A(localCoordinates, localBottomRight);
            containerLeft = Math.min(containerLeft, Offset.getX-impl(containerTopLeft));
            containerTop = Math.min(containerTop, Offset.getY-impl(containerTopLeft));
            containerRight = Math.max(containerRight, Offset.getX-impl(containerBottomRight));
            containerBottom = Math.max(containerBottom, Offset.getY-impl(containerBottomRight));
        }
        return new Rect(containerLeft, containerTop, containerRight, containerBottom);
    }

    public static final long calculateSelectionMagnifierCenterAndroid-O0kMr_c(@NotNull SelectionManager manager, long magnifierSize) {
        long l;
        Intrinsics.checkNotNullParameter(manager, "manager");
        Selection selection = manager.getSelection();
        if (selection == null) {
            return Offset.Companion.getUnspecified-F1C5BW0();
        }
        Selection selection2 = selection;
        Handle handle2 = manager.getDraggingHandle();
        switch (handle2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[handle2.ordinal()]) {
            case -1: {
                return Offset.Companion.getUnspecified-F1C5BW0();
            }
            case 1: {
                l = SelectionManagerKt.getMagnifierCenter-JVtK1S4(manager, magnifierSize, selection2.getStart());
                break;
            }
            case 2: {
                l = SelectionManagerKt.getMagnifierCenter-JVtK1S4(manager, magnifierSize, selection2.getEnd());
                break;
            }
            case 3: {
                throw new IllegalStateException("SelectionContainer does not support cursor".toString());
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return l;
    }

    private static final long getMagnifierCenter-JVtK1S4(SelectionManager manager, long magnifierSize, Selection.AnchorInfo anchor) {
        float textConstrainedX;
        float f;
        Selectable selectable2 = manager.getAnchorSelectable$foundation(anchor);
        if (selectable2 == null) {
            return Offset.Companion.getUnspecified-F1C5BW0();
        }
        Selectable selectable3 = selectable2;
        LayoutCoordinates layoutCoordinates = manager.getContainerLayoutCoordinates();
        if (layoutCoordinates == null) {
            return Offset.Companion.getUnspecified-F1C5BW0();
        }
        LayoutCoordinates containerCoordinates = layoutCoordinates;
        LayoutCoordinates layoutCoordinates2 = selectable3.getLayoutCoordinates();
        if (layoutCoordinates2 == null) {
            return Offset.Companion.getUnspecified-F1C5BW0();
        }
        LayoutCoordinates selectableCoordinates = layoutCoordinates2;
        int offset2 = anchor.getOffset();
        if (offset2 > selectable3.getLastVisibleOffset()) {
            return Offset.Companion.getUnspecified-F1C5BW0();
        }
        Offset offset3 = manager.getCurrentDragPosition-_m7T9-E();
        Intrinsics.checkNotNull(offset3);
        long localDragPosition = selectableCoordinates.localPositionOf-R5De75A(containerCoordinates, offset3.unbox-impl());
        float dragX = Offset.getX-impl(localDragPosition);
        long lineRange = selectable3.getRangeOfLineContaining--jx7JFs(offset2);
        if (TextRange.getCollapsed-impl(lineRange)) {
            f = selectable3.getLineLeft(offset2);
        } else {
            float lineStartX = selectable3.getLineLeft(TextRange.getStart-impl(lineRange));
            float lineEndX = selectable3.getLineRight(TextRange.getEnd-impl(lineRange) - 1);
            float minX = Math.min(lineStartX, lineEndX);
            float maxX = Math.max(lineStartX, lineEndX);
            f = textConstrainedX = RangesKt.coerceIn(dragX, minX, maxX);
        }
        if (textConstrainedX == -1.0f) {
            return Offset.Companion.getUnspecified-F1C5BW0();
        }
        if (Math.abs(dragX - textConstrainedX) > (float)(IntSize.getWidth-impl(magnifierSize) / 2)) {
            return Offset.Companion.getUnspecified-F1C5BW0();
        }
        float lineCenterY = selectable3.getCenterYForOffset(offset2);
        if (lineCenterY == -1.0f) {
            return Offset.Companion.getUnspecified-F1C5BW0();
        }
        return containerCoordinates.localPositionOf-R5De75A(selectableCoordinates, OffsetKt.Offset(textConstrainedX, lineCenterY));
    }

    @NotNull
    public static final Rect visibleBounds(@NotNull LayoutCoordinates $this$visibleBounds) {
        Intrinsics.checkNotNullParameter($this$visibleBounds, "<this>");
        Rect boundsInWindow = LayoutCoordinatesKt.boundsInWindow($this$visibleBounds);
        return RectKt.Rect-0a9Yr6o($this$visibleBounds.windowToLocal-MK-Hz9U(boundsInWindow.getTopLeft-F1C5BW0()), $this$visibleBounds.windowToLocal-MK-Hz9U(boundsInWindow.getBottomRight-F1C5BW0()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean containsInclusive-Uv8p0NA(@NotNull Rect $this$containsInclusive_u2dUv8p0NA, long offset2) {
        Intrinsics.checkNotNullParameter($this$containsInclusive_u2dUv8p0NA, "$this$containsInclusive");
        float f = $this$containsInclusive_u2dUv8p0NA.getLeft();
        float f2 = $this$containsInclusive_u2dUv8p0NA.getRight();
        float f3 = Offset.getX-impl(offset2);
        if (!(f <= f3)) return false;
        if (!(f3 <= f2)) return false;
        boolean bl = true;
        if (!bl) return false;
        f = $this$containsInclusive_u2dUv8p0NA.getTop();
        f2 = $this$containsInclusive_u2dUv8p0NA.getBottom();
        f3 = Offset.getY-impl(offset2);
        if (!(f <= f3)) return false;
        if (!(f3 <= f2)) return false;
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private static final Object awaitPointerEventWhereAllChanges(AwaitPointerEventScope var0, PointerEventPass var1_1, Function1<? super PointerInputChange, Boolean> var2_2, Continuation<? super PointerEvent> var3_3) {
        if (!(var3_3 instanceof awaitPointerEventWhereAllChanges.1)) ** GOTO lbl-1000
        var17_4 = var3_3;
        if ((var17_4.label & -2147483648) != 0) {
            var17_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl((Continuation<? super awaitPointerEventWhereAllChanges.1>)var3_3){
                Object L$0;
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return SelectionManagerKt.access$awaitPointerEventWhereAllChanges(null, null, null, this);
                }
            };
        }
        $result = $continuation.result;
        var18_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure($result);
                $continuation.L$0 = predicate;
                $continuation.label = 1;
                v0 = $this$awaitPointerEventWhereAllChanges.awaitPointerEvent((PointerEventPass)pass, $continuation);
                if (v0 == var18_6) {
                    return var18_6;
                }
                ** GOTO lbl22
            }
            case 1: {
                predicate = (Function1)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v0 = $result;
lbl22:
                // 2 sources

                var4_7 = v0;
                it = (PointerEvent)var4_7;
                $i$a$-takeIf-SelectionManagerKt$awaitPointerEventWhereAllChanges$2 = false;
                $this$fastAll$iv = it.getChanges();
                $i$f$fastAll = false;
                $this$fastForEach$iv$iv = $this$fastAll$iv;
                $i$f$fastForEach = false;
                var12_15 = $this$fastForEach$iv$iv.size();
                for (index$iv$iv = 0; index$iv$iv < var12_15; ++index$iv$iv) {
                    it$iv = item$iv$iv = $this$fastForEach$iv$iv.get(index$iv$iv);
                    $i$a$-fastForEach-ListUtilsKt$fastAll$2$iv = false;
                    if (((Boolean)predicate.invoke(it$iv)).booleanValue()) continue;
                    v1 = false;
                    ** GOTO lbl40
                }
                v1 = true;
lbl40:
                // 2 sources

                return v1 != false ? var4_7 : null;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    static /* synthetic */ Object awaitPointerEventWhereAllChanges$default(AwaitPointerEventScope awaitPointerEventScope2, PointerEventPass pointerEventPass, Function1 function1, Continuation continuation, int n, Object object) {
        if ((n & 1) != 0) {
            pointerEventPass = PointerEventPass.Main;
        }
        return SelectionManagerKt.awaitPointerEventWhereAllChanges(awaitPointerEventScope2, pointerEventPass, function1, continuation);
    }

    public static final /* synthetic */ List access$firstAndLast(List $receiver) {
        return SelectionManagerKt.firstAndLast($receiver);
    }

    public static final /* synthetic */ Rect access$getInvertedInfiniteRect$p() {
        return invertedInfiniteRect;
    }

    public static final /* synthetic */ Object access$awaitPointerEventWhereAllChanges(AwaitPointerEventScope $receiver, PointerEventPass pass, Function1 predicate, Continuation $completion) {
        return SelectionManagerKt.awaitPointerEventWhereAllChanges($receiver, pass, predicate, $completion);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Handle.values().length];
            try {
                nArray[Handle.SelectionStart.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Handle.SelectionEnd.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Handle.Cursor.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

