/*
 * Decompiled with CFR 0.152.
 */
package androidx.collection;

import androidx.annotation.IntRange;
import androidx.collection.FloatList;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0014\n\u0002\b\u0011\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0018\u0010\b\u001a\u00020\f2\b\b\u0001\u0010\r\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0001J\u000e\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010J\u0018\u0010\u000e\u001a\u00020\t2\b\b\u0001\u0010\r\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0001J\u0018\u0010\u000e\u001a\u00020\t2\b\b\u0001\u0010\r\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0011\u001a\u00020\fJ\u000e\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0003J\u0011\u0010\u0013\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0001H\u0086\u0002J\u0011\u0010\u0013\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u000bH\u0086\nJ\u0011\u0010\u0013\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0086\u0002J\u0011\u0010\u0014\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0001H\u0086\u0002J\u0011\u0010\u0014\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u000bH\u0086\nJ\u0011\u0010\u0014\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0086\u0002J\u000e\u0010\u0015\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u0016\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0001J\u000e\u0010\u0016\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0017\u001a\u00020\u000b2\b\b\u0001\u0010\r\u001a\u00020\u0003J\u001a\u0010\u0018\u001a\u00020\f2\b\b\u0001\u0010\u0019\u001a\u00020\u00032\b\b\u0001\u0010\u001a\u001a\u00020\u0003J\u000e\u0010\u001b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0001J\u000e\u0010\u001b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010J\u001b\u0010\u001c\u001a\u00020\u000b2\b\b\u0001\u0010\r\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0086\u0002J\u0006\u0010\u001d\u001a\u00020\fJ\u0006\u0010\u001e\u001a\u00020\fJ\u0010\u0010\u001f\u001a\u00020\f2\b\b\u0002\u0010 \u001a\u00020\u0003R\u0012\u0010\u0005\u001a\u00020\u00038\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006!"}, d2={"Landroidx/collection/MutableFloatList;", "Landroidx/collection/FloatList;", "initialCapacity", "", "(I)V", "capacity", "getCapacity", "()I", "add", "", "element", "", "", "index", "addAll", "elements", "", "clear", "ensureCapacity", "minusAssign", "plusAssign", "remove", "removeAll", "removeAt", "removeRange", "start", "end", "retainAll", "set", "sort", "sortDescending", "trim", "minCapacity", "collection"})
@SourceDebugExtension(value={"SMAP\nFloatList.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FloatList.kt\nandroidx/collection/MutableFloatList\n+ 2 FloatList.kt\nandroidx/collection/FloatList\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,969:1\n549#1:970\n70#2:971\n253#2,6:974\n70#2:980\n70#2:981\n70#2:982\n70#2:989\n70#2:990\n13614#3,2:972\n1687#3,6:983\n*S KotlinDebug\n*F\n+ 1 FloatList.kt\nandroidx/collection/MutableFloatList\n*L\n692#1:970\n753#1:971\n772#1:974,6\n783#1:980\n787#1:981\n834#1:982\n850#1:989\n869#1:990\n763#1:972,2\n836#1:983,6\n*E\n"})
public final class MutableFloatList
extends FloatList {
    public MutableFloatList(int initialCapacity) {
        super(initialCapacity, null);
    }

    public /* synthetic */ MutableFloatList(int n, int n2, DefaultConstructorMarker defaultConstructorMarker2) {
        if ((n2 & 1) != 0) {
            n = 16;
        }
        this(n);
    }

    public final int getCapacity() {
        boolean $i$f$getCapacity = false;
        return this.content.length;
    }

    public final boolean add(float element) {
        this.ensureCapacity(this._size + 1);
        this.content[this._size] = element;
        int n = this._size;
        this._size = n + 1;
        return true;
    }

    public final void add(@IntRange(from=0L) int index2, float element) {
        if (!(0 <= index2 ? index2 <= this._size : false)) {
            throw new IndexOutOfBoundsException("Index " + index2 + " must be in 0.." + this._size);
        }
        this.ensureCapacity(this._size + 1);
        float[] content = this.content;
        if (index2 != this._size) {
            ArraysKt.copyInto(content, content, index2 + 1, index2, this._size);
        }
        content[index2] = element;
        int n = this._size;
        this._size = n + 1;
    }

    public final boolean addAll(@IntRange(from=0L) int index2, @NotNull float[] elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        if (!(0 <= index2 ? index2 <= this._size : false)) {
            throw new IndexOutOfBoundsException("Index " + index2 + " must be in 0.." + this._size);
        }
        if (elements.length == 0) {
            return false;
        }
        this.ensureCapacity(this._size + elements.length);
        float[] content = this.content;
        if (index2 != this._size) {
            ArraysKt.copyInto(content, content, index2 + elements.length, index2, this._size);
        }
        ArraysKt.copyInto$default(elements, content, index2, 0, 0, 12, null);
        this._size += elements.length;
        return true;
    }

    public final boolean addAll(@IntRange(from=0L) int index2, @NotNull FloatList elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        if (!(0 <= index2 ? index2 <= this._size : false)) {
            throw new IndexOutOfBoundsException("Index " + index2 + " must be in 0.." + this._size);
        }
        if (elements.isEmpty()) {
            return false;
        }
        this.ensureCapacity(this._size + elements._size);
        float[] content = this.content;
        if (index2 != this._size) {
            ArraysKt.copyInto(content, content, index2 + elements._size, index2, this._size);
        }
        ArraysKt.copyInto(elements.content, content, index2, 0, elements._size);
        this._size += elements._size;
        return true;
    }

    public final boolean addAll(@NotNull FloatList elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        return this.addAll(this._size, elements);
    }

    public final boolean addAll(@NotNull float[] elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        return this.addAll(this._size, elements);
    }

    public final void plusAssign(@NotNull FloatList elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        this.addAll(this._size, elements);
    }

    public final void plusAssign(@NotNull float[] elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        this.addAll(this._size, elements);
    }

    public final void clear() {
        this._size = 0;
    }

    public final void trim(int minCapacity) {
        int minSize = Math.max(minCapacity, this._size);
        MutableFloatList this_$iv = this;
        boolean $i$f$getCapacity = false;
        if (this_$iv.content.length > minSize) {
            float[] fArray = Arrays.copyOf(this.content, minSize);
            Intrinsics.checkNotNullExpressionValue(fArray, "copyOf(this, newSize)");
            this.content = fArray;
        }
    }

    public static /* synthetic */ void trim$default(MutableFloatList mutableFloatList, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = mutableFloatList._size;
        }
        mutableFloatList.trim(n);
    }

    public final void ensureCapacity(int capacity) {
        float[] oldContent = this.content;
        if (oldContent.length < capacity) {
            int newSize = Math.max(capacity, oldContent.length * 3 / 2);
            float[] fArray = Arrays.copyOf(oldContent, newSize);
            Intrinsics.checkNotNullExpressionValue(fArray, "copyOf(this, newSize)");
            this.content = fArray;
        }
    }

    public final void plusAssign(float element) {
        boolean $i$f$plusAssign = false;
        this.add(element);
    }

    public final void minusAssign(float element) {
        boolean $i$f$minusAssign = false;
        this.remove(element);
    }

    public final boolean remove(float element) {
        int index2 = this.indexOf(element);
        if (index2 >= 0) {
            this.removeAt(index2);
            return true;
        }
        return false;
    }

    public final boolean removeAll(@NotNull float[] elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        int initialSize = this._size;
        int n = elements.length;
        for (int i = 0; i < n; ++i) {
            this.remove(elements[i]);
        }
        return initialSize != this._size;
    }

    public final boolean removeAll(@NotNull FloatList elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        int initialSize = this._size;
        int i = 0;
        FloatList this_$iv = elements;
        boolean $i$f$getLastIndex = false;
        int n = this_$iv._size - 1;
        if (i <= n) {
            while (true) {
                this.remove(elements.get(i));
                if (i == n) break;
                ++i;
            }
        }
        return initialSize != this._size;
    }

    public final void minusAssign(@NotNull float[] elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        float[] $this$forEach$iv = elements;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            float element$iv;
            float element = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            this.remove(element);
        }
    }

    public final void minusAssign(@NotNull FloatList elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        FloatList this_$iv = elements;
        boolean $i$f$forEach = false;
        float[] content$iv = this_$iv.content;
        int n = this_$iv._size;
        for (int i$iv = 0; i$iv < n; ++i$iv) {
            float element = content$iv[i$iv];
            boolean bl = false;
            this.remove(element);
        }
    }

    public final float removeAt(@IntRange(from=0L) int index2) {
        if (!(0 <= index2 ? index2 < this._size : false)) {
            FloatList this_$iv = this;
            boolean $i$f$getLastIndex = false;
            throw new IndexOutOfBoundsException("Index " + index2 + " must be in 0.." + (this_$iv._size - 1));
        }
        float[] content = this.content;
        float item2 = content[index2];
        FloatList this_$iv = this;
        boolean $i$f$getLastIndex = false;
        if (index2 != this_$iv._size - 1) {
            ArraysKt.copyInto(content, content, index2, index2 + 1, this._size);
        }
        int n = this._size;
        this._size = n + -1;
        return item2;
    }

    public final void removeRange(@IntRange(from=0L) int start2, @IntRange(from=0L) int end2) {
        block7: {
            block6: {
                boolean bl = 0 <= start2 ? start2 <= this._size : false;
                if (!bl) break block6;
                if (0 <= end2 ? end2 <= this._size : false) break block7;
            }
            throw new IndexOutOfBoundsException("Start (" + start2 + ") and end (" + end2 + ") must be in 0.." + this._size);
        }
        if (end2 < start2) {
            throw new IllegalArgumentException("Start (" + start2 + ") is more than end (" + end2 + ')');
        }
        if (end2 != start2) {
            if (end2 < this._size) {
                ArraysKt.copyInto(this.content, this.content, start2, end2, this._size);
            }
            this._size -= end2 - start2;
        }
    }

    public final boolean retainAll(@NotNull float[] elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        int initialSize = this._size;
        float[] content = this.content;
        FloatList this_$iv = this;
        boolean $i$f$getLastIndex = false;
        for (int i = this_$iv._size - 1; -1 < i; --i) {
            int n;
            block2: {
                float item2 = content[i];
                float[] $this$indexOfFirst$iv = elements;
                boolean $i$f$indexOfFirst = false;
                int n2 = $this$indexOfFirst$iv.length;
                for (int index$iv = 0; index$iv < n2; ++index$iv) {
                    float it = $this$indexOfFirst$iv[index$iv];
                    boolean bl = false;
                    if (!(it == item2)) continue;
                    n = index$iv;
                    break block2;
                }
                n = -1;
            }
            if (n >= 0) continue;
            this.removeAt(i);
        }
        return initialSize != this._size;
    }

    public final boolean retainAll(@NotNull FloatList elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        int initialSize = this._size;
        float[] content = this.content;
        FloatList this_$iv = this;
        boolean $i$f$getLastIndex = false;
        for (int i = this_$iv._size - 1; -1 < i; --i) {
            float item2 = content[i];
            if (elements.contains(item2)) continue;
            this.removeAt(i);
        }
        return initialSize != this._size;
    }

    public final float set(@IntRange(from=0L) int index2, float element) {
        if (!(0 <= index2 ? index2 < this._size : false)) {
            FloatList this_$iv = this;
            boolean $i$f$getLastIndex = false;
            throw new IndexOutOfBoundsException("set index " + index2 + " must be between 0 .. " + (this_$iv._size - 1));
        }
        float[] content = this.content;
        float old = content[index2];
        content[index2] = element;
        return old;
    }

    public final void sort() {
        ArraysKt.sort(this.content, 0, this._size);
    }

    public final void sortDescending() {
        ArraysKt.sortDescending(this.content, 0, this._size);
    }

    public MutableFloatList() {
        this(0, 1, null);
    }
}

