/*
 * Decompiled with CFR 0.152.
 */
package androidx.collection;

import androidx.collection.FloatFloatMap;
import androidx.collection.FloatList;
import androidx.collection.FloatSet;
import androidx.collection.ScatterMapKt;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.ULong;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0014\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0006\u001a\u00020\u0007H\u0002J\u0006\u0010\b\u001a\u00020\u0007J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0003H\u0002J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rH\u0002J\"\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\r0\u0010H\u0086\b\u00f8\u0001\u0000J\b\u0010\u0011\u001a\u00020\u0007H\u0002J\u0010\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0003H\u0002J\u0010\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0011\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0017H\u0086\nJ\u0011\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0018H\u0086\nJ\u0011\u0010\u0015\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0086\nJ\u0011\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0019H\u0086\nJ\u0011\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u0001H\u0086\nJ\u0016\u0010\u001c\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\rJ\u001e\u0010\u001c\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\rJ\u000e\u0010\u001f\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u0001J\u000e\u0010 \u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010 \u001a\u00020!2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\rJ&\u0010\"\u001a\u00020\u00072\u0018\u0010#\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020!0$H\u0086\b\u00f8\u0001\u0000J\u0010\u0010%\u001a\u00020\u00072\u0006\u0010&\u001a\u00020\u0003H\u0001J\u0010\u0010'\u001a\u00020\u00072\u0006\u0010(\u001a\u00020\u0003H\u0002J\u0019\u0010)\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\rH\u0086\u0002J\u0006\u0010*\u001a\u00020\u0003J\u0019\u0010+\u001a\u00020\u00072\u0006\u0010&\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020,H\u0082\bR\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006-"}, d2={"Landroidx/collection/MutableFloatFloatMap;", "Landroidx/collection/FloatFloatMap;", "initialCapacity", "", "(I)V", "growthLimit", "adjustStorage", "", "clear", "findFirstAvailableSlot", "hash1", "findInsertIndex", "key", "", "getOrPut", "defaultValue", "Lkotlin/Function0;", "initializeGrowth", "initializeMetadata", "capacity", "initializeStorage", "minusAssign", "keys", "Landroidx/collection/FloatList;", "Landroidx/collection/FloatSet;", "", "plusAssign", "from", "put", "value", "default", "putAll", "remove", "", "removeIf", "predicate", "Lkotlin/Function2;", "removeValueAt", "index", "resizeStorage", "newCapacity", "set", "trim", "writeMetadata", "", "collection"})
@SourceDebugExtension(value={"SMAP\nFloatFloatMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FloatFloatMap.kt\nandroidx/collection/MutableFloatFloatMap\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ScatterMap.kt\nandroidx/collection/ScatterMapKt\n+ 4 FloatFloatMap.kt\nandroidx/collection/FloatFloatMap\n+ 5 FloatSet.kt\nandroidx/collection/FloatSet\n+ 6 FloatList.kt\nandroidx/collection/FloatList\n+ 7 FloatSet.kt\nandroidx/collection/FloatSetKt\n*L\n1#1,1031:1\n1021#1,2:1118\n1025#1,5:1126\n1021#1,2:1157\n1025#1,5:1165\n1021#1,2:1182\n1025#1,5:1190\n1#2:1032\n1656#3,6:1033\n1810#3:1049\n1672#3:1053\n1810#3:1071\n1672#3:1075\n1810#3:1096\n1672#3:1100\n1656#3,6:1120\n1656#3,6:1131\n1599#3:1140\n1603#3:1141\n1779#3,3:1142\n1793#3,3:1145\n1717#3:1148\n1705#3:1149\n1699#3:1150\n1712#3:1151\n1802#3:1152\n1666#3:1153\n1645#3:1154\n1664#3:1155\n1645#3:1156\n1656#3,6:1159\n1779#3,3:1170\n1810#3:1173\n1699#3:1174\n1669#3:1175\n1645#3:1176\n1599#3:1180\n1603#3:1181\n1656#3,6:1184\n1656#3,6:1195\n1656#3,6:1201\n385#4,4:1039\n357#4,6:1043\n367#4,3:1050\n370#4,2:1054\n389#4,2:1056\n373#4,6:1058\n391#4:1064\n357#4,6:1065\n367#4,3:1072\n370#4,9:1076\n262#5,4:1085\n232#5,7:1089\n243#5,3:1097\n246#5,2:1101\n266#5,2:1103\n249#5,6:1105\n268#5:1111\n253#6,6:1112\n833#7,3:1137\n833#7,3:1177\n*S KotlinDebug\n*F\n+ 1 FloatFloatMap.kt\nandroidx/collection/MutableFloatFloatMap\n*L\n875#1:1118,2\n875#1:1126,5\n933#1:1157,2\n933#1:1165,5\n1008#1:1182,2\n1008#1:1190,5\n711#1:1033,6\n789#1:1049\n789#1:1053\n828#1:1071\n828#1:1075\n855#1:1096\n855#1:1100\n875#1:1120,6\n885#1:1131,6\n899#1:1140\n900#1:1141\n907#1:1142,3\n908#1:1145,3\n909#1:1148\n910#1:1149\n910#1:1150\n914#1:1151\n917#1:1152\n926#1:1153\n926#1:1154\n932#1:1155\n932#1:1156\n933#1:1159,6\n948#1:1170,3\n949#1:1173\n951#1:1174\n1003#1:1175\n1003#1:1176\n1006#1:1180\n1008#1:1181\n1008#1:1184,6\n1022#1:1195,6\n1028#1:1201,6\n789#1:1039,4\n789#1:1043,6\n789#1:1050,3\n789#1:1054,2\n789#1:1056,2\n789#1:1058,6\n789#1:1064\n828#1:1065,6\n828#1:1072,3\n828#1:1076,9\n855#1:1085,4\n855#1:1089,7\n855#1:1097,3\n855#1:1101,2\n855#1:1103,2\n855#1:1105,6\n855#1:1111\n864#1:1112,6\n898#1:1137,3\n1005#1:1177,3\n*E\n"})
public final class MutableFloatFloatMap
extends FloatFloatMap {
    private int growthLimit;

    public MutableFloatFloatMap(int initialCapacity) {
        super(null);
        if (!(initialCapacity >= 0)) {
            boolean bl = false;
            String string = "Capacity must be a positive value.";
            throw new IllegalArgumentException(string.toString());
        }
        this.initializeStorage(ScatterMapKt.unloadedCapacity(initialCapacity));
    }

    public /* synthetic */ MutableFloatFloatMap(int n, int n2, DefaultConstructorMarker defaultConstructorMarker2) {
        if ((n2 & 1) != 0) {
            n = 6;
        }
        this(n);
    }

    private final void initializeStorage(int initialCapacity) {
        int newCapacity;
        this._capacity = newCapacity = initialCapacity > 0 ? Math.max(7, ScatterMapKt.normalizeCapacity(initialCapacity)) : 0;
        this.initializeMetadata(newCapacity);
        this.keys = new float[newCapacity];
        this.values = new float[newCapacity];
    }

    /*
     * WARNING - void declaration
     */
    private final void initializeMetadata(int capacity) {
        void data$iv;
        long[] lArray;
        MutableFloatFloatMap mutableFloatFloatMap = this;
        if (capacity == 0) {
            lArray = ScatterMapKt.EmptyGroup;
        } else {
            void $this$initializeMetadata_u24lambda_u241;
            long[] lArray2;
            int size2 = (capacity + 1 + 7 + 7 & 0xFFFFFFF8) >> 3;
            long[] lArray3 = lArray2 = new long[size2];
            MutableFloatFloatMap mutableFloatFloatMap2 = mutableFloatFloatMap;
            boolean bl = false;
            ArraysKt.fill$default((long[])$this$initializeMetadata_u24lambda_u241, -9187201950435737472L, 0, 0, 6, null);
            mutableFloatFloatMap = mutableFloatFloatMap2;
            lArray = lArray2;
        }
        mutableFloatFloatMap.metadata = lArray;
        long[] size2 = this.metadata;
        long value$iv = 255L;
        boolean $i$f$writeRawMetadata = false;
        int i$iv = capacity >> 3;
        int b$iv = (capacity & 7) << 3;
        data$iv[i$iv] = data$iv[i$iv] & (255L << b$iv ^ 0xFFFFFFFFFFFFFFFFL) | value$iv << b$iv;
        this.initializeGrowth();
    }

    private final void initializeGrowth() {
        this.growthLimit = ScatterMapKt.loadedCapacity(this.getCapacity()) - this._size;
    }

    public final float getOrPut(float key, @NotNull Function0<Float> defaultValue) {
        float f;
        Intrinsics.checkNotNullParameter(defaultValue, "defaultValue");
        boolean $i$f$getOrPut = false;
        int index2 = this.findKeyIndex(key);
        if (index2 < 0) {
            float defValue = ((Number)defaultValue.invoke()).floatValue();
            this.put(key, defValue);
            f = defValue;
        } else {
            f = this.values[index2];
        }
        return f;
    }

    public final void set(float key, float value) {
        int index2 = this.findInsertIndex(key);
        if (index2 < 0) {
            index2 ^= 0xFFFFFFFF;
        }
        this.keys[index2] = key;
        this.values[index2] = value;
    }

    public final void put(float key, float value) {
        this.set(key, value);
    }

    public final float put(float key, float value, float f) {
        int index2 = this.findInsertIndex(key);
        float previous = f;
        if (index2 < 0) {
            index2 ^= 0xFFFFFFFF;
        } else {
            previous = this.values[index2];
        }
        this.keys[index2] = key;
        this.values[index2] = value;
        return previous;
    }

    /*
     * WARNING - void declaration
     */
    public final void putAll(@NotNull FloatFloatMap from) {
        Intrinsics.checkNotNullParameter(from, "from");
        FloatFloatMap this_$iv = from;
        boolean $i$f$forEach = false;
        float[] k$iv = this_$iv.keys;
        float[] v$iv = this_$iv.values;
        FloatFloatMap this_$iv$iv = this_$iv;
        boolean $i$f$forEachIndexed = false;
        long[] m$iv$iv = this_$iv$iv.metadata;
        int lastIndex$iv$iv = m$iv$iv.length - 2;
        int i$iv$iv = 0;
        if (i$iv$iv <= lastIndex$iv$iv) {
            while (true) {
                long slot$iv$iv;
                long $this$maskEmptyOrDeleted$iv$iv$iv = slot$iv$iv = m$iv$iv[i$iv$iv];
                boolean $i$f$maskEmptyOrDeleted = false;
                if (($this$maskEmptyOrDeleted$iv$iv$iv & ($this$maskEmptyOrDeleted$iv$iv$iv ^ 0xFFFFFFFFFFFFFFFFL) << 7 & 0x8080808080808080L) != -9187201950435737472L) {
                    int bitCount$iv$iv = 8 - (~(i$iv$iv - lastIndex$iv$iv) >>> 31);
                    for (int j$iv$iv = 0; j$iv$iv < bitCount$iv$iv; ++j$iv$iv) {
                        long value$iv$iv$iv = slot$iv$iv & 0xFFL;
                        boolean $i$f$isFull = false;
                        if (value$iv$iv$iv < 128L) {
                            void value;
                            int index$iv$iv;
                            int index$iv = index$iv$iv = (i$iv$iv << 3) + j$iv$iv;
                            boolean bl = false;
                            float f = v$iv[index$iv];
                            float key = k$iv[index$iv];
                            boolean bl2 = false;
                            this.set(key, (float)value);
                        }
                        slot$iv$iv >>= 8;
                    }
                    if (bitCount$iv$iv != 8) break;
                }
                if (i$iv$iv == lastIndex$iv$iv) break;
                ++i$iv$iv;
            }
        }
    }

    public final void plusAssign(@NotNull FloatFloatMap from) {
        Intrinsics.checkNotNullParameter(from, "from");
        boolean $i$f$plusAssign = false;
        this.putAll(from);
    }

    public final void remove(float key) {
        int index2 = this.findKeyIndex(key);
        if (index2 >= 0) {
            this.removeValueAt(index2);
        }
    }

    public final boolean remove(float key, float value) {
        int index2 = this.findKeyIndex(key);
        if (index2 >= 0 && this.values[index2] == value) {
            this.removeValueAt(index2);
            return true;
        }
        return false;
    }

    public final void removeIf(@NotNull Function2<? super Float, ? super Float, Boolean> predicate) {
        Intrinsics.checkNotNullParameter(predicate, "predicate");
        boolean $i$f$removeIf = false;
        FloatFloatMap this_$iv = this;
        boolean $i$f$forEachIndexed = false;
        long[] m$iv = this_$iv.metadata;
        int lastIndex$iv = m$iv.length - 2;
        int i$iv = 0;
        if (i$iv <= lastIndex$iv) {
            while (true) {
                long slot$iv;
                long $this$maskEmptyOrDeleted$iv$iv = slot$iv = m$iv[i$iv];
                boolean $i$f$maskEmptyOrDeleted = false;
                if (($this$maskEmptyOrDeleted$iv$iv & ($this$maskEmptyOrDeleted$iv$iv ^ 0xFFFFFFFFFFFFFFFFL) << 7 & 0x8080808080808080L) != -9187201950435737472L) {
                    int bitCount$iv = 8 - (~(i$iv - lastIndex$iv) >>> 31);
                    for (int j$iv = 0; j$iv < bitCount$iv; ++j$iv) {
                        long value$iv$iv = slot$iv & 0xFFL;
                        boolean $i$f$isFull = false;
                        if (value$iv$iv < 128L) {
                            int index$iv;
                            int index2 = index$iv = (i$iv << 3) + j$iv;
                            boolean bl = false;
                            if (predicate.invoke(Float.valueOf(this.keys[index2]), Float.valueOf(this.values[index2])).booleanValue()) {
                                this.removeValueAt(index2);
                            }
                        }
                        slot$iv >>= 8;
                    }
                    if (bitCount$iv != 8) break;
                }
                if (i$iv == lastIndex$iv) break;
                ++i$iv;
            }
        }
    }

    public final void minusAssign(float key) {
        boolean $i$f$minusAssign = false;
        this.remove(key);
    }

    public final void minusAssign(@NotNull float[] keys2) {
        Intrinsics.checkNotNullParameter(keys2, "keys");
        boolean $i$f$minusAssign = false;
        for (float key : keys2) {
            this.remove(key);
        }
    }

    public final void minusAssign(@NotNull FloatSet keys2) {
        Intrinsics.checkNotNullParameter(keys2, "keys");
        boolean $i$f$minusAssign = false;
        FloatSet this_$iv = keys2;
        boolean $i$f$forEach = false;
        float[] k$iv = this_$iv.elements;
        FloatSet this_$iv$iv = this_$iv;
        boolean $i$f$forEachIndex = false;
        long[] m$iv$iv = this_$iv$iv.metadata;
        int lastIndex$iv$iv = m$iv$iv.length - 2;
        int i$iv$iv = 0;
        if (i$iv$iv <= lastIndex$iv$iv) {
            while (true) {
                long slot$iv$iv;
                long $this$maskEmptyOrDeleted$iv$iv$iv = slot$iv$iv = m$iv$iv[i$iv$iv];
                boolean $i$f$maskEmptyOrDeleted = false;
                if (($this$maskEmptyOrDeleted$iv$iv$iv & ($this$maskEmptyOrDeleted$iv$iv$iv ^ 0xFFFFFFFFFFFFFFFFL) << 7 & 0x8080808080808080L) != -9187201950435737472L) {
                    int bitCount$iv$iv = 8 - (~(i$iv$iv - lastIndex$iv$iv) >>> 31);
                    for (int j$iv$iv = 0; j$iv$iv < bitCount$iv$iv; ++j$iv$iv) {
                        long value$iv$iv$iv = slot$iv$iv & 0xFFL;
                        boolean $i$f$isFull = false;
                        if (value$iv$iv$iv < 128L) {
                            int index$iv$iv;
                            int index$iv = index$iv$iv = (i$iv$iv << 3) + j$iv$iv;
                            boolean bl = false;
                            float key = k$iv[index$iv];
                            boolean bl2 = false;
                            this.remove(key);
                        }
                        slot$iv$iv >>= 8;
                    }
                    if (bitCount$iv$iv != 8) break;
                }
                if (i$iv$iv == lastIndex$iv$iv) break;
                ++i$iv$iv;
            }
        }
    }

    public final void minusAssign(@NotNull FloatList keys2) {
        Intrinsics.checkNotNullParameter(keys2, "keys");
        boolean $i$f$minusAssign = false;
        FloatList this_$iv = keys2;
        boolean $i$f$forEach = false;
        float[] content$iv = this_$iv.content;
        int n = this_$iv._size;
        for (int i$iv = 0; i$iv < n; ++i$iv) {
            float key = content$iv[i$iv];
            boolean bl = false;
            this.remove(key);
        }
    }

    /*
     * WARNING - void declaration
     */
    @PublishedApi
    public final void removeValueAt(int index2) {
        void this_$iv;
        --this._size;
        MutableFloatFloatMap mutableFloatFloatMap = this;
        long value$iv = 254L;
        boolean $i$f$writeMetadata = false;
        long[] m$iv = this_$iv.metadata;
        boolean $i$f$writeRawMetadata = false;
        int i$iv$iv = index2 >> 3;
        int b$iv$iv = (index2 & 7) << 3;
        m$iv[i$iv$iv] = m$iv[i$iv$iv] & (255L << b$iv$iv ^ 0xFFFFFFFFFFFFFFFFL) | value$iv << b$iv$iv;
        int c$iv = this_$iv._capacity;
        int cloneIndex$iv = (index2 - 7 & c$iv) + (7 & c$iv);
        boolean $i$f$writeRawMetadata2 = false;
        int i$iv$iv2 = cloneIndex$iv >> 3;
        int b$iv$iv2 = (cloneIndex$iv & 7) << 3;
        m$iv[i$iv$iv2] = m$iv[i$iv$iv2] & (255L << b$iv$iv2 ^ 0xFFFFFFFFFFFFFFFFL) | value$iv << b$iv$iv2;
    }

    /*
     * WARNING - void declaration
     */
    public final void clear() {
        this._size = 0;
        if (this.metadata != ScatterMapKt.EmptyGroup) {
            void data$iv;
            void offset$iv;
            ArraysKt.fill$default(this.metadata, -9187201950435737472L, 0, 0, 6, null);
            long[] lArray = this.metadata;
            int n = this._capacity;
            long value$iv = 255L;
            boolean $i$f$writeRawMetadata = false;
            void i$iv = offset$iv >> 3;
            int b$iv = (offset$iv & 7) << 3;
            data$iv[i$iv] = data$iv[i$iv] & (255L << b$iv ^ 0xFFFFFFFFFFFFFFFFL) | value$iv << b$iv;
        }
        this.initializeGrowth();
    }

    /*
     * WARNING - void declaration
     */
    private final int findInsertIndex(float key) {
        void this_$iv;
        boolean $i$f$readRawMetadata;
        Object metadata$iv;
        boolean $i$f$hash = false;
        int hash$iv = Float.hashCode(key) * -862048943;
        int hash = hash$iv ^ hash$iv << 16;
        boolean $i$f$h1 = false;
        int hash1 = hash >>> 7;
        boolean $i$f$h2 = false;
        int hash2 = hash & 0x7F;
        int probeMask = this._capacity;
        int probeOffset = hash1 & probeMask;
        int probeIndex = 0;
        while (true) {
            long g;
            long[] metadata$iv2 = this.metadata;
            boolean $i$f$group = false;
            int i$iv = probeOffset >> 3;
            int b$iv = (probeOffset & 7) << 3;
            long $this$match$iv = g = metadata$iv2[i$iv] >>> b$iv | metadata$iv2[i$iv + 1] << 64 - b$iv & -((long)b$iv) >> 63;
            boolean $i$f$match = false;
            long x$iv = $this$match$iv ^ 0x101010101010101L * (long)hash2;
            long m = x$iv - 0x101010101010101L & (x$iv ^ 0xFFFFFFFFFFFFFFFFL) & 0x8080808080808080L;
            while (true) {
                long $this$hasNext$iv = m;
                boolean $i$f$hasNext = false;
                if (!($this$hasNext$iv != 0L)) break;
                long $this$get$iv = m;
                boolean $i$f$get = false;
                long $this$lowestBitSet$iv$iv = $this$get$iv;
                boolean $i$f$lowestBitSet = false;
                int index2 = probeOffset + (Long.numberOfTrailingZeros($this$lowestBitSet$iv$iv) >> 3) & probeMask;
                if (this.keys[index2] == key) {
                    return index2;
                }
                long $this$next$iv = m;
                boolean $i$f$next = false;
                m = $this$next$iv & $this$next$iv - 1L;
            }
            long $this$maskEmpty$iv = g;
            boolean $i$f$maskEmpty = false;
            if (($this$maskEmpty$iv & ($this$maskEmpty$iv ^ 0xFFFFFFFFFFFFFFFFL) << 6 & 0x8080808080808080L) != 0L) break;
            probeOffset = probeOffset + (probeIndex += 8) & probeMask;
        }
        int index3 = this.findFirstAvailableSlot(hash1);
        if (this.growthLimit == 0) {
            metadata$iv = this.metadata;
            boolean $i$f$isDeleted = false;
            $i$f$readRawMetadata = false;
            if (!((metadata$iv[index3 >> 3] >> ((index3 & 7) << 3) & 0xFFL) == 254L)) {
                this.adjustStorage();
                index3 = this.findFirstAvailableSlot(hash1);
            }
        }
        ++this._size;
        metadata$iv = this.metadata;
        boolean $i$f$isEmpty = false;
        $i$f$readRawMetadata = false;
        this.growthLimit -= (metadata$iv[index3 >> 3] >> ((index3 & 7) << 3) & 0xFFL) == 128L ? 1 : 0;
        metadata$iv = this;
        long value$iv = hash2;
        boolean $i$f$writeMetadata = false;
        long[] m$iv = this_$iv.metadata;
        boolean $i$f$writeRawMetadata = false;
        int i$iv$iv = index3 >> 3;
        int b$iv$iv = (index3 & 7) << 3;
        m$iv[i$iv$iv] = m$iv[i$iv$iv] & (255L << b$iv$iv ^ 0xFFFFFFFFFFFFFFFFL) | value$iv << b$iv$iv;
        int c$iv = this_$iv._capacity;
        int cloneIndex$iv = (index3 - 7 & c$iv) + (7 & c$iv);
        boolean $i$f$writeRawMetadata2 = false;
        int i$iv$iv2 = cloneIndex$iv >> 3;
        int b$iv$iv2 = (cloneIndex$iv & 7) << 3;
        m$iv[i$iv$iv2] = m$iv[i$iv$iv2] & (255L << b$iv$iv2 ^ 0xFFFFFFFFFFFFFFFFL) | value$iv << b$iv$iv2;
        return ~index3;
    }

    private final int findFirstAvailableSlot(int hash1) {
        int probeMask = this._capacity;
        int probeOffset = hash1 & probeMask;
        int probeIndex = 0;
        while (true) {
            long g;
            long[] metadata$iv = this.metadata;
            boolean $i$f$group = false;
            int i$iv = probeOffset >> 3;
            int b$iv = (probeOffset & 7) << 3;
            long $this$maskEmptyOrDeleted$iv = g = metadata$iv[i$iv] >>> b$iv | metadata$iv[i$iv + 1] << 64 - b$iv & -((long)b$iv) >> 63;
            boolean $i$f$maskEmptyOrDeleted = false;
            long m = $this$maskEmptyOrDeleted$iv & ($this$maskEmptyOrDeleted$iv ^ 0xFFFFFFFFFFFFFFFFL) << 7 & 0x8080808080808080L;
            if (m != 0L) {
                long $this$lowestBitSet$iv = m;
                boolean $i$f$lowestBitSet = false;
                return probeOffset + (Long.numberOfTrailingZeros($this$lowestBitSet$iv) >> 3) & probeMask;
            }
            probeOffset = probeOffset + (probeIndex += 8) & probeMask;
        }
    }

    public final int trim() {
        int previousCapacity = this._capacity;
        int newCapacity = ScatterMapKt.normalizeCapacity(ScatterMapKt.unloadedCapacity(this._size));
        if (newCapacity < previousCapacity) {
            this.resizeStorage(newCapacity);
            return previousCapacity - this._capacity;
        }
        return 0;
    }

    private final void adjustStorage() {
        if (this._capacity > 8 && Long.compareUnsigned(ULong.constructor-impl(ULong.constructor-impl(this._size) * 32L), ULong.constructor-impl(ULong.constructor-impl(this._capacity) * 25L)) <= 0) {
            this.resizeStorage(ScatterMapKt.nextCapacity(this._capacity));
        } else {
            this.resizeStorage(ScatterMapKt.nextCapacity(this._capacity));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void resizeStorage(int newCapacity) {
        long[] previousMetadata = this.metadata;
        float[] previousKeys = this.keys;
        float[] previousValues = this.values;
        int previousCapacity = this._capacity;
        this.initializeStorage(newCapacity);
        float[] newKeys = this.keys;
        float[] newValues = this.values;
        for (int i = 0; i < previousCapacity; ++i) {
            void this_$iv;
            boolean $i$f$isFull = false;
            boolean $i$f$readRawMetadata = false;
            if (!((previousMetadata[i >> 3] >> ((i & 7) << 3) & 0xFFL) < 128L)) continue;
            float previousKey = previousKeys[i];
            boolean $i$f$hash = false;
            int hash$iv = Float.hashCode(previousKey) * -862048943;
            int hash = hash$iv ^ hash$iv << 16;
            boolean $i$f$h32 = false;
            int index2 = this.findFirstAvailableSlot(hash >>> 7);
            MutableFloatFloatMap $i$f$h32 = this;
            boolean $i$f$h2 = false;
            long value$iv = hash & 0x7F;
            boolean $i$f$writeMetadata = false;
            long[] m$iv = this_$iv.metadata;
            boolean $i$f$writeRawMetadata = false;
            int i$iv$iv = index2 >> 3;
            int b$iv$iv = (index2 & 7) << 3;
            m$iv[i$iv$iv] = m$iv[i$iv$iv] & (255L << b$iv$iv ^ 0xFFFFFFFFFFFFFFFFL) | value$iv << b$iv$iv;
            int c$iv = this_$iv._capacity;
            int cloneIndex$iv = (index2 - 7 & c$iv) + (7 & c$iv);
            boolean $i$f$writeRawMetadata2 = false;
            int i$iv$iv2 = cloneIndex$iv >> 3;
            int b$iv$iv2 = (cloneIndex$iv & 7) << 3;
            m$iv[i$iv$iv2] = m$iv[i$iv$iv2] & (255L << b$iv$iv2 ^ 0xFFFFFFFFFFFFFFFFL) | value$iv << b$iv$iv2;
            newKeys[index2] = previousKey;
            newValues[index2] = previousValues[i];
        }
    }

    private final void writeMetadata(int index2, long value) {
        boolean $i$f$writeMetadata = false;
        long[] m = this.metadata;
        boolean $i$f$writeRawMetadata = false;
        int i$iv = index2 >> 3;
        int b$iv = (index2 & 7) << 3;
        m[i$iv] = m[i$iv] & (255L << b$iv ^ 0xFFFFFFFFFFFFFFFFL) | value << b$iv;
        int c = this._capacity;
        int cloneIndex = (index2 - 7 & c) + (7 & c);
        boolean $i$f$writeRawMetadata2 = false;
        int i$iv2 = cloneIndex >> 3;
        int b$iv2 = (cloneIndex & 7) << 3;
        m[i$iv2] = m[i$iv2] & (255L << b$iv2 ^ 0xFFFFFFFFFFFFFFFFL) | value << b$iv2;
    }

    public MutableFloatFloatMap() {
        this(0, 1, null);
    }
}

